<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


// ✅ Load Page Header Settings
$settings = $pdo->query("SELECT * FROM mosque_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// ✅ Load all mosques
$mosques = $pdo->query("SELECT * FROM mosques ORDER BY type, position ASC")->fetchAll(PDO::FETCH_ASSOC);

$main = array_filter($mosques, fn($m) => $m['type'] == 'main');
$other = array_filter($mosques, fn($m) => $m['type'] == 'other');
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Mosques | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; text-decoration:none; border-bottom:1px solid #2f343a; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.2rem; margin-bottom:12px; }
</style>
</head>
<body>

<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">

  <h3 class="mb-4">Manage Mosques</h3>

  <?php if(isset($_GET['saved'])): ?>
    <div class="alert alert-success">✅ Saved successfully</div>
  <?php endif; ?>


  <!-- ✅ PAGE HEADER SETTINGS (MISSING PART ADDED HERE) -->
  <div class="card p-4 shadow-sm mb-4 section-card">
    <div class="section-title">🖼️ Page Header</div>

    <form action="mosque_save.php" method="POST" enctype="multipart/form-data">
      <input type="hidden" name="action" value="save_header">

      <label class="fw-bold mb-1">Page Title</label>
      <input type="text" name="page_title" class="form-control mb-2"
             value="<?= htmlspecialchars($settings['page_title'] ?? '') ?>" required>

      <label class="fw-bold mb-1">Page Subtitle</label>
      <textarea name="page_subtitle" class="form-control mb-2" rows="3" required><?= 
        htmlspecialchars($settings['page_subtitle'] ?? '') 
      ?></textarea>

      <label class="fw-bold mb-1">Header Background Image</label>
      <input type="file" name="bg_image" class="form-control mb-2">

      <?php if (!empty($settings['bg_image'])): ?>
        <img src="../<?= htmlspecialchars($settings['bg_image']) ?>" 
             style="max-width:220px" class="rounded mt-2">
      <?php endif; ?>

      <button class="btn btn-primary mt-3">Save Header</button>
    </form>
  </div>
  <!-- ✅ END HEADER SETTINGS -->




  <!-- ADD MOSQUE -->
  <div class="card p-4 shadow-sm mb-4 section-card">
    <div class="section-title">➕ Add New Mosque</div>

    <form action="mosque_save.php" method="POST">
      <input type="hidden" name="action" value="add">

      <div class="row g-2">
        <div class="col-md-4">
          <label class="fw-bold">Mosque Type</label>
          <select name="type" class="form-select" required>
            <option value="main">Main Mosque</option>
            <option value="other">Other Mosque</option>
          </select>
        </div>

        <div class="col-md-4">
          <label class="fw-bold">Position</label>
          <input type="number" name="position" class="form-control" value="100">
        </div>

        <div class="col-md-4">
          <label class="fw-bold">Show Prayer Button?</label>
          <select name="show_prayer_button" class="form-select">
            <option value="0">No</option>
            <option value="1">Yes</option>
          </select>
        </div>
      </div>

      <label class="fw-bold mt-3">Mosque Name</label>
      <input type="text" name="name" class="form-control mb-2" required>

      <label class="fw-bold">Address</label>
      <input type="text" name="address" class="form-control mb-2" required>

      <label class="fw-bold">Google Map Embed URL</label>
      <textarea name="map_embed" class="form-control mb-2" rows="3" required></textarea>

      <label class="fw-bold">Website (optional)</label>
      <input type="text" name="website" class="form-control">

      <button class="btn btn-success mt-3">Add Mosque</button>
    </form>
  </div>




  <!-- MAIN MOSQUES LIST -->
  <div class="card p-4 shadow-sm mb-4">
    <h4 class="section-title">🏛️ Main Mosques</h4>

    <?php foreach ($main as $m): ?>
      <div class="bg-white border rounded p-3 mb-2">
        <form action="mosque_save.php" method="POST">
          <input type="hidden" name="action" value="update">
          <input type="hidden" name="id" value="<?= $m['id'] ?>">

          <div class="row g-2">
            <div class="col-md-3">
              <label class="fw-bold">Name</label>
              <input type="text" name="name" class="form-control"
                     value="<?= htmlspecialchars($m['name']) ?>">
            </div>

            <div class="col-md-3">
              <label class="fw-bold">Position</label>
              <input type="number" name="position" class="form-control"
                     value="<?= $m['position'] ?>">
            </div>

            <div class="col-md-3">
              <label class="fw-bold">Show Prayer Button</label>
              <select name="show_prayer_button" class="form-select">
                <option value="0" <?= $m['show_prayer_button']==0?'selected':'' ?>>No</option>
                <option value="1" <?= $m['show_prayer_button']==1?'selected':'' ?>>Yes</option>
              </select>
            </div>
          </div>

          <label class="fw-bold mt-2">Address</label>
          <input type="text" name="address" class="form-control mb-2"
                 value="<?= htmlspecialchars($m['address']) ?>">

          <label class="fw-bold">Map Embed</label>
          <textarea name="map_embed" class="form-control mb-2" rows="3"><?= htmlspecialchars($m['map_embed']) ?></textarea>

          <label class="fw-bold">Website</label>
          <input type="text" name="website" class="form-control mb-2"
                 value="<?= htmlspecialchars($m['website']) ?>">

          <button class="btn btn-success btn-sm">Update</button>

          <button formaction="mosque_save.php"
                  name="action" value="delete"
                  class="btn btn-danger btn-sm float-end"
                  onclick="return confirm('Delete this mosque?');">
            Delete
          </button>
        </form>
      </div>
    <?php endforeach; ?>
  </div>




  <!-- OTHER MOSQUES LIST -->
  <div class="card p-4 shadow-sm mb-4">
    <h4 class="section-title">🏘️ Other Mosques</h4>

    <?php foreach ($other as $o): ?>
      <div class="bg-white border rounded p-3 mb-2">
        <form action="mosque_save.php" method="POST">
          <input type="hidden" name="action" value="update">
          <input type="hidden" name="id" value="<?= $o['id'] ?>">

          <div class="row g-2">
            <div class="col-md-4">
              <label class="fw-bold">Name</label>
              <input type="text" name="name" class="form-control"
                     value="<?= htmlspecialchars($o['name']) ?>">
            </div>

            <div class="col-md-4">
              <label class="fw-bold">Position</label>
              <input type="number" name="position" class="form-control"
                     value="<?= $o['position'] ?>">
            </div>
          </div>

          <label class="fw-bold mt-2">Address</label>
          <input type="text" name="address" class="form-control mb-2"
                 value="<?= htmlspecialchars($o['address']) ?>">

          <label class="fw-bold">Map Embed</label>
          <textarea name="map_embed" class="form-control mb-2" rows="3"><?= htmlspecialchars($o['map_embed']) ?></textarea>

          <label class="fw-bold">Website</label>
          <input type="text" name="website" class="form-control mb-2"
                 value="<?= htmlspecialchars($o['website']) ?>">

          <button class="btn btn-success btn-sm">Update</button>

          <button formaction="mosque_save.php"
                  name="action" value="delete"
                  class="btn btn-danger btn-sm float-end"
                  onclick="return confirm('Delete this mosque?');">
            Delete
          </button>
        </form>
      </div>
    <?php endforeach; ?>
  </div>




</div>
</div>
</body>
</html>
