<?php
ob_start();
require_once "db.php";
session_start();

// ✅ SECURITY CHECKS
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
    header("Location: index.php");
    exit;
}

// ---------- GLOBAL SETTINGS ----------
$set = $pdo->query("SELECT * FROM iaos_news_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if (!$set) {
    $pdo->exec("INSERT INTO iaos_news_settings (id,page_title,page_subtitle,bg_image)
                VALUES (1,'News Updates','New Mosque & community updates — Alhamdulillah, moving forward.','images/banner2.jpg')");
    $set = $pdo->query("SELECT * FROM iaos_news_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
}

// ---------- POSTS LIST ----------
$posts = $pdo->query("SELECT * FROM iaos_news_posts ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);
$selectedPostId = isset($_GET['id']) ? (int)$_GET['id'] : (count($posts) ? $posts[0]['id'] : 0);

// ---------- SELECTED POST ----------
$post = null;
if ($selectedPostId) {
    $stmt = $pdo->prepare("SELECT * FROM iaos_news_posts WHERE id=?");
    $stmt->execute([$selectedPostId]);
    $post = $stmt->fetch(PDO::FETCH_ASSOC);
}

// ---------- PARAGRAPHS ----------
$paras = [];
if ($post) {
    $stmt = $pdo->prepare("SELECT * FROM iaos_news_paragraphs WHERE post_id=? ORDER BY position ASC, id ASC");
    $stmt->execute([$post['id']]);
    $paras = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Manage News | IAOS Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background:#f5f6fa; }
        .admin-wrapper { display:flex; min-height:100vh; }
        .admin-sidebar { width:250px; background:#212529; color:#fff; }
        .admin-sidebar a { color:#ccc; padding:12px 20px; display:block; text-decoration:none; border-bottom:1px solid #2f343a; }
        .admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
        .admin-content { flex-grow:1; padding:30px; }
        .section-card { border-radius:10px; }
        .section-title { font-weight:700; font-size:1.2rem; margin-bottom:15px; }
        .small-note { font-size:.875rem; color:#6c757d; }
        img { max-width:200px; border-radius:6px; margin-top:10px; }
    </style>
</head>
<body>
<div class="admin-wrapper">

    <?php include "sidebar.php"; ?>

    <div class="admin-content">
        <h3 class="mb-4">Manage News Updates</h3>

        <?php if(isset($_GET['saved'])): ?>
            <div class="alert alert-success">✅ Saved successfully</div>
        <?php endif; ?>

        <!-- GLOBAL SETTINGS -->
        <div class="card p-4 shadow-sm mb-4 section-card">
            <div class="section-title">🖼️ Global Page Header</div>
            <form action="save_news.php" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="action" value="save_settings">
                <label>Page Title</label>
                <input type="text" name="page_title" class="form-control mb-2" value="<?= htmlspecialchars($set['page_title']) ?>">
                <label>Subtitle</label>
                <textarea name="page_subtitle" class="form-control mb-2"><?= htmlspecialchars($set['page_subtitle']) ?></textarea>
                <label>Background Image</label>
                <input type="file" name="bg_image" class="form-control mb-2">
                <?php if(!empty($set['bg_image'])): ?>
                    <img src="../<?= $set['bg_image'] ?>">
                <?php endif; ?>
                <button class="btn btn-primary mt-3">Save Header</button>
            </form>
        </div>

        <!-- SELECT / ADD POST -->
        <div class="card p-4 shadow-sm mb-4 section-card">
            <div class="section-title">📌 Select / Add News</div>

            <!-- SELECT POST -->
            <form method="GET" class="d-flex gap-2 mb-3">
                <select name="id" class="form-select" onchange="this.form.submit()">
                    <?php foreach($posts as $p): ?>
                        <option value="<?= $p['id'] ?>" <?= $p['id']==$selectedPostId?'selected':'' ?>>
                            <?= htmlspecialchars($p['intro_heading']) ?> (<?= htmlspecialchars($p['publish_date']) ?>)
                        </option>
                    <?php endforeach; ?>
                </select>
                <a href="admin_news.php" class="btn btn-outline-secondary">Reset</a>
            </form>

            <!-- ADD NEW POST -->
            <form action="save_news.php" method="POST" class="row g-2" enctype="multipart/form-data">
                <input type="hidden" name="action" value="add_post">
                <div class="col-md-6">
                    <label>News Title</label>
                    <input type="text" name="intro_heading" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label>Publish Date</label>
                    <input type="date" name="publish_date" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label>Button Link (optional)</label>
                    <input type="url" name="link" class="form-control" placeholder="https://example.com">
                </div>
                <div class="col-md-6">
                    <label>Button Text (optional)</label>
                    <input type="text" name="link_text" class="form-control" placeholder="Read More">
                </div>
                <div class="col-12">
                    <label>Intro Text</label>
                    <textarea name="intro_text" class="form-control" required></textarea>
                </div>
                <div class="col-12">
                    <label>News Image (optional)</label>
                    <input type="file" name="news_image" class="form-control">
                </div>
                <div class="col-12 d-flex align-items-end">
                    <button class="btn btn-success">Add News</button>
                </div>
            </form>
        </div>

        <?php if ($post): ?>
            <!-- EDIT SELECTED POST -->
            <div class="card p-4 shadow-sm mb-4 section-card">
                <div class="section-title">📝 Edit Selected News</div>
                <form action="save_news.php" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="action" value="save_post_intro">
                    <input type="hidden" name="post_id" value="<?= $post['id'] ?>">

                    <label>News Title</label>
                    <input type="text" name="intro_heading" class="form-control mb-2" value="<?= htmlspecialchars($post['intro_heading']) ?>">

                    <label>Intro Text</label>
                    <textarea name="intro_text" class="form-control mb-2"><?= htmlspecialchars($post['intro_text']) ?></textarea>

                    <label>Button Link (optional)</label>
                    <input type="url" name="link" class="form-control mb-2" value="<?= htmlspecialchars($post['link'] ?? '') ?>">

                    <label>Button Text (optional)</label>
                    <input type="text" name="link_text" class="form-control mb-2" value="<?= htmlspecialchars($post['link_text'] ?? 'Read More') ?>">

                    <label>News Image</label>
                    <input type="file" name="news_image" class="form-control mb-2">
                    <?php if (!empty($post['image'])): ?>
                        <img src="../<?= htmlspecialchars($post['image']) ?>">
                    <?php endif; ?>

                    <label>Publish Date</label>
                    <input type="date" name="publish_date" class="form-control" value="<?= $post['publish_date'] ?>">

                    <button class="btn btn-primary mt-3">Save</button>
                </form>

                <form action="save_news.php" method="POST" class="mt-3" onsubmit="return confirm('Delete this news?');">
                    <input type="hidden" name="action" value="delete_post">
                    <input type="hidden" name="post_id" value="<?= $post['id'] ?>">
                    <button class="btn btn-danger">Delete News</button>
                </form>
            </div>

            <!-- ADD PARAGRAPH -->
            <div class="card p-4 shadow-sm mb-4 section-card">
                <div class="section-title">➕ Add Additional Info Text</div>
                <form action="save_news.php" method="POST">
                    <input type="hidden" name="action" value="add_paragraph">
                    <input type="hidden" name="post_id" value="<?= $post['id'] ?>">
                    <textarea name="para_text" class="form-control mb-2" rows="3" placeholder="Write info text..." required></textarea>
                    <button class="btn btn-secondary btn-sm">Add</button>
                </form>
            </div>

            <!-- LIST PARAGRAPHS -->
            <?php foreach ($paras as $p): ?>
                <div class="card p-3 shadow-sm mb-2">
                    <form action="save_news.php" method="POST">
                        <input type="hidden" name="action" value="update_paragraph">
                        <input type="hidden" name="para_id" value="<?= $p['id'] ?>">
                        <input type="hidden" name="post_id" value="<?= $post['id'] ?>">
                        <textarea name="para_text" class="form-control mb-2" required><?= htmlspecialchars($p['para_text']) ?></textarea>
                        <div class="d-flex gap-2">
                            <button class="btn btn-success btn-sm">Update</button>
                            <button formaction="save_news.php" name="action" value="delete_paragraph"
                                    class="btn btn-danger btn-sm"
                                    onclick="return confirm('Delete this paragraph?')">Delete
                            </button>
                        </div>
                    </form>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>

    </div>
</div>
</body>
</html>
