<?php
ob_start();
require_once "db.php"; // ✅ must give $pdo

session_start();

// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK: Allow only admin OR newsletterController (C is capital)
if (!isset($_SESSION['role']) ||
    (strtolower($_SESSION['role']) !== 'admin' && $_SESSION['role'] !== 'newsletterController')) {
  header("Location: index.php");
  exit;
}

/* -----------------------------------------
   ✅ GLOBAL SETTINGS
------------------------------------------ */
$set = $pdo->query("SELECT * FROM iaos_newsletter_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

if(!$set){
  $pdo->exec("
    INSERT INTO iaos_newsletter_settings
    (id,page_title,page_subtitle,bg_image,from_name,from_email,reply_to)
    VALUES
    (1,'Newsletter Manager',
    'Create newsletters and send to subscribers in secure batch sending.',
    'images/banner3.jpg',
    'IAOS Regina',
    'testuser@iaosregina.com',
    'info@iaosregina.com')
  ");
  $set = $pdo->query("SELECT * FROM iaos_newsletter_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
}

/* -----------------------------------------
   ✅ LOAD SUBSCRIBERS
------------------------------------------ */
$subs = $pdo->query("SELECT * FROM newsletter_subscribers ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
$totalSubs = (int)$pdo->query("SELECT COUNT(*) FROM newsletter_subscribers WHERE status='active'")->fetchColumn();

/* -----------------------------------------
   ✅ LOAD CAMPAIGNS + SELECT CURRENT CAMPAIGN
------------------------------------------ */
$campaigns = $pdo->query("SELECT * FROM newsletter_campaigns ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

$selectedCampaignId = isset($_GET['cid'])
  ? (int)$_GET['cid']
  : (count($campaigns) ? (int)$campaigns[0]['id'] : 0);

$campaign = null;
if($selectedCampaignId){
  $stmt = $pdo->prepare("SELECT * FROM newsletter_campaigns WHERE id=? LIMIT 1");
  $stmt->execute([$selectedCampaignId]);
  $campaign = $stmt->fetch(PDO::FETCH_ASSOC);
}

/* ✅ DEFAULTS FOR LINKS */
$DEFAULT_WEBSITE = "https://iaosregina.com";
$LOGO_IMG = "https://iaosregina.com/newweb/iaos/web/images/logo-white.png";

if($campaign){
  if(empty($campaign['logo_link']))   $campaign['logo_link'] = $DEFAULT_WEBSITE;
  if(empty($campaign['banner_link'])) $campaign['banner_link'] = $DEFAULT_WEBSITE;
  if(empty($campaign['button_link'])) $campaign['button_link'] = $DEFAULT_WEBSITE;
  if(empty($campaign['button_text'])) $campaign['button_text'] = "VISIT OUR WEBSITE";
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Newsletter | IAOS Admin</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- ✅ FREE EDITOR: Summernote (NO KEY) -->
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.js"></script>

<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;padding:12px 20px;display:block;text-decoration:none;border-bottom:1px solid #2f343a;}
.admin-sidebar a:hover,.admin-sidebar a.active{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
.section-card{border-radius:10px;}
.section-title{font-weight:700;font-size:1.2rem;margin-bottom:15px;}
.small-note{font-size:.875rem;color:#6c757d;}
.badge-active{background:#198754;}
.badge-unsub{background:#dc3545;}

.preview-img{
  max-width: 100%;
  border-radius: 10px;
  border: 1px solid #e5e7eb;
  margin-top: 8px;
}
</style>
</head>

<body>

<div class="admin-wrapper">
<?php include "sidebar.php"; ?>

<div class="admin-content">

<h3 class="mb-4">Manage Newsletter System</h3>

<?php if(isset($_GET['saved']) && $_GET['saved']=="1"): ?>
  <div class="alert alert-success">✅ Saved successfully!</div>
<?php elseif(isset($_GET['saved']) && $_GET['saved']=="0"): ?>
  <div class="alert alert-danger">❌ Something went wrong. Please try again.</div>
<?php endif; ?>

<?php if(isset($_GET['sent'])): ?>
  <div class="alert alert-info">✅ Queue created! Now click Start Sending ✅</div>
<?php endif; ?>


<!-- --------------------------------------------------
     ✅ GLOBAL SETTINGS
--------------------------------------------------- -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">🖼️ Newsletter Global Settings</div>

  <form action="save_newsletter.php" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="action" value="save_settings">

    <label class="fw-bold mb-1">Page Title</label>
    <input type="text" name="page_title" class="form-control mb-3"
           value="<?= htmlspecialchars($set['page_title']) ?>" required>

    <label class="fw-bold mb-1">Page Subtitle</label>
    <textarea name="page_subtitle" class="form-control mb-3" required><?= htmlspecialchars($set['page_subtitle']) ?></textarea>

    <div class="row g-2">
      <div class="col-md-4">
        <label class="fw-bold mb-1">From Name</label>
        <input type="text" name="from_name" class="form-control"
               value="<?= htmlspecialchars($set['from_name']) ?>" required>
      </div>

      <div class="col-md-4">
        <label class="fw-bold mb-1">From Email</label>
        <input type="email" name="from_email" class="form-control"
               value="<?= htmlspecialchars($set['from_email']) ?>" required>
      </div>

      <div class="col-md-4">
        <label class="fw-bold mb-1">Reply To</label>
        <input type="email" name="reply_to" class="form-control"
               value="<?= htmlspecialchars($set['reply_to']) ?>">
      </div>
    </div>

    <label class="fw-bold mb-1 mt-3">Header Background Image</label>
    <input type="file" name="bg_image" class="form-control mb-2" accept="image/*">

    <?php if(!empty($set['bg_image'])): ?>
      <img src="../<?= htmlspecialchars($set['bg_image']) ?>" style="max-width:240px;border-radius:8px;">
    <?php endif; ?>

    <button class="btn btn-primary mt-3">Save Newsletter Settings</button>
  </form>
</div>


<!-- --------------------------------------------------
     ✅ SUBSCRIBERS SECTION
--------------------------------------------------- -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">👥 Subscribers (Active: <?= $totalSubs ?>)</div>
  <div class="small-note mb-3">Add subscriber email and send newsletters to all active subscribers.</div>

  <!-- ✅ ADD SUBSCRIBER -->
  <form action="save_newsletter.php" method="POST" class="row g-2 mb-3">
    <input type="hidden" name="action" value="add_subscriber">

    <div class="col-md-4">
      <input type="text" name="full_name" class="form-control" placeholder="Full Name (optional)">
    </div>

    <div class="col-md-5">
      <input type="email" name="email" class="form-control" placeholder="Email Address" required>
    </div>

    <div class="col-md-3 d-flex align-items-end">
      <button class="btn btn-success w-100">➕ Add Subscriber</button>
    </div>
  </form>

  <!-- ✅ SUBSCRIBERS LIST -->
  <div class="table-responsive">
    <table class="table table-bordered bg-white">
      <thead class="table-light">
        <tr>
          <th>ID</th>
          <th>Name</th>
          <th>Email</th>
          <th>Status</th>
          <th width="220">Action</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($subs as $s): ?>
          <tr>
            <td><?= (int)$s['id'] ?></td>
            <td><?= htmlspecialchars($s['full_name'] ?? "") ?></td>
            <td><?= htmlspecialchars($s['email']) ?></td>
            <td>
              <?php if($s['status'] === 'active'): ?>
                <span class="badge badge-active">Active</span>
              <?php else: ?>
                <span class="badge badge-unsub">Unsubscribed</span>
              <?php endif; ?>
            </td>
            <td>
              <form action="save_newsletter.php" method="POST" class="d-flex gap-2">
                <input type="hidden" name="subscriber_id" value="<?= (int)$s['id'] ?>">

                <?php if($s['status'] === 'active'): ?>
                  <button class="btn btn-warning btn-sm" name="action" value="unsubscribe_subscriber"
                          onclick="return confirm('Unsubscribe this email?')">
                    Unsubscribe
                  </button>
                <?php else: ?>
                  <button class="btn btn-success btn-sm" name="action" value="activate_subscriber">
                    Activate
                  </button>
                <?php endif; ?>

                <button class="btn btn-danger btn-sm" name="action" value="delete_subscriber"
                        onclick="return confirm('Delete this subscriber?')">
                  Delete
                </button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>

        <?php if(empty($subs)): ?>
          <tr><td colspan="5" class="text-center text-muted">No subscribers yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>


<!-- --------------------------------------------------
     ✅ CAMPAIGN SELECT + ADD NEW CAMPAIGN
--------------------------------------------------- -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">📌 Select / Add Newsletter Campaign</div>

  <!-- ✅ SELECT CAMPAIGN -->
  <form method="GET" class="d-flex gap-2 mb-3">
    <select name="cid" class="form-select" onchange="this.form.submit()">
      <?php foreach($campaigns as $c): ?>
        <option value="<?= (int)$c['id'] ?>" <?= ((int)$c['id']===$selectedCampaignId)?'selected':'' ?>>
          <?= htmlspecialchars($c['subject']) ?>
        </option>
      <?php endforeach; ?>
    </select>
    <a href="admin_newsletter.php" class="btn btn-outline-secondary">Reset</a>
  </form>

  <!-- ✅ ADD CAMPAIGN -->
  <form action="save_newsletter.php" method="POST" class="row g-2">
    <input type="hidden" name="action" value="add_campaign">

    <div class="col-md-9">
      <label class="fw-bold mb-1">Campaign Subject</label>
      <input type="text" name="subject" class="form-control" placeholder="Newsletter subject..." required>
    </div>

    <div class="col-md-3 d-flex align-items-end">
      <button class="btn btn-success w-100">➕ Add Campaign</button>
    </div>
  </form>
</div>


<?php if($campaign): ?>

<!-- --------------------------------------------------
     ✅ CAMPAIGN EDITOR
--------------------------------------------------- -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">📝 Campaign Editor + Links + 2 HD Images</div>

  <form action="save_newsletter.php" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="action" value="save_campaign">
    <input type="hidden" name="campaign_id" value="<?= (int)$campaign['id'] ?>">

    <label class="fw-bold mb-1">Subject</label>
    <input type="text" name="subject" class="form-control mb-3"
           value="<?= htmlspecialchars($campaign['subject']) ?>" required>

    <!-- ✅ EDITABLE LINKS -->
    <div class="row g-3 mb-3">
      <div class="col-md-4">
        <label class="fw-bold mb-1">Logo Click Link</label>
        <input type="url" name="logo_link" class="form-control"
               value="<?= htmlspecialchars($campaign['logo_link']) ?>"
               placeholder="https://iaosregina.com">
      </div>

      <div class="col-md-4">
        <label class="fw-bold mb-1">Banner Image Click Link</label>
        <input type="url" name="banner_link" class="form-control"
               value="<?= htmlspecialchars($campaign['banner_link']) ?>"
               placeholder="https://iaosregina.com">
      </div>

      <div class="col-md-4">
        <label class="fw-bold mb-1">Button Click Link</label>
        <input type="url" name="button_link" class="form-control"
               value="<?= htmlspecialchars($campaign['button_link']) ?>"
               placeholder="https://iaosregina.com">
      </div>

      <div class="col-md-4">
        <label class="fw-bold mb-1 mt-2">Button Text</label>
        <input type="text" name="button_text" class="form-control"
               value="<?= htmlspecialchars($campaign['button_text']) ?>"
               placeholder="VISIT OUR WEBSITE">
      </div>

      <div class="col-md-8">
        <label class="fw-bold mb-1 mt-2">Logo Preview (fixed image)</label><br>
        <img src="<?= $LOGO_IMG ?>" style="max-height:55px;border-radius:8px;background:#0b7b4c;padding:8px;">
        <div class="small-note mt-1">✅ Logo image fixed: <?= htmlspecialchars($LOGO_IMG) ?></div>
      </div>
    </div>

    <!-- ✅ 2 OPTIONAL HD IMAGES -->
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="fw-bold mb-1">HD Image 1 (Optional)</label>
        <input type="file" name="image1_file" class="form-control" accept="image/*">

        <?php if(!empty($campaign['image1'])): ?>
          <img class="preview-img" src="../<?= htmlspecialchars($campaign['image1']) ?>" alt="">
          <div class="form-check mt-2">
            <input class="form-check-input" type="checkbox" name="remove_image1" id="remove1">
            <label class="form-check-label" for="remove1">Remove Image 1</label>
          </div>
        <?php endif; ?>

        <div class="small-note mt-1">✅ Best size: 1200px width or more (HD)</div>
      </div>

      <div class="col-md-6">
        <label class="fw-bold mb-1">HD Image 2 (Optional)</label>
        <input type="file" name="image2_file" class="form-control" accept="image/*">

        <?php if(!empty($campaign['image2'])): ?>
          <img class="preview-img" src="../<?= htmlspecialchars($campaign['image2']) ?>" alt="">
          <div class="form-check mt-2">
            <input class="form-check-input" type="checkbox" name="remove_image2" id="remove2">
            <label class="form-check-label" for="remove2">Remove Image 2</label>
          </div>
        <?php endif; ?>

        <div class="small-note mt-1">✅ Best size: 1200px width or more (HD)</div>
      </div>
    </div>

    <label class="fw-bold mb-1">Newsletter Body</label>
    <textarea name="html_body" id="html_body" class="form-control" rows="10"><?= htmlspecialchars($campaign['html_body']) ?></textarea>

    <div class="small-note mt-2">
      ✅ You can use: <b>{name}</b> and <b>{email}</b><br>
      ✅ Unsubscribe link will be auto added.<br>
      ✅ Images + Logo + Button will be included in email ✅
    </div>

    <button class="btn btn-primary mt-3">Save Campaign</button>
  </form>

  <form action="save_newsletter.php" method="POST" class="mt-2"
        onsubmit="return confirm('Delete this campaign? Queue will also be removed.')">
    <input type="hidden" name="action" value="delete_campaign">
    <input type="hidden" name="campaign_id" value="<?= (int)$campaign['id'] ?>">
    <button class="btn btn-danger">Delete Campaign</button>
  </form>
</div>


<!-- --------------------------------------------------
     ✅ CREATE QUEUE + START SENDING
--------------------------------------------------- -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">🚀 Send Newsletter (Loop / Batch)</div>
  <div class="small-note mb-2">
    ✅ This will send newsletter to all ACTIVE subscribers without timeouts.
  </div>

  <form action="save_newsletter.php" method="POST" onsubmit="return confirm('Create sending queue for this campaign?');">
    <input type="hidden" name="action" value="create_queue">
    <input type="hidden" name="campaign_id" value="<?= (int)$campaign['id'] ?>">
    <button class="btn btn-dark">✅ Create Queue</button>
  </form>

  <button class="btn btn-success mt-3" onclick="startSending(<?= (int)$campaign['id'] ?>)">
    🚀 Start Sending Now
  </button>

  <!-- ✅ PROGRESS -->
  <div id="progressBox" style="display:none;" class="mt-4">
    <div class="alert alert-warning">
      Sending in loop... Please do not close page.
    </div>

    <div class="progress" style="height:25px;">
      <div id="progressBar" class="progress-bar progress-bar-striped progress-bar-animated" style="width:0%;">
        0%
      </div>
    </div>

    <div class="small-note mt-2" id="progressText"></div>
  </div>
</div>

<?php endif; ?>


</div></div>


<script>
// ✅ FREE Editor: Summernote
$(document).ready(function(){
  $('#html_body').summernote({
    height: 380,
    placeholder: "Write your newsletter here...",
    toolbar: [
      ['style', ['style']],
      ['font', ['bold', 'underline', 'italic', 'clear']],
      ['para', ['ul', 'ol', 'paragraph']],
      ['table', ['table']],
      ['insert', ['link']],
      ['view', ['codeview']]
    ]
  });
});

/* ✅ Batch sending JS */
function startSending(campaignId){
  document.getElementById("progressBox").style.display = "block";
  sendBatch(campaignId);
}

function sendBatch(campaignId){
  fetch("newsletter_send_batch.php?campaign_id=" + campaignId)
    .then(res => res.json())
    .then(data => {

      if(data.status === "error"){
        alert("Error: " + data.message);
        return;
      }

      const percent = data.percent || 0;
      document.getElementById("progressBar").style.width = percent + "%";
      document.getElementById("progressBar").innerText = percent + "%";

      document.getElementById("progressText").innerHTML =
        `✅ Sent: <b>${data.sent}</b> / ${data.total} | Pending: <b>${data.pending}</b>`;

      if(data.pending > 0){
        setTimeout(() => sendBatch(campaignId), 800);
      } else {
        Swal.fire({
          icon:'success',
          title:'All emails sent ✅',
          text:'Newsletter campaign completed successfully.',
        });
        document.getElementById("progressBar").classList.remove("progress-bar-animated");
      }

    })
    .catch(err => {
      console.error(err);
      alert("Server error: " + err);
    });
}
</script>

</body>
</html>
