<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}



/* GLOBAL SETTINGS */
$set = $pdo->query("SELECT * FROM iaos_rizq_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* SECTIONS */
$sections = $pdo->query("
    SELECT * FROM iaos_rizq_sections 
    ORDER BY position ASC
")->fetchAll(PDO::FETCH_ASSOC);

/* PARAGRAPHS */
$paras_stmt = $pdo->query("
    SELECT * FROM iaos_rizq_paragraphs 
    ORDER BY position ASC
")->fetchAll(PDO::FETCH_ASSOC);

$paras = [];
foreach ($paras_stmt as $p) {
    $paras[$p['section_id']][] = $p;
}

/* LIMITS */
$limits = $pdo->query("
    SELECT * FROM iaos_rizq_limits 
    ORDER BY position ASC
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Rizq Relief | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; text-decoration:none; border-bottom:1px solid #2f343a; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.2rem; margin-bottom:12px; }
</style>
</head>

<body>
<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">

<h3 class="mb-4">Manage Rizq Relief</h3>

<?php if(isset($_GET['saved'])): ?>
  <div class="alert alert-success">✅ Saved successfully!</div>
<?php endif; ?>

<!-- PAGE HEADER -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">🖼️ Page Header</div>

  <form action="save_rizq.php" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="action" value="save_header">

    <label class="fw-bold mb-1">Page Title</label>
    <input type="text" name="page_title" class="form-control mb-2"
           value="<?= htmlspecialchars($set['page_title'] ?? '') ?>" required>

    <label class="fw-bold mb-1">Page Subtitle</label>
    <textarea name="page_subtitle" class="form-control mb-2" rows="3" required>
<?= htmlspecialchars($set['page_subtitle'] ?? '') ?>
    </textarea>

    <label class="fw-bold mb-1">Header Background Image</label>
    <input type="file" name="bg_image" class="form-control mb-2">

    <?php if (!empty($set['bg_image'])): ?>
      <img src="../<?= htmlspecialchars($set['bg_image']) ?>" class="rounded mt-2" style="max-width:220px">
    <?php endif; ?>

    <button class="btn btn-primary mt-2">Save Header</button>
  </form>
</div>

<!-- ADD SECTION -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">➕ Add New Section</div>

  <form action="save_rizq.php" method="POST">
    <input type="hidden" name="action" value="add_section">

    <div class="row g-2">
      <div class="col-md-6">
        <label class="fw-bold mb-1">Section Title</label>
        <input type="text" name="section_title" class="form-control" required>
      </div>

      <div class="col-md-3">
        <label class="fw-bold mb-1">Style</label>
        <select name="style" class="form-select">
          <option value="default">Default</option>
          <option value="green">Green</option>
        </select>
      </div>

      <div class="col-md-3">
        <label class="fw-bold mb-1">Position</label>
        <input type="number" name="position" class="form-control" value="100">
      </div>
    </div>

    <button class="btn btn-success mt-3">Add Section</button>
  </form>
</div>

<!-- SECTIONS + PARAGRAPHS -->
<?php foreach ($sections as $s): ?>
<div class="card p-4 shadow-sm mb-4 section-card">

  <div class="d-flex justify-content-between">
    <div>
      <div class="section-title"><?= htmlspecialchars($s['section_title']) ?></div>
      <span class="badge bg-secondary"><?= htmlspecialchars($s['style']) ?></span>
      <span class="badge bg-dark">pos <?= (int)$s['position'] ?></span>
    </div>

    <form action="save_rizq.php" method="POST"
          onsubmit="return confirm('Delete this section and all content?')">
      <input type="hidden" name="action" value="delete_section">
      <input type="hidden" name="id" value="<?= $s['id'] ?>">
      <button class="btn btn-danger btn-sm">Delete</button>
    </form>
  </div>

  <!-- ADD PARAGRAPH -->
  <form action="save_rizq.php" method="POST" class="mt-3">
    <input type="hidden" name="action" value="add_para">
    <input type="hidden" name="section_id" value="<?= $s['id'] ?>">

    <div class="row g-2">
      <div class="col-md-3">
        <label class="fw-bold">Type</label>
        <select name="type" class="form-select">
          <option value="heading">Heading</option>
          <option value="paragraph">Paragraph</option>
          <option value="li">List Item</option>
          <option value="html">Raw HTML</option>
        </select>
      </div>

      <div class="col-md-3">
        <label class="fw-bold">Position</label>
        <input type="number" name="position" class="form-control" value="100">
      </div>
    </div>

    <label class="fw-bold mt-2">Text</label>
    <textarea name="para_text" class="form-control mb-2"></textarea>

    <button class="btn btn-secondary btn-sm">Add Item</button>
  </form>

  <!-- EXISTING PARAGRAPHS -->
  <?php foreach ($paras[$s['id']] ?? [] as $p): ?>
    <div class="bg-white border rounded p-3 mt-2">
      <form action="save_rizq.php" method="POST">
        <input type="hidden" name="action" value="update_para">
        <input type="hidden" name="id" value="<?= $p['id'] ?>">

        <textarea name="para_text" class="form-control mb-2"><?= htmlspecialchars($p['para_text']) ?></textarea>

        <input type="number" name="position" value="<?= $p['position'] ?>" class="form-control mb-2">

        <button class="btn btn-success btn-sm">Update</button>
        <button formaction="save_rizq.php" name="action" value="delete_para"
                class="btn btn-danger btn-sm float-end"
                onclick="return confirm('Delete this item?')">Delete</button>
      </form>
    </div>
  <?php endforeach; ?>

</div>
<?php endforeach; ?>

<!-- LIMITS -->
<div class="card p-4 shadow-sm section-card">
  <div class="section-title">💵 Funding Limits</div>

  <form action="save_rizq.php" method="POST" class="mb-3">
    <input type="hidden" name="action" value="add_limit">

    <div class="row g-2">
      <div class="col-md-4">
        <input type="text" name="need" class="form-control" placeholder="Type of Need" required>
      </div>
      <div class="col-md-4">
        <input type="text" name="max_limit" class="form-control" placeholder="Max Funding" required>
      </div>
      <div class="col-md-2">
        <input type="number" name="position" class="form-control" value="100">
      </div>
      <div class="col-md-2">
        <button class="btn btn-success w-100">Add</button>
      </div>
    </div>
  </form>

  <?php foreach ($limits as $r): ?>
    <form action="save_rizq.php" method="POST" class="border p-3 mb-2 bg-white">
      <input type="hidden" name="action" value="update_limit">
      <input type="hidden" name="id" value="<?= $r['id'] ?>">

      <div class="row g-2">
        <div class="col-md-4">
          <input type="text" name="need" class="form-control" value="<?= htmlspecialchars($r['need']) ?>">
        </div>
        <div class="col-md-4">
          <input type="text" name="max_limit" class="form-control" value="<?= htmlspecialchars($r['max_limit']) ?>">
        </div>
        <div class="col-md-2">
          <input type="number" name="position" class="form-control" value="<?= $r['position'] ?>">
        </div>
        <div class="col-md-2">
          <button class="btn btn-success btn-sm">Update</button>
          <button formaction="save_rizq.php" name="action" value="delete_limit"
                  class="btn btn-danger btn-sm"
                  onclick="return confirm('Delete row?')">Delete</button>
        </div>
      </div>
    </form>
  <?php endforeach; ?>
</div>

</div>
</div>
</body>
</html>
