<?php
ob_start();
require_once "db.php";  // ✅ gives $pdo directly

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


/****************************
 SAVE HEADING
*****************************/
if(isset($_POST['save_heading'])){
    $heading = trim($_POST['heading_text']);
    $pdo->prepare("UPDATE events_heading SET heading_text=? WHERE id=1")
        ->execute([$heading]);

    header("Location: manage_events_heading.php?saved=1");
    exit;
}

/****************************
 FETCH HEADING
*****************************/
$row = $pdo->query("SELECT heading_text FROM events_heading WHERE id=1")->fetch();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Events Heading | IAOS Admin</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;text-decoration:none;display:block;padding:12px 20px;}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
</style>
</head>
<body>

<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">

    <h3 class="mb-4">Manage Upcoming Events Heading</h3>

    <?php if(isset($_GET['saved'])): ?>
        <div class="alert alert-success">✅ Heading updated successfully!</div>
    <?php endif; ?>

    <!-- ✅ UPDATE EVENTS HEADING -->
    <form method="POST" class="card p-4 shadow-sm" style="max-width:600px;">
      <h5 class="mb-3">Update Heading</h5>

      <div class="row g-2">
        <div class="col-md-8">
          <input type="text" name="heading_text" class="form-control"
                 value="<?= htmlspecialchars($row['heading_text']) ?>" required>
        </div>

        <div class="col-md-4">
          <button name="save_heading" class="btn btn-primary w-100">Save</button>
        </div>
      </div>
    </form>

</div>
</div>

</body>
</html>
