<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


// âœ… Fetch current greeting
$stmt = $pdo->query("SELECT * FROM greeting_section LIMIT 1");
$greeting = $stmt->fetch(PDO::FETCH_ASSOC);

// âœ… Update greeting info
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $stmt = $pdo->prepare("
    UPDATE greeting_section 
    SET title=?, subtitle=?, description=?, button_text=?, button_link=? 
    WHERE id=?
  ");
  $stmt->execute([
    $_POST['title'], 
    $_POST['subtitle'], 
    $_POST['description'], 
    $_POST['button_text'], 
    $_POST['button_link'], 
    $_POST['id']
  ]);
  header("Location: manage_greeting.php?saved=1");
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Greeting | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;text-decoration:none;display:block;padding:12px 20px;}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
textarea{resize:vertical;}
</style>
</head>
<body>
<div class="admin-wrapper">
  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">Manage Greeting Section</h3>

    <?php if(isset($_GET['saved'])): ?>
      <div class="alert alert-success">âœ… Greeting section updated successfully!</div>
    <?php endif; ?>

    <form method="POST" class="card p-4 shadow-sm">
      <input type="hidden" name="id" value="<?= $greeting['id'] ?? 1 ?>">
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label fw-semibold">Title</label>
          <input type="text" name="title" class="form-control" 
                 value="<?= htmlspecialchars($greeting['title'] ?? '') ?>" placeholder="Assalamu Alaykum">
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Subtitle</label>
          <input type="text" name="subtitle" class="form-control" 
                 value="<?= htmlspecialchars($greeting['subtitle'] ?? '') ?>" placeholder="Peace Be Upon You">
        </div>

        <div class="col-12">
          <label class="form-label fw-semibold">Description</label>
          <textarea name="description" rows="5" class="form-control" 
            placeholder="Enter greeting text (supports HTML tags)"><?= htmlspecialchars($greeting['description'] ?? '') ?></textarea>
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Button Text</label>
          <input type="text" name="button_text" class="form-control" 
                 value="<?= htmlspecialchars($greeting['button_text'] ?? '') ?>" placeholder="Learn More">
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Button Link</label>
          <input type="text" name="button_link" class="form-control" 
                 value="<?= htmlspecialchars($greeting['button_link'] ?? '') ?>" placeholder="#">
        </div>

        <div class="col-12 text-end mt-3">
          <button type="submit" class="btn btn-primary px-4">ðŸ’¾ Save Changes</button>
        </div>
      </div>
    </form>
  </div>
</div>
</body>
</html>
