<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


// âœ… Ensure table exists (one row max)
$pdo->exec("
CREATE TABLE IF NOT EXISTS live_banner (
  id INT PRIMARY KEY,
  text VARCHAR(255) NOT NULL,
  url VARCHAR(255) DEFAULT NULL,
  is_active TINYINT(1) DEFAULT 1
)
");

// âœ… Ensure row exists
$rowCheck = $pdo->query("SELECT COUNT(*) FROM live_banner")->fetchColumn();
if ($rowCheck == 0) {
  $pdo->prepare("INSERT INTO live_banner (id, text, url, is_active) VALUES (1, '', NULL, 0)")
       ->execute();
}

// âœ… Update banner
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $stmt = $pdo->prepare("UPDATE live_banner SET text=?, url=?, is_active=? WHERE id=1");
  $stmt->execute([
    $_POST['text'],
    $_POST['url'] ?: null,
    isset($_POST['is_active']) ? 1 : 0
  ]);

  header("Location: manage_live_banner.php?saved=1");
  exit;
}

// âœ… Fetch current row
$banner = $pdo->query("SELECT * FROM live_banner WHERE id=1")->fetch(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Live Banner | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;text-decoration:none;display:block;padding:12px 20px;}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
</style>
</head>
<body>

<div class="admin-wrapper">

  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">Manage Live Banner</h3>

    <?php if(isset($_GET['saved'])): ?>
      <div class="alert alert-success">âœ… Live banner updated successfully!</div>
    <?php endif; ?>

    <!-- âœ… Same card UI like manage_greeting -->
    <form method="POST" class="card p-4 shadow-sm">
      <div class="row g-3">

        <div class="col-md-12">
          <label class="form-label fw-semibold">Live Text</label>
          <input type="text" name="text" class="form-control"
                 value="<?= htmlspecialchars($banner['text']) ?>"
                 placeholder="ðŸ”´ LIVE: SEE MAKKAH">
        </div>

        <div class="col-md-12">
          <label class="form-label fw-semibold">Live URL (optional)</label>
          <input type="text" name="url" class="form-control"
                 value="<?= htmlspecialchars($banner['url']) ?>"
                 placeholder="https://youtube.com/...">
        </div>

        <div class="col-md-12">
          <label class="form-label fw-semibold">Activate Banner?</label><br>
          <input type="checkbox" name="is_active" <?= $banner['is_active'] ? 'checked' : '' ?>>
          <span class="ms-2">Show live banner on website</span>
        </div>

        <div class="col-12 text-end mt-3">
          <button type="submit" name="save" class="btn btn-primary px-4">ðŸ’¾ Save Changes</button>
        </div>

      </div>
    </form>

  </div>
</div>

</body>
</html>
