<?php
ob_start();
require_once "db.php";  // ✅ gives $pdo directly

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


/****************************
 ADD SERVICE
*****************************/
if(isset($_POST['add_service'])){

    $title = trim($_POST['title']);
    $description = trim($_POST['description']);
    $link = trim($_POST['link']);
    $layout = $_POST['layout'];
    $sort_order = (int)$_POST['sort_order'];

    // ✅ Image Upload FIXED (upload to images/services/)
    $path = "";
    if($_FILES['image']['error'] === UPLOAD_ERR_OK){

        $uploadDir = __DIR__ . "/../images/services/";   // ✅ correct folder
        if(!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

        $filename = time() . "_" . basename($_FILES['image']['name']);
        $fullPath = $uploadDir . $filename;

        $path = "images/services/" . $filename;  // ✅ DB path

        move_uploaded_file($_FILES['image']['tmp_name'], $fullPath);
    }

    $pdo->prepare("
        INSERT INTO services (title, description, image, link, layout, sort_order)
        VALUES (?, ?, ?, ?, ?, ?)
    ")->execute([$title, $description, $path, $link, $layout, $sort_order]);

    header("Location: manage_services.php?saved=1");
    exit;
}

/****************************
 DELETE SERVICE
*****************************/
if(isset($_GET['delete'])){
    $pdo->prepare("DELETE FROM services WHERE id=?")->execute([$_GET['delete']]);
    header("Location: manage_services.php");
    exit;
}

/****************************
 UPDATE HEADING
*****************************/
if(isset($_POST['update_heading'])){
    $heading = trim($_POST['heading_text']);
    $pdo->prepare("UPDATE services_heading SET heading_text=? WHERE id=1")
        ->execute([$heading]);
    header("Location: manage_services.php?saved=1");
    exit;
}

/****************************
 UPDATE SERVICE (MODAL)
*****************************/
if(isset($_POST['update_service'])){

    $id = $_POST['id'];
    $title = trim($_POST['title']);
    $description = trim($_POST['description']);
    $link = trim($_POST['link']);
    $layout = $_POST['layout'];
    $sort_order = (int)$_POST['sort_order'];

    $image = $_POST['old_image'];

    // ✅ FIXED UPLOAD (to images/services/)
    if($_FILES['image']['error'] === UPLOAD_ERR_OK){

        $uploadDir = __DIR__ . "/../images/services/"; // ✅ correct folder
        if(!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

        $filename = time() . "_" . basename($_FILES['image']['name']);
        $fullPath = $uploadDir . $filename;

        $image = "images/services/" . $filename;  // ✅ DB path

        move_uploaded_file($_FILES['image']['tmp_name'], $fullPath);
    }

    $pdo->prepare("
        UPDATE services 
        SET title=?, description=?, image=?, link=?, layout=?, sort_order=?
        WHERE id=?
    ")->execute([$title, $description, $image, $link, $layout, $sort_order, $id]);

    header("Location: manage_services.php?saved=1");
    exit;
}

/****************************
 FETCH LISTS
*****************************/
$services = $pdo->query("SELECT * FROM services ORDER BY sort_order ASC")->fetchAll(PDO::FETCH_ASSOC);
$headingRow = $pdo->query("SELECT * FROM services_heading WHERE id=1")->fetch();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Services | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;text-decoration:none;display:block;padding:12px 20px;}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
img.service-thumb{width:200px;border-radius:8px;}
</style>
</head>
<body>

<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">

    <h3 class="mb-4">Manage Services</h3>

    <?php if(isset($_GET['saved'])): ?>
        <div class="alert alert-success">✅ Saved successfully!</div>
    <?php endif; ?>

    <!-- ✅ UPDATE SECTION HEADING -->
    <form method="POST" class="card p-3 mb-4 shadow-sm">
      <h5>Section Heading</h5>

      <div class="row g-2">
        <div class="col-md-6">
          <input type="text" name="heading_text" class="form-control"
                 value="<?= htmlspecialchars($headingRow['heading_text']) ?>" required>
        </div>
        <div class="col-md-3">
          <button name="update_heading" class="btn btn-primary w-100">Save</button>
        </div>
      </div>
    </form>
	

    <!-- ✅ ADD SERVICE -->
    <form method="POST" enctype="multipart/form-data" class="card p-3 mb-4 shadow-sm">
      <h5 class="mb-3">Add New Service</h5>

      <div class="row g-2">

        <div class="col-md-4">
          <input type="text" name="title" class="form-control" placeholder="Service Title" required>
        </div>

        <div class="col-md-4">
          <input type="text" name="description" class="form-control" placeholder="Short Description" required>
        </div>

        <div class="col-md-3">
          <input type="text" name="link" class="form-control" placeholder="Learn More Link">
        </div>

        <div class="col-md-3">
          <select name="layout" class="form-control">
            <option value="col-md-3">Small Box (col-md-3)</option>
            <option value="col-md-4">Medium Box (col-md-4)</option>
            <option value="col-md-8">Large Box (col-md-8)</option>
          </select>
        </div>

        <div class="col-md-2">
          <input type="number" name="sort_order" class="form-control" placeholder="Order" required>
        </div>

        <div class="col-md-3">
          <input type="file" name="image" class="form-control" required>
        </div>

        <div class="col-md-2">
          <button name="add_service" class="btn btn-success w-100">Add</button>
        </div>

      </div>
    </form>

    <!-- ✅ SERVICES TABLE -->
    <table class="table table-bordered shadow-sm align-middle">
      <thead class="table-dark">
        <tr>
          <th>ID</th>
          <th>Image</th>
          <th>Title</th>
          <th>Description</th>
          <th>Link</th>
          <th>Layout</th>
          <th>Sort</th>
          <th>Action</th>
        </tr>
      </thead>

      <tbody>
        <?php foreach ($services as $s): ?>
        <tr>
          <td><?= $s['id'] ?></td>
          <td><img src="../<?= $s['image'] ?>" class="service-thumb"></td>
          <td><?= htmlspecialchars($s['title']) ?></td>
          <td><?= htmlspecialchars($s['description']) ?></td>
          <td><a href="<?= $s['link'] ?>" target="_blank"><?= $s['link'] ?></a></td>
          <td><?= $s['layout'] ?></td>
          <td><?= $s['sort_order'] ?></td>

          <td>
            <button class="btn btn-primary btn-sm editBtn"
              data-id="<?= $s['id'] ?>"
              data-title="<?= htmlspecialchars($s['title']) ?>"
              data-desc="<?= htmlspecialchars($s['description']) ?>"
              data-link="<?= $s['link'] ?>"
              data-layout="<?= $s['layout'] ?>"
              data-sort="<?= $s['sort_order'] ?>"
              data-img="<?= $s['image'] ?>"
            >Edit</button>

            <a href="?delete=<?= $s['id'] ?>" class="btn btn-danger btn-sm"
               onclick="return confirm('Delete service?')">Delete</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>

    </table>

</div>
</div>

<!-- ✅ EDIT MODAL -->
<div class="modal fade" id="editModal">
<div class="modal-dialog modal-dialog-centered">
<div class="modal-content">

<form method="POST" enctype="multipart/form-data">

<div class="modal-header">
    <h5>Edit Service</h5>
    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>

<div class="modal-body">

    <input type="hidden" name="id" id="editId">
    <input type="hidden" name="old_image" id="editOldImg">

    <label>Title</label>
    <input type="text" name="title" id="editTitle" class="form-control mb-2">

    <label>Description</label>
    <input type="text" name="description" id="editDesc" class="form-control mb-2">

    <label>Learn Link</label>
    <input type="text" name="link" id="editLink" class="form-control mb-2">

    <label>Layout</label>
    <select name="layout" id="editLayout" class="form-control mb-2">
        <option value="col-md-3">col-md-3</option>
        <option value="col-md-4">col-md-4</option>
        <option value="col-md-8">col-md-8</option>
    </select>

    <label>Sort Order</label>
    <input type="number" name="sort_order" id="editSort" class="form-control mb-2">

    <label>Replace Image</label>
    <input type="file" name="image" class="form-control">

</div>

<div class="modal-footer">
    <button name="update_service" class="btn btn-primary">Save</button>
    <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
</div>

</form>

</div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.querySelectorAll(".editBtn").forEach(btn=>{
    btn.onclick = ()=>{
        editId.value = btn.dataset.id;
        editTitle.value = btn.dataset.title;
        editDesc.value = btn.dataset.desc;
        editLink.value = btn.dataset.link;
        editLayout.value = btn.dataset.layout;
        editSort.value = btn.dataset.sort;
        editOldImg.value = btn.dataset.img;

        new bootstrap.Modal(document.getElementById('editModal')).show();
    };
});
</script>

</body>
</html>
