<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


// âœ… Add new session
if (isset($_POST['add'])) {
  $stmt = $pdo->prepare("INSERT INTO halaqah_times (session_name, time_text) VALUES (?, ?)");
  $stmt->execute([$_POST['session_name'], $_POST['time_text']]);
  header("Location: manage_halaqah.php?saved=1");
  exit;
}

// âœ… Update
if (isset($_POST['update'])) {
  $stmt = $pdo->prepare("UPDATE halaqah_times SET session_name=?, time_text=? WHERE id=?");
  $stmt->execute([$_POST['session_name'], $_POST['time_text'], $_POST['id']]);
  header("Location: manage_halaqah.php?saved=1");
  exit;
}

// âœ… Delete
if (isset($_GET['delete'])) {
  $pdo->prepare("DELETE FROM halaqah_times WHERE id=?")->execute([$_GET['delete']]);
  header("Location: manage_halaqah.php");
  exit;
}

// âœ… Fetch all
$list = $pdo->query("SELECT * FROM halaqah_times ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Halaaqah Times</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;text-decoration:none;display:block;padding:12px 20px;}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
</style>
</head>
<body>

<div class="admin-wrapper">
  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">Manage Halaaqah Times</h3>

    <?php if(isset($_GET['saved'])): ?>
      <div class="alert alert-success">âœ… Saved successfully!</div>
    <?php endif; ?>

    <!-- Add New -->
    <form method="POST" class="card p-4 mb-4 shadow-sm">
      <div class="row g-2">
        <div class="col-md-6">
          <label class="form-label">Session Name</label>
          <input type="text" name="session_name" class="form-control" placeholder="Quran (Sisters)" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">Time</label>
          <input type="text" name="time_text" class="form-control" placeholder="After Maghrib" required>
        </div>
        <div class="col-md-2 d-flex align-items-end">
          <button type="submit" name="add" class="btn btn-success w-100">Add</button>
        </div>
      </div>
    </form>

    <!-- List -->
    <table class="table table-bordered table-striped align-middle shadow-sm">
      <thead class="table-dark">
        <tr><th>ID</th><th>Session</th><th>Time</th><th width="150">Action</th></tr>
      </thead>
      <tbody>
        <?php foreach($list as $row): ?>
          <tr>
            <td><?= $row['id'] ?></td>
            <td><?= htmlspecialchars($row['session_name']) ?></td>
            <td><?= htmlspecialchars($row['time_text']) ?></td>
            <td>
              <button class="btn btn-sm btn-primary editBtn"
                data-id="<?= $row['id'] ?>"
                data-session="<?= htmlspecialchars($row['session_name']) ?>"
                data-time="<?= htmlspecialchars($row['time_text']) ?>"
              >Edit</button>
              <a href="?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete?')">Delete</a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <form method="POST">
        <div class="modal-header">
          <h5>Edit Halaaqah Session</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="id" id="editId">

          <label class="form-label">Session Name</label>
          <input type="text" name="session_name" id="editSession" class="form-control mb-3">

          <label class="form-label">Time</label>
          <input type="text" name="time_text" id="editTime" class="form-control">
        </div>
        <div class="modal-footer">
          <button type="submit" name="update" class="btn btn-primary">Save</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.querySelectorAll('.editBtn').forEach(btn=>{
  btn.addEventListener('click',()=>{
    document.getElementById('editId').value = btn.dataset.id;
    document.getElementById('editSession').value = btn.dataset.session;
    document.getElementById('editTime').value = btn.dataset.time;
    new bootstrap.Modal(document.getElementById('editModal')).show();
  });
});
</script>

</body>
</html>
