<?php
ob_start();
include "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


/* ✅ UNIVERSAL IMAGE UPLOAD FUNCTION */
function uploadImage($inputName)
{
    if (empty($_FILES[$inputName]['name'])) {
        return null; // no new file uploaded
    }

    // Create uploads folder if missing
    if (!is_dir("../uploads")) {
        mkdir("../uploads", 0777, true);
    }

    $filename = time() . "_" . basename($_FILES[$inputName]['name']);
    $uploadPath = "../uploads/" . $filename;   // real file location
    $dbPath = "uploads/" . $filename;          // save in database

    if (move_uploaded_file($_FILES[$inputName]['tmp_name'], $uploadPath)) {
        return $dbPath;
    }

    return null;
}

$action = $_POST['action'] ?? '';

/* ✅ UPDATE HEADER SETTINGS */
if ($action === "update_header") {

    // Get existing image
    $row = $pdo->query("SELECT bg_image FROM about_page_settings WHERE id=1")->fetch();
    $bg = $row['bg_image'];

    // Upload new one if provided
    $newImg = uploadImage('bg_image');
    if ($newImg) {
        $bg = $newImg;
    }

    $stmt = $pdo->prepare("UPDATE about_page_settings SET page_title=?, page_subtitle=?, bg_image=? WHERE id=1");
    $stmt->execute([$_POST['page_title'], $_POST['page_subtitle'], $bg]);

    header("Location: admin_about.php?saved=1");
    exit;
}

/* ✅ ADD HEADING */
if ($action === "add_heading") {
    $stmt = $pdo->prepare("INSERT INTO about_headings (heading_text, position) VALUES (?, ?)");
    $stmt->execute([$_POST['heading_text'], time()]);
    header("Location: admin_about.php?saved=1");
    exit;
}

/* ✅ DELETE HEADING */
if ($action === "delete_heading") {
    $stmt = $pdo->prepare("DELETE FROM about_headings WHERE id=?");
    $stmt->execute([$_POST['id']]);
    header("Location: admin_about.php?saved=1");
    exit;
}

/* ✅ ADD PARAGRAPH */
if ($action === "add_paragraph") {
    $stmt = $pdo->prepare("INSERT INTO about_paragraphs (heading_id, paragraph_text, position) VALUES (?, ?, ?)");
    $stmt->execute([$_POST['heading_id'], $_POST['paragraph_text'], time()]);
    header("Location: admin_about.php?saved=1");
    exit;
}

/* ✅ UPDATE PARAGRAPH */
if ($action === "update_paragraph") {
    $stmt = $pdo->prepare("UPDATE about_paragraphs SET paragraph_text=? WHERE id=?");
    $stmt->execute([$_POST['paragraph_text'], $_POST['id']]);
    header("Location: admin_about.php?saved=1");
    exit;
}

/* ✅ DELETE PARAGRAPH */
if ($action === "delete_paragraph") {
    $stmt = $pdo->prepare("DELETE FROM about_paragraphs WHERE id=?");
    $stmt->execute([$_POST['id']]);
    header("Location: admin_about.php?saved=1");
    exit;
}

/* ✅ ADD MEMBER */
if ($action === "add_member") {

    $img = uploadImage('image'); // Upload member picture

    $stmt = $pdo->prepare("
        INSERT INTO about_members (name, role, email, bio, image, position)
        VALUES (?, ?, ?, ?, ?, ?)
    ");

    $stmt->execute([
        $_POST['name'],
        $_POST['role'],
        $_POST['email'],
        $_POST['bio'],
        $img,
        time()
    ]);

    header("Location: admin_about.php?saved=1");
    exit;
}

/* ✅ UPDATE MEMBER */
if ($action === "update_member") {

    $stmt = $pdo->prepare("SELECT image FROM about_members WHERE id=?");
    $stmt->execute([$_POST['id']]);
    $row = $stmt->fetch();

    $img = $row['image'];

    $newImg = uploadImage('image');
    if ($newImg) {
        $img = $newImg;
    }

    $stmt = $pdo->prepare("
        UPDATE about_members
        SET name=?, role=?, email=?, bio=?, image=?
        WHERE id=?
    ");

    $stmt->execute([
        $_POST['name'],
        $_POST['role'],
        $_POST['email'],
        $_POST['bio'],
        $img,
        $_POST['id']
    ]);

    header("Location: admin_about.php?saved=1");
    exit;
}

/* ✅ DELETE MEMBER */
if ($action === "delete_member") {
    $stmt = $pdo->prepare("DELETE FROM about_members WHERE id=?");
    $stmt->execute([$_POST['id']]);
    header("Location: admin_about.php?saved=1");
    exit;
}

/* ✅ ADD MOSQUE */
if ($action === "add_mosque") {

    $stmt = $pdo->prepare("
        INSERT INTO mosque_locations (mosque_name, address, map_embed, position)
        VALUES (?, ?, ?, ?)
    ");

    $stmt->execute([
        $_POST['mosque_name'],
        $_POST['address'],
        $_POST['map_embed'],
        time()
    ]);

    header("Location: admin_about.php?saved=1");
    exit;
}

/* ✅ UPDATE MOSQUE */
if ($action === "update_mosque") {

    $stmt = $pdo->prepare("
        UPDATE mosque_locations
        SET mosque_name=?, address=?, map_embed=?
        WHERE id=?
    ");

    $stmt->execute([
        $_POST['mosque_name'],
        $_POST['address'],
        $_POST['map_embed'],
        $_POST['id']
    ]);

    header("Location: admin_about.php?saved=1");
    exit;
}

/* ✅ DELETE MOSQUE */
if ($action === "delete_mosque") {

    $stmt = $pdo->prepare("DELETE FROM mosque_locations WHERE id=?");
    $stmt->execute([$_POST['id']]);

    header("Location: admin_about.php?saved=1");
    exit;
}

?>
