<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


$pdo = get_db();

/* -----------------------
   SAVE SETTINGS
------------------------ */
if ($_POST['action'] === 'save_settings') {

    $page_title = $_POST['page_title'];
    $page_subtitle = $_POST['page_subtitle'];
    $imam_name = $_POST['imam_name'];

    // Image handling
    $imagePath = null;
    if (!empty($_FILES['imam_image']['name'])) {
        $fname = "imam_" . time() . "_" . basename($_FILES['imam_image']['name']);
        $target = "../uploads/" . $fname;
        move_uploaded_file($_FILES['imam_image']['tmp_name'], $target);
        $imagePath = "uploads/" . $fname;
    }

    if ($imagePath) {
        $stmt = $pdo->prepare("UPDATE ask_imam_settings 
                               SET page_title=?, page_subtitle=?, imam_name=?, imam_image=? 
                               WHERE id=1");
        $stmt->execute([$page_title, $page_subtitle, $imam_name, $imagePath]);
    } else {
        $stmt = $pdo->prepare("UPDATE ask_imam_settings 
                               SET page_title=?, page_subtitle=?, imam_name=? 
                               WHERE id=1");
        $stmt->execute([$page_title, $page_subtitle, $imam_name]);
    }

    header("Location: admin_ask_imam.php?saved=1");
    exit;
}

/* -----------------------
   ADD PARAGRAPH
------------------------ */
if ($_POST['action'] === 'add_paragraph') {
    $stmt = $pdo->prepare("INSERT INTO ask_imam_paragraphs (para_text, position) VALUES (?, 0)");
    $stmt->execute([$_POST['para_text']]);

    header("Location: admin_ask_imam.php?saved=1");
    exit;
}

/* -----------------------
   UPDATE PARAGRAPH
------------------------ */
if ($_POST['action'] === 'update_paragraph') {
    $stmt = $pdo->prepare("UPDATE ask_imam_paragraphs SET para_text=? WHERE id=?");
    $stmt->execute([$_POST['para_text'], $_POST['para_id']]);

    header("Location: admin_ask_imam.php?saved=1");
    exit;
}

/* -----------------------
   DELETE PARAGRAPH
------------------------ */
if ($_POST['action'] === 'delete_paragraph') {
    $stmt = $pdo->prepare("DELETE FROM ask_imam_paragraphs WHERE id=?");
    $stmt->execute([$_POST['para_id']]);

    header("Location: admin_ask_imam.php?saved=1");
    exit;
}

?>
