<?php
ob_start();
require_once "db.php";
session_start();

// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header("Location: admin_business_registration.php");
  exit;
}

$action = isset($_POST['action']) ? trim($_POST['action']) : '';
$id     = isset($_POST['id']) ? (int)$_POST['id'] : 0;

if ($id <= 0) {
  header("Location: admin_business_registration.php?err=1");
  exit;
}

try {

  if ($action === 'approve') {
    $stmt = $pdo->prepare("UPDATE business_registrations SET status='approved' WHERE id=?");
    $stmt->execute([$id]);

  } elseif ($action === 'reject') {
    $stmt = $pdo->prepare("UPDATE business_registrations SET status='rejected' WHERE id=?");
    $stmt->execute([$id]);

  } elseif ($action === 'contacted') {
    $stmt = $pdo->prepare("UPDATE business_registrations SET status='contacted' WHERE id=?");
    $stmt->execute([$id]);

  } elseif ($action === 'notes') {
    $notes = trim($_POST['admin_notes'] ?? '');
    $stmt = $pdo->prepare("UPDATE business_registrations SET admin_notes=? WHERE id=?");
    $stmt->execute([$notes, $id]);

  } elseif ($action === 'delete') {
    $stmt = $pdo->prepare("DELETE FROM business_registrations WHERE id=?");
    $stmt->execute([$id]);

    header("Location: admin_business_registration.php?deleted=1");
    exit;
  }

  header("Location: admin_business_registration.php?saved=1");
  exit;

} catch (Exception $e) {
  // error_log("save_business_reg error: ".$e->getMessage());
  header("Location: admin_business_registration.php?err=1");
  exit;
}
