<?php
ob_start();
require_once "db.php";
session_start();

if (!isset($_SESSION['user_id'])) { header("Location: index.php"); exit; }
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') { header("Location: index.php"); exit; }

$action = $_POST['action'] ?? '';

function go($qs="saved=1"){
  header("Location: admin_business_support.php?$qs");
  exit;
}

try {

  // ✅ quick check: is $pdo valid?
  if (!isset($pdo)) {
    throw new Exception("PDO not found. Check db.php provides \$pdo");
  }

  if ($action === "update_settings") {

    $page_title       = trim($_POST['page_title'] ?? '');
    $page_subtitle    = trim($_POST['page_subtitle'] ?? '');
    $why_title        = trim($_POST['why_title'] ?? '');
    $form_title       = trim($_POST['form_title'] ?? '');
    $form_intro       = trim($_POST['form_intro'] ?? '');
    $promo_title      = trim($_POST['promo_title'] ?? '');
    $note_text        = trim($_POST['note_text'] ?? '');
    $success_message  = trim($_POST['success_message'] ?? '');

    // ✅ keep old image if not uploaded
    $old = $pdo->query("SELECT bg_image FROM business_support_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
    $bg_image = $old['bg_image'] ?? null;

    // ✅ IMPORTANT: upload folder must be in WEBSITE ROOT: /uploads/
    // If admin folder is: /admin_pannel/
    // Then website root is: one level up
    $rootDir   = realpath(__DIR__ . "/.."); // ✅ goes to website root
    $uploadDir = $rootDir . "/uploads";

    if (!is_dir($uploadDir)) {
      if (!mkdir($uploadDir, 0777, true)) {
        throw new Exception("Cannot create uploads folder: " . $uploadDir);
      }
    }

    if (!empty($_FILES['bg_image']['name'])) {

      if (!empty($_FILES['bg_image']['error']) && $_FILES['bg_image']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception("Upload error code: " . $_FILES['bg_image']['error']);
      }

      $ext = strtolower(pathinfo($_FILES['bg_image']['name'], PATHINFO_EXTENSION));
      $allowed = ['jpg','jpeg','png','webp'];

      if (!in_array($ext, $allowed, true)) {
        throw new Exception("Invalid image type. Allowed: jpg, jpeg, png, webp");
      }

      $fileName   = "business_support_" . time() . "." . $ext;
      $targetPath = $uploadDir . "/" . $fileName;

      if (!move_uploaded_file($_FILES['bg_image']['tmp_name'], $targetPath)) {
        throw new Exception("Failed to move uploaded file to: " . $targetPath);
      }

      // ✅ save DB path as relative from website root
      $bg_image = "uploads/" . $fileName;
    }

    $stmt = $pdo->prepare("
      UPDATE business_support_settings
      SET page_title=?, page_subtitle=?, bg_image=?,
          why_title=?, form_title=?,
          form_intro=?, promo_title=?,
          note_text=?, success_message=?
      WHERE id=1
    ");

    $stmt->execute([
      $page_title, $page_subtitle, $bg_image,
      $why_title, $form_title,
      $form_intro, $promo_title,
      $note_text, $success_message
    ]);

    go("saved=1");
  }

  // WHY bullets
  if ($action === "add_why_bullet") {
    $bullet_text = trim($_POST['bullet_text'] ?? '');
    $position = (int)($_POST['position'] ?? 0);

    $stmt = $pdo->prepare("INSERT INTO business_support_why_bullets (bullet_text, position) VALUES (?,?)");
    $stmt->execute([$bullet_text, $position]);
    go("saved=1");
  }

  if ($action === "update_why_bullet") {
    $id = (int)($_POST['id'] ?? 0);
    $bullet_text = trim($_POST['bullet_text'] ?? '');
    $position = (int)($_POST['position'] ?? 0);

    $stmt = $pdo->prepare("UPDATE business_support_why_bullets SET bullet_text=?, position=? WHERE id=?");
    $stmt->execute([$bullet_text, $position, $id]);
    go("saved=1");
  }

  if ($action === "delete_why_bullet") {
    $id = (int)($_POST['id'] ?? 0);
    $stmt = $pdo->prepare("DELETE FROM business_support_why_bullets WHERE id=?");
    $stmt->execute([$id]);
    go("deleted=1");
  }

  // PROMO bullets
  if ($action === "add_promo_bullet") {
    $bullet_text = trim($_POST['bullet_text'] ?? '');
    $position = (int)($_POST['position'] ?? 0);

    $stmt = $pdo->prepare("INSERT INTO business_support_promo_bullets (bullet_text, position) VALUES (?,?)");
    $stmt->execute([$bullet_text, $position]);
    go("saved=1");
  }

  if ($action === "update_promo_bullet") {
    $id = (int)($_POST['id'] ?? 0);
    $bullet_text = trim($_POST['bullet_text'] ?? '');
    $position = (int)($_POST['position'] ?? 0);

    $stmt = $pdo->prepare("UPDATE business_support_promo_bullets SET bullet_text=?, position=? WHERE id=?");
    $stmt->execute([$bullet_text, $position, $id]);
    go("saved=1");
  }

  if ($action === "delete_promo_bullet") {
    $id = (int)($_POST['id'] ?? 0);
    $stmt = $pdo->prepare("DELETE FROM business_support_promo_bullets WHERE id=?");
    $stmt->execute([$id]);
    go("deleted=1");
  }

  // ✅ If action was empty or unknown
  throw new Exception("Unknown action: " . $action);

} catch (Exception $e) {
  // ✅ show exact error in URL (so you can see it)
  go("err=1&msg=" . urlencode($e->getMessage()));
}
