<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


$action = $_POST['action'] ?? '';

/* ------------------------------------------
   ✅ SAVE PAGE HEADER
------------------------------------------- */
if ($action == "save_header") {

    $title = $_POST['page_title'];
    $subtitle = $_POST['page_subtitle'];

    // Get old image
    $old = $pdo->query("SELECT bg_image FROM iaos_counselling_settings WHERE id=1")->fetchColumn();
    $image = $old;

    if (!empty($_FILES['bg_image']['name'])) {
        $image = "uploads/" . time() . "_" . $_FILES['bg_image']['name'];
        move_uploaded_file($_FILES['bg_image']['tmp_name'], $image);
    }

    $stm = $pdo->prepare("
        UPDATE iaos_counselling_settings
        SET page_title=?, page_subtitle=?, bg_image=?
        WHERE id=1
    ");
    $stm->execute([$title, $subtitle, $image]);

    header("Location: admin_counselling.php?saved=1");
    exit;
}

/* ------------------------------------------
   ✅ SAVE INTRO MAIN TITLE + PARAGRAPH
------------------------------------------- */
if ($action == "save_intro") {

    $stm = $pdo->prepare("
        UPDATE iaos_counselling_intro
        SET title=?, paragraph=?, bg_color=?
        WHERE id=1
    ");
    $stm->execute([
        $_POST['intro_title'],
        $_POST['intro_paragraph'],
        $_POST['bg_color']
    ]);

    header("Location: admin_counselling.php?saved=1");
    exit;
}

/* ------------------------------------------
   ✅ ADD NEW LANGUAGE PARAGRAPH
------------------------------------------- */
if ($action == "add_language") {
    $stm = $pdo->prepare("
        INSERT INTO iaos_counselling_languages (lang_title, lang_text, position)
        VALUES (?, ?, ?)
    ");
    $stm->execute([
        $_POST['lang_title'],
        $_POST['lang_text'],
        time()
    ]);

    header("Location: admin_counselling.php?saved=1");
    exit;
}

/* ------------------------------------------
   ✅ UPDATE LANGUAGE PARAGRAPH
------------------------------------------- */
if ($action == "update_language") {

    $stm = $pdo->prepare("
        UPDATE iaos_counselling_languages
        SET lang_title=?, lang_text=?
        WHERE id=?
    ");
    $stm->execute([
        $_POST['lang_title'],
        $_POST['lang_text'],
        $_POST['id']
    ]);

    header("Location: admin_counselling.php?saved=1");
    exit;
}

/* ------------------------------------------
   ✅ DELETE LANGUAGE PARAGRAPH
------------------------------------------- */
if ($action == "delete_language") {

    $pdo->prepare("DELETE FROM iaos_counselling_languages WHERE id=?")
        ->execute([$_POST['id']]);

    header("Location: admin_counselling.php?saved=1");
    exit;
}

/* ------------------------------------------
   ✅ ADD COUNSELLOR
------------------------------------------- */
if ($action == "add_counsellor") {

    $stm = $pdo->prepare("
        INSERT INTO iaos_counsellors (name, languages, position)
        VALUES (?, ?, ?)
    ");
    $stm->execute([
        $_POST['name'],
        $_POST['languages'],
        time()
    ]);

    header("Location: admin_counselling.php?saved=1");
    exit;
}

/* ------------------------------------------
   ✅ UPDATE COUNSELLOR
------------------------------------------- */
if ($action == "update_counsellor") {

    $stm = $pdo->prepare("
        UPDATE iaos_counsellors
        SET name=?, languages=?
        WHERE id=?
    ");
    $stm->execute([
        $_POST['name'],
        $_POST['languages'],
        $_POST['id']
    ]);

    header("Location: admin_counselling.php?saved=1");
    exit;
}

/* ------------------------------------------
   ✅ DELETE COUNSELLOR
------------------------------------------- */
if ($action == "delete_counsellor") {

    $pdo->prepare("DELETE FROM iaos_counsellors WHERE id=?")
        ->execute([$_POST['id']]);

    header("Location: admin_counselling.php?saved=1");
    exit;
}

/* ------------------------------------------
   ✅ SAVE FORM INFORMATION
------------------------------------------- */
if ($action == "save_form") {

    $stm = $pdo->prepare("
        UPDATE iaos_counselling_form
        SET form_heading=?, form_note=?
        WHERE id=1
    ");
    $stm->execute([
        $_POST['form_heading'],
        $_POST['form_note']
    ]);

    header("Location: admin_counselling.php?saved=1");
    exit;
}
?>
