<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


function post($k,$d=null){ return isset($_POST[$k]) ? $_POST[$k] : $d; }

$action = post('action','');

if ($action === 'save_header') {
  // Ensure row
  $pdo->exec("INSERT IGNORE INTO education_page_settings (id,page_title,page_subtitle,bg_image) VALUES (1,'Education','', 'images/banner3.jpg')");

  $title = trim(post('page_title','Education'));
  $sub   = trim(post('page_subtitle',''));

  // File upload -> ../images , save path as images/filename.ext
  $bgPath = null;
  if (!empty($_FILES['bg_image_file']['name']) && $_FILES['bg_image_file']['error'] === UPLOAD_ERR_OK) {
    $ext = pathinfo($_FILES['bg_image_file']['name'], PATHINFO_EXTENSION);
    $fname = 'edu_header_'.time().'.'.strtolower($ext);
    $destAbs = __DIR__ . '/../images/' . $fname;
    if (move_uploaded_file($_FILES['bg_image_file']['tmp_name'], $destAbs)) {
      $bgPath = 'images/'.$fname;
    }
  }

  if ($bgPath) {
    $stmt = $pdo->prepare("UPDATE education_page_settings SET page_title=?, page_subtitle=?, bg_image=? WHERE id=1");
    $stmt->execute([$title,$sub,$bgPath]);
  } else {
    $stmt = $pdo->prepare("UPDATE education_page_settings SET page_title=?, page_subtitle=? WHERE id=1");
    $stmt->execute([$title,$sub]);
  }

  header("Location: admin_education.php?saved=1");
  exit;
}

if ($action === 'save_intro') {
  // Ensure row
  $pdo->exec("INSERT IGNORE INTO education_intro_settings (id,intro_paragraph,download_text,download_file) VALUES (1,'',NULL,NULL)");

  $intro = trim(post('intro_paragraph',''));
  $dtext = trim(post('download_text',''));
  $fileName = null;

  if (!empty($_FILES['download_file']['name']) && $_FILES['download_file']['error'] === UPLOAD_ERR_OK) {
    $base = basename($_FILES['download_file']['name']);
    $safe = preg_replace('/[^a-zA-Z0-9._-]/','_', $base);
    $destAbs = __DIR__ . '/../doc/' . $safe;
    if (move_uploaded_file($_FILES['download_file']['tmp_name'], $destAbs)) {
      $fileName = $safe; // stored as filename only; link is doc/filename
    }
  }

  if ($fileName !== null) {
    $stmt = $pdo->prepare("UPDATE education_intro_settings SET intro_paragraph=?, download_text=?, download_file=? WHERE id=1");
    $stmt->execute([$intro, $dtext ?: null, $fileName]);
  } else {
    $stmt = $pdo->prepare("UPDATE education_intro_settings SET intro_paragraph=?, download_text=? WHERE id=1");
    $stmt->execute([$intro, $dtext ?: null]);
  }

  header("Location: admin_education.php?saved=1");
  exit;
}

if ($action === 'add_topic') {
  $title = trim(post('topic_title',''));
  $pos   = (int)post('position',100);
  $btn   = (int)post('show_admission_button',0);
  $stmt = $pdo->prepare("INSERT INTO education_topics (topic_title,position,show_admission_button) VALUES (?,?,?)");
  $stmt->execute([$title,$pos,$btn]);
  header("Location: admin_education.php?saved=1");
  exit;
}

if ($action === 'update_topic') {
  $id    = (int)post('id',0);
  $title = trim(post('topic_title',''));
  $pos   = (int)post('position',100);
  $btn   = (int)post('show_admission_button',0);
  $stmt = $pdo->prepare("UPDATE education_topics SET topic_title=?, position=?, show_admission_button=? WHERE id=?");
  $stmt->execute([$title,$pos,$btn,$id]);
  header("Location: admin_education.php?saved=1");
  exit;
}

if ($action === 'delete_topic') {
  $id = (int)post('id',0);
  $pdo->prepare("DELETE FROM education_topics WHERE id=?")->execute([$id]);
  header("Location: admin_education.php?saved=1");
  exit;
}

if ($action === 'add_para') {
  $topic_id = (int)post('topic_id',0);
  $type = post('type','paragraph');
  $text = post('para_text','');
  $pos  = (int)post('position',100);
  $stmt = $pdo->prepare("INSERT INTO education_paragraphs (topic_id,type,para_text,position) VALUES (?,?,?,?)");
  $stmt->execute([$topic_id,$type,$text,$pos]);
  header("Location: admin_education.php?saved=1");
  exit;
}

if ($action === 'update_para') {
  $id   = (int)post('id',0);
  $type = post('type','paragraph');
  $text = post('para_text','');
  $pos  = (int)post('position',100);
  $stmt = $pdo->prepare("UPDATE education_paragraphs SET type=?, para_text=?, position=? WHERE id=?");
  $stmt->execute([$type,$text,$pos,$id]);
  header("Location: admin_education.php?saved=1");
  exit;
}

if ($action === 'delete_para') {
  $id = (int)post('id',0);
  $pdo->prepare("DELETE FROM education_paragraphs WHERE id=?")->execute([$id]);
  header("Location: admin_education.php?saved=1");
  exit;
}

/* fallback */
header("Location: admin_education.php");
