<?php
ob_start();
require_once "db.php";
session_start();

// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header("Location: admin_membership.php");
  exit;
}

$action = trim($_POST['action'] ?? '');

function go($qs='saved=1'){
  header("Location: admin_membership.php?$qs");
  exit;
}

try {

  // ======================
  // UPDATE HEADER
  // ======================
  if ($action === 'update_header') {

    $page_title = trim($_POST['page_title'] ?? '');
    $page_subtitle = trim($_POST['page_subtitle'] ?? '');

    // keep old bg image by default
    $old = $pdo->query("SELECT bg_image FROM membership_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
    $bg_image = $old['bg_image'] ?? '';

    // upload new image if provided
    if (!empty($_FILES['bg_image']['name'])) {
      $uploadDir = __DIR__ . "/../images/";
      if (!is_dir($uploadDir)) @mkdir($uploadDir, 0777, true);

      $ext = pathinfo($_FILES['bg_image']['name'], PATHINFO_EXTENSION);
      $fileName = "membership_bg_" . time() . "_" . rand(1000,9999) . "." . $ext;

      if (move_uploaded_file($_FILES['bg_image']['tmp_name'], $uploadDir . $fileName)) {
        $bg_image = "images/" . $fileName; // used in frontend
      }
    }

    $stmt = $pdo->prepare("UPDATE membership_page_settings SET page_title=?, page_subtitle=?, bg_image=? WHERE id=1");
    $stmt->execute([$page_title, $page_subtitle, $bg_image]);

    go('saved=1');
  }

  // ======================
  // UPDATE PURPOSE
  // ======================
  if ($action === 'update_purpose') {
    $title = trim($_POST['title'] ?? '');
    $intro = trim($_POST['intro'] ?? '');
    $outro = trim($_POST['outro'] ?? '');

    $stmt = $pdo->prepare("UPDATE membership_purpose SET title=?, intro=?, outro=? WHERE id=1");
    $stmt->execute([$title, $intro, $outro]);

    go('saved=1');
  }

  // ======================
  // BULLETS CRUD
  // ======================
  if ($action === 'add_bullet') {
    $bullet_text = trim($_POST['bullet_text'] ?? '');
    $position = (int)($_POST['position'] ?? 0);

    $stmt = $pdo->prepare("INSERT INTO membership_purpose_bullets (purpose_id, bullet_text, position) VALUES (1, ?, ?)");
    $stmt->execute([$bullet_text, $position]);

    go('saved=1');
  }

  if ($action === 'update_bullet') {
    $id = (int)($_POST['id'] ?? 0);
    $bullet_text = trim($_POST['bullet_text'] ?? '');
    $position = (int)($_POST['position'] ?? 0);

    $stmt = $pdo->prepare("UPDATE membership_purpose_bullets SET bullet_text=?, position=? WHERE id=?");
    $stmt->execute([$bullet_text, $position, $id]);

    go('saved=1');
  }

  if ($action === 'delete_bullet') {
    $id = (int)($_POST['id'] ?? 0);
    $stmt = $pdo->prepare("DELETE FROM membership_purpose_bullets WHERE id=?");
    $stmt->execute([$id]);

    go('deleted=1');
  }

  // ======================
  // CARDS CRUD
  // ======================
  if ($action === 'add_card') {
    $title = trim($_POST['title'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $button_text = trim($_POST['button_text'] ?? 'Join Now');
    $button_link = trim($_POST['button_link'] ?? '');
    $position = (int)($_POST['position'] ?? 0);
    $is_active = (int)($_POST['is_active'] ?? 1);

    $stmt = $pdo->prepare("INSERT INTO membership_cards (title, description, button_text, button_link, position, is_active) VALUES (?,?,?,?,?,?)");
    $stmt->execute([$title, $description, $button_text, $button_link, $position, $is_active]);

    go('saved=1');
  }

  if ($action === 'update_card') {
    $id = (int)($_POST['id'] ?? 0);
    $title = trim($_POST['title'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $button_text = trim($_POST['button_text'] ?? 'Join Now');
    $button_link = trim($_POST['button_link'] ?? '');
    $position = (int)($_POST['position'] ?? 0);
    $is_active = (int)($_POST['is_active'] ?? 1);

    $stmt = $pdo->prepare("UPDATE membership_cards SET title=?, description=?, button_text=?, button_link=?, position=?, is_active=? WHERE id=?");
    $stmt->execute([$title, $description, $button_text, $button_link, $position, $is_active, $id]);

    go('saved=1');
  }

  if ($action === 'delete_card') {
    $id = (int)($_POST['id'] ?? 0);
    $stmt = $pdo->prepare("DELETE FROM membership_cards WHERE id=?");
    $stmt->execute([$id]);

    go('deleted=1');
  }

  // fallback
  go('saved=1');

} catch (Exception $e) {
  // error_log("save_membership error: ".$e->getMessage());
  go('err=1');
}
