<?php
ob_start();
require_once "db.php";
session_start();

if (!isset($_SESSION['user_id'])) { header("Location: index.php"); exit; }
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') { header("Location: index.php"); exit; }

$action = $_POST['action'] ?? '';

function go($qs="saved=1"){
  header("Location: admin_membership_benefits.php?$qs");
  exit;
}

try {

  if (!isset($pdo)) throw new Exception("PDO not found. Check db.php");

  // ✅ update header
  if ($action === "update_header") {
    $page_title = trim($_POST['page_title'] ?? '');
    $page_subtitle = trim($_POST['page_subtitle'] ?? '');

    $old = $pdo->query("SELECT bg_image FROM membership_benefits_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
    $bg_image = $old['bg_image'] ?? null;

    $rootDir = realpath(__DIR__ . "/..");
    $uploadDir = $rootDir . "/uploads";
    if (!is_dir($uploadDir)) @mkdir($uploadDir, 0777, true);

    if (!empty($_FILES['bg_image']['name'])) {
      $ext = strtolower(pathinfo($_FILES['bg_image']['name'], PATHINFO_EXTENSION));
      $allowed = ['jpg','jpeg','png','webp'];
      if (!in_array($ext, $allowed, true)) throw new Exception("Invalid image type");

      $fileName = "membership_benefits_" . time() . "." . $ext;
      $target = $uploadDir . "/" . $fileName;

      if (!move_uploaded_file($_FILES['bg_image']['tmp_name'], $target)) {
        throw new Exception("Upload failed");
      }

      $bg_image = "uploads/" . $fileName;
    }

    $stmt = $pdo->prepare("UPDATE membership_benefits_settings SET page_title=?, page_subtitle=?, bg_image=? WHERE id=1");
    $stmt->execute([$page_title, $page_subtitle, $bg_image]);

    go("saved=1");
  }

  // ✅ update section
  if ($action === "update_section") {
    $id = (int)($_POST['id'] ?? 0);
    $title = trim($_POST['title'] ?? '');
    $content = trim($_POST['content'] ?? '');
    $position = (int)($_POST['position'] ?? 0);
    $is_active = (int)($_POST['is_active'] ?? 1);

    $stmt = $pdo->prepare("UPDATE membership_benefits_sections SET title=?, content=?, position=?, is_active=? WHERE id=?");
    $stmt->execute([$title, $content, $position, $is_active, $id]);
    go("saved=1");
  }

  // ✅ bullets
  if ($action === "add_bullet") {
    $section_key = trim($_POST['section_key'] ?? '');
    $bullet_text = trim($_POST['bullet_text'] ?? '');
    $position = (int)($_POST['position'] ?? 0);

    $stmt = $pdo->prepare("INSERT INTO membership_benefits_bullets (section_key, bullet_text, position) VALUES (?,?,?)");
    $stmt->execute([$section_key, $bullet_text, $position]);
    go("saved=1");
  }

  if ($action === "update_bullet") {
    $id = (int)($_POST['id'] ?? 0);
    $bullet_text = trim($_POST['bullet_text'] ?? '');
    $position = (int)($_POST['position'] ?? 0);

    $stmt = $pdo->prepare("UPDATE membership_benefits_bullets SET bullet_text=?, position=? WHERE id=?");
    $stmt->execute([$bullet_text, $position, $id]);
    go("saved=1");
  }

  if ($action === "delete_bullet") {
    $id = (int)($_POST['id'] ?? 0);
    $stmt = $pdo->prepare("DELETE FROM membership_benefits_bullets WHERE id=?");
    $stmt->execute([$id]);
    go("deleted=1");
  }

  // ✅ cards
  if ($action === "add_card") {
    $business_name = trim($_POST['business_name'] ?? '');
    $category = trim($_POST['category'] ?? '');
    $discount = trim($_POST['discount'] ?? '');
    $offer = trim($_POST['offer'] ?? '');
    $location = trim($_POST['location'] ?? '');
    $contact = trim($_POST['contact'] ?? '');
    $position = (int)($_POST['position'] ?? 0);
    $is_active = (int)($_POST['is_active'] ?? 1);

    $stmt = $pdo->prepare("INSERT INTO membership_benefit_cards
      (business_name, category, discount, offer, location, contact, position, is_active)
      VALUES (?,?,?,?,?,?,?,?)");
    $stmt->execute([$business_name, $category, $discount, $offer, $location, $contact, $position, $is_active]);
    go("saved=1");
  }

  if ($action === "update_card") {
    $id = (int)($_POST['id'] ?? 0);
    $business_name = trim($_POST['business_name'] ?? '');
    $category = trim($_POST['category'] ?? '');
    $discount = trim($_POST['discount'] ?? '');
    $offer = trim($_POST['offer'] ?? '');
    $location = trim($_POST['location'] ?? '');
    $contact = trim($_POST['contact'] ?? '');
    $position = (int)($_POST['position'] ?? 0);
    $is_active = (int)($_POST['is_active'] ?? 1);

    $stmt = $pdo->prepare("UPDATE membership_benefit_cards
      SET business_name=?, category=?, discount=?, offer=?, location=?, contact=?, position=?, is_active=?
      WHERE id=?");
    $stmt->execute([$business_name, $category, $discount, $offer, $location, $contact, $position, $is_active, $id]);
    go("saved=1");
  }

  if ($action === "delete_card") {
    $id = (int)($_POST['id'] ?? 0);
    $stmt = $pdo->prepare("DELETE FROM membership_benefit_cards WHERE id=?");
    $stmt->execute([$id]);
    go("deleted=1");
  }

  throw new Exception("Unknown action: " . $action);

} catch(Exception $e){
  go("err=1&msg=" . urlencode($e->getMessage()));
}
