<?php
ob_start();
require_once "db.php";
session_start();

if (!isset($_SESSION['user_id'])) { header("Location: index.php"); exit; }
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') { header("Location: index.php"); exit; }

$action = $_POST['action'] ?? '';

function go($qs = "saved=1") {
  header("Location: admin_monthly_membership.php?$qs");
  exit;
}

function goErr($msg = "Something went wrong") {
  $msg = substr($msg, 0, 160);
  go("err=1&msg=" . urlencode($msg));
}

try {

  /* =========================
     ✅ UPDATE SETTINGS (UPSERT id=1)
  ========================== */
  if ($action === "update_settings") {

    $page_title       = trim($_POST['page_title'] ?? '');
    $page_subtitle    = trim($_POST['page_subtitle'] ?? '');
    $intro_title      = trim($_POST['intro_title'] ?? '');
    $intro_text       = trim($_POST['intro_text'] ?? '');
    $note_text        = trim($_POST['note_text'] ?? '');

    $form_title       = trim($_POST['form_title'] ?? '');
    $form_subtitle    = trim($_POST['form_subtitle'] ?? '');
    $org_block        = trim($_POST['org_block'] ?? '');

    $fee_amount       = (float)($_POST['fee_amount'] ?? 10);
    $currency         = strtoupper(trim($_POST['currency'] ?? 'CAD'));

    $paypal_client_id = trim($_POST['paypal_client_id'] ?? '');
    $paypal_plan_id   = trim($_POST['paypal_plan_id'] ?? '');

    $success_message  = trim($_POST['success_message'] ?? '');
    $declaration_text = trim($_POST['declaration_text'] ?? '');

    // ✅ Basic validation
    if ($page_title === '' || $intro_title === '' || $form_title === '' || $paypal_client_id === '' || $paypal_plan_id === '') {
      goErr("Required fields missing (title/intro/form/paypal).");
    }

    // currency must be 3 letters (CAD, USD...)
    $currency = preg_replace("/[^A-Z]/", "", $currency);
    if ($currency === '' || strlen($currency) > 5) {
      $currency = "CAD";
    }

    if ($fee_amount <= 0) $fee_amount = 10.00;

    // ✅ Fetch existing row (id=1) to keep old image
    $oldStmt = $pdo->prepare("SELECT bg_image FROM membership_monthly_settings WHERE id=1 LIMIT 1");
    $oldStmt->execute();
    $old = $oldStmt->fetch(PDO::FETCH_ASSOC);

    $bg_image = $old['bg_image'] ?? null;

    // ✅ Upload new bg image (optional)
    if (!empty($_FILES['bg_image']['name'])) {

      if (!isset($_FILES['bg_image']['tmp_name']) || !is_uploaded_file($_FILES['bg_image']['tmp_name'])) {
        goErr("Upload failed (no temp file).");
      }

      $ext = strtolower(pathinfo($_FILES['bg_image']['name'], PATHINFO_EXTENSION));
      $allowed = ['jpg','jpeg','png','webp'];

      if (!in_array($ext, $allowed, true)) {
        goErr("Invalid image type. Allowed: jpg, jpeg, png, webp");
      }

      // ✅ Create uploads folder at site root: ../uploads (because admin folder is inside admin_pannel)
      $uploadsDir = realpath(__DIR__ . "/..") . DIRECTORY_SEPARATOR . "uploads";
      if (!is_dir($uploadsDir)) {
        @mkdir($uploadsDir, 0777, true);
      }

      if (!is_dir($uploadsDir)) {
        goErr("Could not create uploads folder.");
      }

      $fileName   = "monthly_membership_" . time() . "_" . mt_rand(1000,9999) . "." . $ext;
      $targetPath = $uploadsDir . DIRECTORY_SEPARATOR . $fileName;

      if (move_uploaded_file($_FILES['bg_image']['tmp_name'], $targetPath)) {
        // Store relative path in DB (same style you already use)
        $bg_image = "uploads/" . $fileName;
      } else {
        goErr("Could not move uploaded file.");
      }
    }

    // ✅ UPSERT (if row id=1 missing, INSERT it)
    if (!$old) {
      $ins = $pdo->prepare("INSERT INTO membership_monthly_settings
        (id, page_title, page_subtitle, bg_image,
         intro_title, intro_text, note_text,
         form_title, form_subtitle, org_block,
         fee_amount, currency,
         paypal_client_id, paypal_plan_id,
         success_message, declaration_text)
        VALUES
        (1, ?, ?, ?,
         ?, ?, ?,
         ?, ?, ?,
         ?, ?,
         ?, ?,
         ?, ?)
      ");
      $ins->execute([
        $page_title, $page_subtitle, $bg_image,
        $intro_title, $intro_text, $note_text,
        $form_title, $form_subtitle, $org_block,
        $fee_amount, $currency,
        $paypal_client_id, $paypal_plan_id,
        $success_message, $declaration_text
      ]);
    } else {
      $upd = $pdo->prepare("UPDATE membership_monthly_settings
        SET page_title=?, page_subtitle=?, bg_image=?,
            intro_title=?, intro_text=?, note_text=?,
            form_title=?, form_subtitle=?, org_block=?,
            fee_amount=?, currency=?,
            paypal_client_id=?, paypal_plan_id=?,
            success_message=?, declaration_text=?
        WHERE id=1
      ");
      $upd->execute([
        $page_title, $page_subtitle, $bg_image,
        $intro_title, $intro_text, $note_text,
        $form_title, $form_subtitle, $org_block,
        $fee_amount, $currency,
        $paypal_client_id, $paypal_plan_id,
        $success_message, $declaration_text
      ]);
    }

    go("saved=1");
  }

  /* =========================
     ✅ ADD BULLET
  ========================== */
  if ($action === "add_bullet") {
    $bullet_text = trim($_POST['bullet_text'] ?? '');
    $position    = (int)($_POST['position'] ?? 0);
    if ($bullet_text === '') goErr("Bullet text is empty.");

    $stmt = $pdo->prepare("INSERT INTO membership_monthly_bullets (bullet_text, position, is_active) VALUES (?,?,1)");
    $stmt->execute([$bullet_text, $position]);
    go("saved=1");
  }

  /* =========================
     ✅ UPDATE BULLET
  ========================== */
  if ($action === "update_bullet") {
    $id          = (int)($_POST['id'] ?? 0);
    $bullet_text = trim($_POST['bullet_text'] ?? '');
    $position    = (int)($_POST['position'] ?? 0);
    $is_active   = (int)($_POST['is_active'] ?? 1);

    if ($id <= 0) goErr("Invalid bullet id.");
    if ($bullet_text === '') goErr("Bullet text is empty.");
    $is_active = ($is_active === 1) ? 1 : 0;

    $stmt = $pdo->prepare("UPDATE membership_monthly_bullets SET bullet_text=?, position=?, is_active=? WHERE id=?");
    $stmt->execute([$bullet_text, $position, $is_active, $id]);
    go("saved=1");
  }

  /* =========================
     ✅ DELETE BULLET
  ========================== */
  if ($action === "delete_bullet") {
    $id = (int)($_POST['id'] ?? 0);
    if ($id <= 0) goErr("Invalid bullet id.");

    $stmt = $pdo->prepare("DELETE FROM membership_monthly_bullets WHERE id=?");
    $stmt->execute([$id]);
    go("deleted=1");
  }

  // unknown action
  goErr("Invalid action: " . $action);

} catch (Throwable $e) {
  // show short msg on redirect (so you can see why)
  goErr($e->getMessage());
}
