<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


$action = $_POST['action'] ?? '';

function upload_image($field, $diskDir="../uploads", $publicPrefix="uploads") {
  if (empty($_FILES[$field]['name'])) return null;
  if (!is_dir($diskDir)) { @mkdir($diskDir, 0775, true); }
  $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));
  if (!in_array($ext, ['jpg','jpeg','png','webp'])) return null;
  $filename = time() . "_" . preg_replace("/[^a-zA-Z0-9_\.-]/", "_", $_FILES[$field]['name']);
  $fullPath = rtrim($diskDir, "/") . "/" . $filename;
  if (!move_uploaded_file($_FILES[$field]['tmp_name'], $fullPath)) return null;
  return rtrim($publicPrefix, "/") . "/" . $filename; // no ../ in DB
}

/* --------------- SETTINGS (HEADER) --------------- */
if ($action === "save_settings") {
    $title = $_POST['page_title'];
    $subtitle = $_POST['page_subtitle'];

    $bg = $pdo->query("SELECT bg_image FROM iaos_mosque_settings WHERE id=1")->fetchColumn();

    $newBg = upload_image("bg_image", "../uploads", "uploads");
    if ($newBg) $bg = $newBg;

    $pdo->prepare("UPDATE iaos_mosque_settings SET page_title=?, page_subtitle=?, bg_image=? WHERE id=1")
        ->execute([$title, $subtitle, $bg]);

    header("Location: admin_mosque.php?saved=1"); exit;
}

/* --------------- PROGRESS TEXT --------------- */
if ($action === "save_progress_text") {
    $pdo->prepare("UPDATE iaos_mosque_settings SET progress_heading=?, progress_subtext=? WHERE id=1")
        ->execute([$_POST['progress_heading'], $_POST['progress_subtext']]);
    header("Location: admin_mosque.php?saved=1"); exit;
}

/* --------------- GRAPH NUMBERS --------------- */
if ($action === "save_graph") {
    $pdo->prepare("UPDATE iaos_mosque_settings SET collected=?, remaining=?, total=? WHERE id=1")
        ->execute([$_POST['collected'], $_POST['remaining'], $_POST['total']]);
    header("Location: admin_mosque.php?saved=1"); exit;
}

/* --------------- HEADINGS --------------- */
if ($action === "add_heading") {
    $pdo->prepare("INSERT INTO iaos_mosque_headings (heading_text, position) VALUES (?, ?)")
        ->execute([$_POST['heading_text'], time()]);
    header("Location: admin_mosque.php?saved=1"); exit;
}

if ($action === "delete_heading") {
    $id = (int)$_POST['id'];
    $pdo->prepare("DELETE FROM iaos_mosque_paragraphs WHERE heading_id=?")->execute([$id]);
    $pdo->prepare("DELETE FROM iaos_mosque_headings WHERE id=?")->execute([$id]);
    header("Location: admin_mosque.php?saved=1"); exit;
}

/* --------------- PARAGRAPHS --------------- */
if ($action === "add_paragraph") {
    $pdo->prepare("INSERT INTO iaos_mosque_paragraphs (heading_id, para_text, position) VALUES (?, ?, ?)")
        ->execute([$_POST['heading_id'], $_POST['para_text'], time()]);
    header("Location: admin_mosque.php?saved=1"); exit;
}

if ($action === "update_paragraph") {
    $pdo->prepare("UPDATE iaos_mosque_paragraphs SET para_text=? WHERE id=?")
        ->execute([$_POST['para_text'], $_POST['id']]);
    header("Location: admin_mosque.php?saved=1"); exit;
}

if ($action === "delete_paragraph") {
    $pdo->prepare("DELETE FROM iaos_mosque_paragraphs WHERE id=?")->execute([$_POST['id']]);
    header("Location: admin_mosque.php?saved=1"); exit;
}

/* --------------- GALLERY --------------- */
if ($action === "add_gallery_image") {
    $path = upload_image("gallery_image");
    if ($path) {
        $pdo->prepare("INSERT INTO iaos_mosque_gallery (image_path) VALUES (?)")->execute([$path]);
    }
    header("Location: admin_mosque.php?saved=1"); exit;
}

if ($action === "delete_gallery_image") {
    $id = (int)$_POST['id'];

    $stmt = $pdo->prepare("SELECT image_path FROM iaos_mosque_gallery WHERE id=?");
    $stmt->execute([$id]);
    $rel = $stmt->fetchColumn();

    if ($rel) {
        $disk = "../" . $rel;
        if (is_file($disk)) @unlink($disk);
    }

    $pdo->prepare("DELETE FROM iaos_mosque_gallery WHERE id=?")->execute([$id]);

    header("Location: admin_mosque.php?saved=1"); exit;
}

header("Location: admin_mosque.php");
