<?php
ob_start();
require_once "db.php";
session_start();

// ✅ SECURITY CHECKS
if (!isset($_SESSION['user_id']) || !isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
    header("Location: index.php");
    exit;
}

$uploadDir = '../images/'; // Folder for uploaded images
$redirect = "admin_news.php?saved=1";

// ---------------- ACTIONS ----------------
$action = $_POST['action'] ?? '';

if ($action === 'save_settings') {
    // Save global settings
    $page_title = $_POST['page_title'] ?? '';
    $page_subtitle = $_POST['page_subtitle'] ?? '';

    // Handle background image
    $bg_image = '';
    if (!empty($_FILES['bg_image']['name'])) {
        $bg_image = $uploadDir . basename($_FILES['bg_image']['name']);
        move_uploaded_file($_FILES['bg_image']['tmp_name'], $bg_image);
    }

    // Check if settings row exists
    $set = $pdo->query("SELECT * FROM iaos_news_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
    if ($set) {
        $stmt = $pdo->prepare("UPDATE iaos_news_settings SET page_title=?, page_subtitle=?".($bg_image?', bg_image=?':'')." WHERE id=1");
        $params = [$page_title, $page_subtitle];
        if ($bg_image) $params[] = substr($bg_image, 3); // remove ../
        $stmt->execute($params);
    } else {
        $stmt = $pdo->prepare("INSERT INTO iaos_news_settings (id,page_title,page_subtitle,bg_image) VALUES (1,?,?,?)");
        $stmt->execute([$page_title, $page_subtitle, substr($bg_image,3)]);
    }
    header("Location: $redirect");
    exit;
}

// ---------------- ADD POST ----------------
if ($action === 'add_post') {
    $intro_heading = $_POST['intro_heading'] ?? '';
    $intro_text = $_POST['intro_text'] ?? '';
    $publish_date = $_POST['publish_date'] ?? date('Y-m-d');
    $link = $_POST['link'] ?? '';
    $link_text = $_POST['link_text'] ?? '';

    $image = '';
    if (!empty($_FILES['news_image']['name'])) {
        $image = $uploadDir . basename($_FILES['news_image']['name']);
        move_uploaded_file($_FILES['news_image']['tmp_name'], $image);
        $image = substr($image, 3);
    }

    $stmt = $pdo->prepare("INSERT INTO iaos_news_posts (intro_heading,intro_text,publish_date,link,link_text,image) VALUES (?,?,?,?,?,?)");
    $stmt->execute([$intro_heading,$intro_text,$publish_date,$link,$link_text,$image]);

    header("Location: $redirect");
    exit;
}

// ---------------- UPDATE POST ----------------
if ($action === 'save_post_intro') {
    $post_id = $_POST['post_id'] ?? 0;
    $intro_heading = $_POST['intro_heading'] ?? '';
    $intro_text = $_POST['intro_text'] ?? '';
    $publish_date = $_POST['publish_date'] ?? date('Y-m-d');
    $link = $_POST['link'] ?? '';
    $link_text = $_POST['link_text'] ?? '';

    // Handle image
    $stmt = $pdo->prepare("SELECT image FROM iaos_news_posts WHERE id=?");
    $stmt->execute([$post_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $image = $row['image'];

    if (!empty($_FILES['news_image']['name'])) {
        $imagePath = $uploadDir . basename($_FILES['news_image']['name']);
        move_uploaded_file($_FILES['news_image']['tmp_name'], $imagePath);
        $image = substr($imagePath,3);
    }

    $stmt = $pdo->prepare("UPDATE iaos_news_posts SET intro_heading=?, intro_text=?, publish_date=?, link=?, link_text=?, image=? WHERE id=?");
    $stmt->execute([$intro_heading,$intro_text,$publish_date,$link,$link_text,$image,$post_id]);

    header("Location: $redirect&id=$post_id");
    exit;
}

// ---------------- DELETE POST ----------------
if ($action === 'delete_post') {
    $post_id = $_POST['post_id'] ?? 0;
    $stmt = $pdo->prepare("DELETE FROM iaos_news_posts WHERE id=?");
    $stmt->execute([$post_id]);
    $stmt = $pdo->prepare("DELETE FROM iaos_news_paragraphs WHERE post_id=?");
    $stmt->execute([$post_id]);

    header("Location: $redirect");
    exit;
}

// ---------------- ADD PARAGRAPH ----------------
if ($action === 'add_paragraph') {
    $post_id = $_POST['post_id'] ?? 0;
    $para_text = $_POST['para_text'] ?? '';
    $stmt = $pdo->prepare("INSERT INTO iaos_news_paragraphs (post_id, para_text) VALUES (?,?)");
    $stmt->execute([$post_id, $para_text]);

    header("Location: $redirect&id=$post_id");
    exit;
}

// ---------------- UPDATE PARAGRAPH ----------------
if ($action === 'update_paragraph') {
    $para_id = $_POST['para_id'] ?? 0;
    $post_id = $_POST['post_id'] ?? 0;
    $para_text = $_POST['para_text'] ?? '';

    $stmt = $pdo->prepare("UPDATE iaos_news_paragraphs SET para_text=? WHERE id=?");
    $stmt->execute([$para_text,$para_id]);

    header("Location: $redirect&id=$post_id");
    exit;
}

// ---------------- DELETE PARAGRAPH ----------------
if ($action === 'delete_paragraph') {
    $para_id = $_POST['para_id'] ?? 0;
    $post_id = $_POST['post_id'] ?? 0;

    $stmt = $pdo->prepare("DELETE FROM iaos_news_paragraphs WHERE id=?");
    $stmt->execute([$para_id]);

    header("Location: $redirect&id=$post_id");
    exit;
}

// ---------------- DEFAULT ----------------
header("Location: $redirect");
exit;
