<?php
require_once "admin_pannel/db.php";  // ✅ editorial database

/* ✅ LOAD SETTINGS */
$set = $pdo->query("SELECT * FROM iaos_imam_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* ✅ LOAD BIO */
$bio = $pdo->query("SELECT * FROM iaos_imam_bio WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* ✅ LOAD BIO PARAGRAPHS */
$paras = $pdo->query("SELECT * FROM iaos_imam_bio_paragraphs ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);

/* ✅ Handle Ask Form with DIFFERENT DB */
$error_message = "";

// ✅ Load second DB for Imam form
require_once "../db.php";
$pdo2 = get_db();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['full_name']) && !empty($_POST['question'])) {

    $stmt = $pdo2->prepare("
        INSERT INTO imam_questions (full_name, email, phone, question, status, created_at)
        VALUES (?, ?, ?, ?, 'pending', NOW())
    ");

    $stmt->execute([
        $_POST['full_name'],
        $_POST['email'],
        $_POST['phone'],
        $_POST['question']
    ]);

    $qid = $pdo2->lastInsertId();
    header("Location: ../user_chat.php?id=$qid");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= htmlspecialchars($set['page_title']) ?> | IAOS Regina</title>

  <!-- Bootstrap & Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <link rel="icon" type="image/png" href="images/fav.png">
  <link rel="stylesheet" href="css/style.css">
</head>

<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<!-- NAVBAR -->
<?php include 'header.php'; ?>

<!-- ✅ PAGE HEADER -->
<section class="page-header text-center text-white py-5" 
  style="background:url('<?= htmlspecialchars($set['bg_image']) ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2"><?= htmlspecialchars($set['page_title']) ?></h1>
    <p class="lead"><?= nl2br(htmlspecialchars($set['page_subtitle'])) ?></p>
  </div>
</section>

<!-- ✅ IMAM BIO -->
<section class="py-5">
  <div class="container-xl text-white">

    <div class="row align-items-center mb-5">
      <div class="col-md-4 text-center mb-4 mb-md-0">
        <img src="<?= htmlspecialchars($bio['imam_image']) ?>" 
             alt="<?= htmlspecialchars($bio['imam_name']) ?>" 
             class="rounded-circle shadow-lg" width="250" height="250">
      </div>

      <div class="col-md-8">
        <h3 class="fw-bold text-warning mb-3"><?= htmlspecialchars($bio['imam_name']) ?></h3>

        <?php foreach ($paras as $p): ?>
          <p><?= nl2br(htmlspecialchars($p['para_text'])) ?></p>
        <?php endforeach; ?>

        <p class="mt-3">
          📅 <strong>To schedule an appointment:</strong><br>
          <a href="mailto:<?= htmlspecialchars($bio['appointment_email']) ?>" 
             class="text-warning text-decoration-none"><?= htmlspecialchars($bio['appointment_email']) ?></a><br>

          📧 <strong>Email for questions:</strong><br>
          <a href="mailto:<?= htmlspecialchars($bio['question_email']) ?>" 
             class="text-warning text-decoration-none"><?= htmlspecialchars($bio['question_email']) ?></a>
        </p>
      </div>
    </div>

    <hr class="border-light mb-5">

    <!-- ✅ ASK FORM (INSERTS INTO SECOND DB) -->
    <div class="card shadow-lg border-0 mx-auto" style="max-width:800px;">
      <div class="card-header bg-success text-white text-center py-4">
        <h4 class="mb-1"><i class="bi bi-moon-stars-fill me-2"></i> Ask Our Imam</h4>
        <small class="text-light">Submit your question and receive a reply directly from our Imam</small>
      </div>
	  
	  <div class="card-body bg-dark text-light">
		  <!-- ✅ Book Appointment Button -->
		  <div class="text-center">
			<a href="../book_appoiment.php"
			   target="_blank"
			   class="btn btn-outline-light btn-lg w-100">
			  <i class="bi bi-calendar-plus me-2"></i> Book Appointment with Imam
			</a>
		  </div>
	  </div>


      <div class="card-body bg-dark text-light p-4">
        <?php if (!empty($error_message)): ?>
          <div class="alert alert-danger text-center"><?= htmlentities($error_message) ?></div>
        <?php endif; ?>

        <form method="post" autocomplete="off">
          <div class="mb-3">
            <label class="form-label"><i class="bi bi-person-fill"></i> Full Name</label>
            <input type="text" name="full_name" class="form-control" required>
          </div>

          <div class="mb-3">
            <label class="form-label"><i class="bi bi-envelope-fill"></i> Email (optional)</label>
            <input type="email" name="email" class="form-control">
          </div>

          <div class="mb-3">
            <label class="form-label"><i class="bi bi-telephone-fill"></i> Phone (optional)</label>
            <input type="text" name="phone" class="form-control">
          </div>

          <div class="mb-3">
            <label class="form-label"><i class="bi bi-chat-left-text-fill"></i> Your Question</label>
            <textarea name="question" class="form-control" rows="5" required></textarea>
          </div>

          <button class="btn btn-success w-100 py-2 fs-5">
            <i class="bi bi-send-fill me-1"></i> Submit Question
          </button>
        </form>
      </div>
    </div>

  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<!-- FOOTER -->
<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.querySelector("form").addEventListener("submit", function() {
  const btn = this.querySelector("button");
  btn.disabled = true;
  btn.innerHTML = '<i class="bi bi-hourglass-split me-1"></i> Submitting...';
});
</script>

<!-- Fixed Donate Button -->
<a href="#donate" class="mobile-donate-btn">Donate Now</a>

<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');

window.addEventListener('scroll', () => {
  donateBtn.style.opacity = window.scrollY > lastScrollY ? '0' : '1';
  lastScrollY = window.scrollY;
});
</script>

</body>
</html>
