<?php
// business_register_submit.php
require_once "admin_pannel/db.php"; // must provide $pdo (PDO)

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
  echo json_encode(["status" => "error", "message" => "Invalid request"]);
  exit;
}

function clean($v) {
  $v = trim((string)$v);
  $v = preg_replace('/\s+/', ' ', $v);
  return $v;
}

$business_name     = clean($_POST["business_name"] ?? "");
$contact_person    = clean($_POST["contact_person"] ?? "");
$phone             = clean($_POST["phone"] ?? "");
$email             = clean($_POST["email"] ?? "");
$business_category = clean($_POST["business_category"] ?? "");
$address           = clean($_POST["address"] ?? "");
$website           = clean($_POST["website"] ?? "");
$discount_offer    = clean($_POST["discount_offer"] ?? "");
$special_conditions= clean($_POST["special_conditions"] ?? "");

if (
  $business_name === "" || $contact_person === "" || $phone === "" ||
  $email === "" || $business_category === "" || $address === "" || $discount_offer === ""
) {
  echo json_encode(["status" => "error", "message" => "Please fill all required fields."]);
  exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  echo json_encode(["status" => "error", "message" => "Please enter a valid email."]);
  exit;
}

// optional fields -> NULL
$website = ($website === "") ? null : $website;
$special_conditions = ($special_conditions === "") ? null : $special_conditions;

$ip = $_SERVER["REMOTE_ADDR"] ?? null;
$ua = $_SERVER["HTTP_USER_AGENT"] ?? null;

try {
  $stmt = $pdo->prepare("
    INSERT INTO business_registrations
    (business_name, contact_person, phone, email, business_category, address, website, discount_offer, special_conditions, status, ip_address, user_agent)
    VALUES
    (:business_name, :contact_person, :phone, :email, :business_category, :address, :website, :discount_offer, :special_conditions, 'pending', :ip_address, :user_agent)
  ");

  $stmt->execute([
    ":business_name"      => $business_name,
    ":contact_person"     => $contact_person,
    ":phone"              => $phone,
    ":email"              => $email,
    ":business_category"  => $business_category,
    ":address"            => $address,
    ":website"            => $website,
    ":discount_offer"     => $discount_offer,
    ":special_conditions" => $special_conditions,
    ":ip_address"         => $ip,
    ":user_agent"         => $ua,
  ]);

  echo json_encode(["status" => "ok"]);
  exit;

} catch (Exception $e) {
  // error_log("Business Register Error: " . $e->getMessage());
  echo json_encode(["status" => "error", "message" => "Server error. Please try again later."]);
  exit;
}
