<?php
require_once "admin_pannel/db.php"; // ✅ must provide $pdo

$settings = $pdo->query("SELECT * FROM business_support_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

$whyBullets = $pdo->query("SELECT * FROM business_support_why_bullets ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$promoBullets = $pdo->query("SELECT * FROM business_support_promo_bullets ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// fallback safe
if(!$settings){
  $settings = [
    "page_title"=>"Support & Partnerships",
    "page_subtitle"=>"",
    "bg_image"=>"images/banner5.jpg",
    "why_title"=>"Why Partner With Us?",
    "form_title"=>"Business Registration Form",
    "form_intro"=>"",
    "promo_title"=>"Your promotion will be displayed:",
    "note_text"=>"",
    "success_message"=>"✅ Thank you! Please wait — IAOS will contact you soon."
  ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Community Support Partners | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Custom CSS -->
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5"
  style="background:url('<?= htmlspecialchars($settings['bg_image'] ?? 'images/banner5.jpg') ?>') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2"><?= htmlspecialchars($settings['page_title'] ?? '') ?></h1>
    <p class="lead"><?= htmlspecialchars($settings['page_subtitle'] ?? '') ?></p>
  </div>
</section>

<!-- ================= WHY PARTNER ================= -->
<section class="about-section py-5 text-white">
  <div class="container-xl">

    <div class="mb-5">
      <h3 class="greet-title greet-title-in text-white fw-bold mb-3">
        <?= htmlspecialchars($settings['why_title'] ?? 'Why Partner With Us?') ?>
      </h3>

      <ul class="fs-5">
        <?php if(!empty($whyBullets)): ?>
          <?php foreach($whyBullets as $b): ?>
            <li><?= htmlspecialchars($b['bullet_text']) ?></li>
          <?php endforeach; ?>
        <?php else: ?>
          <li>Reach hundreds of members and their families</li>
        <?php endif; ?>
      </ul>
    </div>

    <!-- ================= BUSINESS FORM ================= -->
    <div class="bg-white p-4 rounded shadow-sm text-dark">
      <h3 class="fw-bold text-success mb-3">
        <?= htmlspecialchars($settings['form_title'] ?? 'Business Registration Form') ?>
      </h3>

      <?php if(!empty($settings['form_intro'])): ?>
        <p class="mb-4 text-black"><?= nl2br(htmlspecialchars($settings['form_intro'])) ?></p>
      <?php endif; ?>

      <?php if(!empty($settings['promo_title'])): ?>
        <ul>
          <?php foreach($promoBullets as $p): ?>
            <li><?= htmlspecialchars($p['bullet_text']) ?></li>
          <?php endforeach; ?>
        </ul>
      <?php endif; ?>

      <hr>

      <!-- ✅ AJAX message area -->
      <div id="formMsg" class="d-none alert" role="alert"></div>

      <form id="businessRegForm" autocomplete="off">
        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Business Name *</label>
            <input type="text" class="form-control" name="business_name" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Contact Person *</label>
            <input type="text" class="form-control" name="contact_person" required>
          </div>
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Phone Number *</label>
            <input type="text" class="form-control" name="phone" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Email *</label>
            <input type="email" class="form-control" name="email" required>
          </div>
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Business Category *</label>
            <input type="text" class="form-control" name="business_category" placeholder="e.g. Restaurant, Retail, Service…" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Address *</label>
            <input type="text" class="form-control" name="address" required>
          </div>
        </div>

        <div class="mb-3">
          <label>Website or Social Media Link</label>
          <input type="text" class="form-control" name="website">
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Discount Offer *</label>
            <input type="text" class="form-control" name="discount_offer" placeholder="e.g. 10% off, Buy 1 Get 1" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Special Conditions (optional)</label>
            <input type="text" class="form-control" name="special_conditions">
          </div>
        </div>

        <?php if(!empty($settings['note_text'])): ?>
          <p class="mt-3 small text-muted"><?= nl2br(htmlspecialchars($settings['note_text'])) ?></p>
        <?php endif; ?>

        <div class="text-center mt-4">
          <button id="submitBtn" type="submit" class="btn btn-success px-5 py-2">
            <i class="bi bi-send-fill me-2"></i>Submit Registration Form
          </button>
        </div>
      </form>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>

<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Fixed Donate Button (Mobile Only) -->
<a href="#donate" class="mobile-donate-btn">Donate Now</a>

<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll', () => {
  donateBtn.style.opacity = window.scrollY > lastScrollY ? '0' : '1';
  lastScrollY = window.scrollY;
});
</script>

<!-- ✅ AJAX submit -->
<script>
document.addEventListener("DOMContentLoaded", () => {
  const form = document.getElementById("businessRegForm");
  const msg  = document.getElementById("formMsg");
  const btn  = document.getElementById("submitBtn");

  const successText = <?= json_encode($settings['success_message'] ?? '✅ Thank you! Please wait — IAOS will contact you soon.') ?>;

  if (!form) return;

  function showMsg(type, text) {
    msg.classList.remove("d-none", "alert-success", "alert-danger", "alert-warning");
    msg.classList.add(type === "success" ? "alert-success" : "alert-danger");
    msg.innerHTML = text;
  }

  form.addEventListener("submit", async (e) => {
    e.preventDefault();

    msg.classList.add("d-none");
    btn.disabled = true;

    const formData = new FormData(form);

    try {
      const res = await fetch("business_register_submit.php", {
        method: "POST",
        body: formData
      });

      const data = await res.json();

      if (data.status === "ok") {
        showMsg("success", successText);
        form.reset();
      } else {
        showMsg("error", "❌ " + (data.message || "Something went wrong. Please try again."));
      }
    } catch (err) {
      showMsg("error", "❌ Network error. Please try again.");
    } finally {
      btn.disabled = false;
    }
  });
});
</script>

</body>
</html>
