<?php
require_once "admin_pannel/db.php";

/* GLOBAL HEADER SETTINGS */
$set = $pdo->query("SELECT * FROM iaos_careers_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* ALL JOBS */
$jobs = $pdo->query("SELECT * FROM iaos_careers_jobs ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);

/* GROUPED DATA */
$reqsByJob = [];
$headsByJob = [];
$parasByHeading = [];

if ($jobs) {

    /* JOB IDS */
    $jobIds = array_column($jobs, 'id');
    $in = implode(',', array_fill(0, count($jobIds), '?'));

    /* REQUIREMENTS (correct: job_id) */
    $stmt = $pdo->prepare("
        SELECT * FROM iaos_careers_requirements
        WHERE job_id IN ($in)
        ORDER BY position ASC, id ASC
    ");
    $stmt->execute($jobIds);
    foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $r) {
        $reqsByJob[$r['job_id']][] = $r;
    }

    /* HEADINGS (correct: job_id) */
    $stmt = $pdo->prepare("
        SELECT * FROM iaos_careers_headings
        WHERE job_id IN ($in)
        ORDER BY position ASC, id ASC
    ");
    $stmt->execute($jobIds);
    $allHeads = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($allHeads as $h) {
        $headsByJob[$h['job_id']][] = $h;
    }

    /* PARAGRAPHS (correct: heading_id) */
    if ($allHeads) {
        $headIds = array_column($allHeads, 'id');
        $inHeads = implode(',', array_fill(0, count($headIds), '?'));

        $stmt = $pdo->prepare("
            SELECT * FROM iaos_careers_paragraphs
            WHERE heading_id IN ($inHeads)
            ORDER BY position ASC, id ASC
        ");
        $stmt->execute($headIds);

        foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $p) {
            $parasByHeading[$p['heading_id']][] = $p;
        }
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= htmlspecialchars($set['page_title'] ?? 'Career Opportunities') ?> | IAOS Regina</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="icon" type="image/png" href="images/fav.png">
  <link rel="stylesheet" href="css/style.css">
</head>
<body>
    
    <!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>


<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<section class="page-header text-center text-white py-5"
  style="background:url('<?= htmlspecialchars($set['bg_image'] ?: "images/banner3.jpg") ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2"><?= htmlspecialchars($set['page_title']) ?></h1>
    <p class="lead"><?= htmlspecialchars($set['page_subtitle']) ?></p>
  </div>
</section>

<!-- CONTENT -->
<section class="py-5">
  <div class="container-xl text-white">

    <!-- ✅ ADDED: NO JOBS MESSAGE -->
    <?php if (empty($jobs)): ?>
      <div class="text-center py-5">
        <h3 class="fw-bold text-white mb-3">No Job Opportunities Available</h3>
        <p class="lead text-light">
          There are currently no open positions at IAOS Regina.<br>
          Please check back again soon.
        </p>
      </div>
    <?php endif; ?>
    <!-- ✅ END ADDED -->

    <?php foreach ($jobs as $job): ?>
      
      <!-- INTRO -->
      <div class="mb-5">
        <h3 class="greet-title greet-title-in fw-bold mb-3 text-white">
          <?= htmlspecialchars($job['intro_heading']) ?>
        </h3>
        <p><?= nl2br(htmlspecialchars($job['intro_text'])) ?></p>
      </div>

      <!-- REQUIREMENTS -->
      <?php $reqs = $reqsByJob[$job['id']] ?? []; ?>
      <?php if ($reqs): ?>
        <div class="bg-light text-dark p-4 rounded shadow-sm mb-4">
          <h4 class="fw-bold text-success mb-3">
            <i class="bi bi-list-check me-2"></i>Candidate Qualifications
          </h4>
          <ul class="list-group list-group-flush">
            <?php foreach ($reqs as $r): ?>
              <li class="list-group-item">✅ <?= htmlspecialchars($r['item_text']) ?></li>
            <?php endforeach; ?>
          </ul>
        </div>
      <?php endif; ?>

      <!-- HEADINGS + PARAGRAPHS -->
      <?php $heads = $headsByJob[$job['id']] ?? []; ?>
      <?php foreach ($heads as $h): ?>
        <div class="bg-dark p-4 rounded mb-4">
          <h4 class="text-warning fw-bold mb-2">
            <?= htmlspecialchars($h['heading_text']) ?>
          </h4>

          <?php foreach (($parasByHeading[$h['id']] ?? []) as $p): ?>
            <p><?= nl2br(htmlspecialchars($p['para_text'])) ?></p>
          <?php endforeach; ?>
        </div>
      <?php endforeach; ?>

      <!-- APPLY SECTION -->
      <div class="apply-box text-center mt-5 mb-5">
        <h4 class="fw-bold text-white mb-3">
          <i class="bi bi-envelope-paper me-2"></i>How to Apply
        </h4>
        <p class="lead">
          Please send your resume to:<br>
          <a href="mailto:<?= htmlspecialchars($job['apply_email']) ?>" class="text-warning fw-bold">
            <?= htmlspecialchars($job['apply_email']) ?>
          </a><br>
          by <strong><?= htmlspecialchars($job['apply_deadline']) ?></strong>.
        </p>

        <a href="mailto:<?= htmlspecialchars($job['apply_email']) ?>" class="btn btn-warning btn-lg mt-3">
          <i class="bi bi-send-fill me-2"></i>Send Your Resume
        </a>
      </div>

      <hr class="border-secondary opacity-25 my-5">

    <?php endforeach; ?>

  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>
</body>
</html>
