<?php
require_once "admin_pannel/db.php";

// HEADER
$header = $pdo->query("SELECT * FROM iaos_counselling_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// INTRO MAIN HEADING
$intro = $pdo->query("SELECT * FROM iaos_counselling_intro WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// LANG PARAGRAPHS
$langs = $pdo->query("SELECT * FROM iaos_counselling_languages ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// COUNSELLORS
$counsellors = $pdo->query("SELECT * FROM iaos_counsellors ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// FORM SECTION
$form = $pdo->query("SELECT * FROM iaos_counselling_form WHERE id=1")->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($header['page_title']) ?> | IAOS Regina</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/style.css">
<link rel="icon" href="images/fav.png">
</head>

<body>
    
    <!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ✅ PAGE HEADER -->
<section class="page-header text-center text-white py-5"
 style="background:url('<?= htmlspecialchars($header['bg_image']) ?>') center/cover no-repeat;">
  <div class="overlay"></div>

  <h1 class="display-4 fw-bold"><?= htmlspecialchars($header['page_title']) ?></h1>
  <p class="lead"><?= htmlspecialchars($header['page_subtitle']) ?></p>
</section>

<!-- ✅ INTRO MAIN SECTION -->
<section class="py-5">
  <div class="container-xl">

    <h2 class="greet-title greet-title-in text-white">
      <?= htmlspecialchars($intro['title']) ?>
    </h2>

    <br>

    <!-- Green or White Box -->
    <p class="text-white mb-3"><?= nl2br(htmlspecialchars($intro['paragraph'])) ?></p>

    <div class="p-4 rounded-3 shadow-sm mb-4 
      <?= $intro['bg_color']=="green" ? "bg-success text-white" : "bg-light text-dark" ?>">
      
      <?php foreach ($langs as $l): ?>
        <p class="mb-2">
          <strong><?= htmlspecialchars($l['lang_title']) ?>:</strong>
          <?= nl2br(htmlspecialchars($l['lang_text'])) ?>
        </p>
      <?php endforeach; ?>

    </div>

  </div>
</section>

<!-- ✅ HOW TO SEEK ASSISTANCE -->
<section class="py-5 bg-light">
  <div class="container-xl">

    <h3 class="greet-title greet-title-in">How to Seek Assistance</h3>
    <br>

    <p><?= htmlspecialchars($intro['how_text'] ?? "You can book an appointment with our counselling team.") ?></p>

  </div>
</section>

<!-- ✅ COUNSELLORS -->
<section class="py-5">
  <div class="container-xl">
    
    <h3 class="greet-title greet-title-in text-white">Available Counsellors & Languages</h3>
    <br>

    <table class="table table-bordered table-striped bg-light text-dark align-middle">
      <thead class="table-success text-center">
        <tr><th>Counsellor</th><th>Languages</th></tr>
      </thead>
      <tbody>
        <?php foreach($counsellors as $c): ?>
          <tr>
            <td><?= htmlspecialchars($c['name']) ?></td>
            <td><?= htmlspecialchars($c['languages']) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

    <p class="text-white mt-3">
      <?= htmlspecialchars($intro['note_bottom'] ?? "A French interpreter is available when needed.") ?>
    </p>

  </div>
</section>

<!-- ================= CONTACT FORM SECTION ================= -->

<?php
ob_start();
include "get_contact_heading.php";
$contactJson = ob_get_clean();
$contact = json_decode($contactJson, true);

$headingC = $contact['heading_text'] ?? "Contact Us";
$subC =     $contact['sub_text'] ?? "We’d love to hear from you.";
?>

<section class="contact-section py-5 bg-light">
  <div class="container-xl">
    <div class="text-center mb-5">
      <h2 class="greet-title"><?= htmlspecialchars($headingC) ?></h2>
		<p class="text-muted"><?= htmlspecialchars($subC) ?></p>
    </div>

    <div class="row justify-content-center">
      <div class="col-md-8">
        <form class="contact-form p-4 rounded-3 shadow-sm bg-white" action="contact-submit.php" method="POST">
          <div class="row g-3">
            
            <!-- First Name -->
            <div class="col-md-6">
              <label for="firstName" class="form-label fw-semibold">First Name</label>
              <input type="text" class="form-control" id="firstName" name="firstName" placeholder="Enter your first name" required>
            </div>

            <!-- Last Name -->
            <div class="col-md-6">
              <label for="lastName" class="form-label fw-semibold">Last Name</label>
              <input type="text" class="form-control" id="lastName" name="lastName" placeholder="Enter your last name" required>
            </div>

            <!-- Email -->
            <div class="col-md-6">
              <label for="email" class="form-label fw-semibold">Email</label>
              <input type="email" class="form-control" id="email" name="email" placeholder="Enter your email" required>
            </div>

            <!-- Phone -->
            <div class="col-md-6">
              <label for="phone" class="form-label fw-semibold">Phone Number</label>
              <input type="tel" class="form-control" id="phone" name="phone" placeholder="Enter your phone number">
            </div>

            <!-- Category -->
            <div class="col-md-6">
              <label for="category" class="form-label fw-semibold">Category</label>
              <select id="category" name="category" class="form-select" required>
                <option selected disabled value="">Choose...</option>
                <option>General Inquiry</option>
                <option>Imam Inquiry</option>
                <option>Complaint</option>
                <option>Opinion</option>
                <option>Compliment</option>
              </select>
            </div>

            <!-- Subject -->
            <div class="col-md-6">
              <label for="subject" class="form-label fw-semibold">Subject</label>
              <input type="text" class="form-control" id="subject" name="subject" placeholder="Enter subject" required>
            </div>

            <!-- Message -->
            <div class="col-12">
              <label for="message" class="form-label fw-semibold">Message</label>
              <textarea id="message" name="message" class="form-control" rows="5" placeholder="Write your message here..." required></textarea>
            </div>

            <!-- Submit Button -->
            <div class="col-12 text-center mt-3">
              <button type="submit" class="btn btn-success px-4 py-2 rounded-pill">
                <i class="bi bi-send me-2"></i> Send Message
              </button>
            </div>

          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>
</body>
</html>
