<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

// log to file in same folder
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/mail_test.log');

$msg = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $to = trim($_POST["email"] ?? "");

    if (!filter_var($to, FILTER_VALIDATE_EMAIL)) {
        $msg = "❌ Invalid email";
    } else {

        $fromEmail = "testuser@iaosregina.com"; // must be your domain
        $fromName  = "IAOS Regina";

        $subject = "Test Email (PHP mail)";
        $body    = "Hello!\nThis is a test email.\nTime: " . date("Y-m-d H:i:s");

        $headers  = "From: {$fromName} <{$fromEmail}>\r\n";
        $headers .= "Reply-To: {$fromEmail}\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $headers .= "Message-ID: <" . md5(uniqid('', true)) . "@iaosregina.com>\r\n";
        $headers .= "X-Mailer: PHP/" . phpversion() . "\r\n";

        // envelope sender
        $ok = @mail($to, $subject, $body, $headers, "-f{$fromEmail}");

        error_log("MAIL TEST => to={$to} ok=" . ($ok ? "1" : "0") . " from={$fromEmail}");

        $msg = $ok
            ? "✅ mail() TRUE. If not received, check cPanel → Track Delivery."
            : "❌ mail() FALSE. Server mail not configured.";
    }
}
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Mail Test</title></head>
<body style="font-family:Arial;padding:20px;">
  <h2>Send Test Email (mail())</h2>

  <?php if($msg): ?>
    <p><b><?php echo htmlspecialchars($msg); ?></b></p>
  <?php endif; ?>

  <form method="post">
    <input type="email" name="email" required placeholder="receiver@gmail.com"
           style="padding:10px;width:320px;">
    <button type="submit" style="padding:10px 14px;">Send</button>
  </form>

  <p style="color:#666;font-size:13px;">
    Log file: <b>mail_test.log</b> (same folder).
  </p>
</body>
</html>
