<?php
require_once "admin_pannel/db.php";

$sections = $pdo->query("SELECT section_key, content FROM footer_sections")->fetchAll(PDO::FETCH_KEY_PAIR);
function getLinks($cat, $pdo) {
  $s = $pdo->prepare("SELECT * FROM footer_links WHERE category=? AND active=1 ORDER BY position ASC");
  $s->execute([$cat]);
  return $s->fetchAll(PDO::FETCH_ASSOC);
}
$quick = getLinks('quick_links',$pdo);
$res = getLinks('resources',$pdo);
$social = getLinks('social',$pdo);
?>
<footer class="site-footer text-white">
  <div class="container-xl">
    <div class="row g-4">

      <div class="col-md-3">
        <div class="footer-logo mb-3">
          <img src="<?= htmlspecialchars($sections['about_logo']) ?>" alt="IAOS" class="logo">
        </div>
        <h6><?= htmlspecialchars($sections['about_title']) ?></h6>
        <ul class="list-unstyled small mb-0">
          <li><?= htmlspecialchars($sections['about_address']) ?></li>
          <li><?= htmlspecialchars($sections['about_phone']) ?></li>
        </ul>
      </div>

      <div class="col-md-3">
        <h5 class="footer-title"><?= htmlspecialchars($sections['quick_links_title']) ?></h5>
        <ul class="list-unstyled small">
          <?php foreach($quick as $q): ?>
            <li><a href="<?= htmlspecialchars($q['url']) ?>" class="text-white text-decoration-none"><?= htmlspecialchars($q['title']) ?></a></li>
          <?php endforeach; ?>
        </ul>
      </div>

      <div class="col-md-3">
        <h5 class="footer-title"><?= htmlspecialchars($sections['resources_title']) ?></h5>
        <ul class="list-unstyled small">
          <?php foreach($res as $r): ?>
            <li><a href="<?= htmlspecialchars($r['url']) ?>" class="text-white text-decoration-none"><?= htmlspecialchars($r['title']) ?></a></li>
          <?php endforeach; ?>
        </ul>
      </div>

      <div class="col-md-3">
        <h5 class="footer-title"><?= htmlspecialchars($sections['social_title']) ?></h5>
        <p class="small"><?= htmlspecialchars($sections['subscribe_text']) ?></p>
        <div class="input-group input-group-sm mb-2">
          <input type="email" class="form-control" placeholder="Enter your email">
          <button class="btn btn-warning">Subscribe</button>
        </div>
        <div class="socials d-flex gap-3 fs-5 mb-3">
          <?php foreach($social as $s): ?>
            <a href="<?= htmlspecialchars($s['url']) ?>" class="text-white" target="_blank"><i class="bi <?= htmlspecialchars($s['icon']) ?>"></i></a>
          <?php endforeach; ?>
        </div>
        <div class="footer-app text-center mt-4">
          <h6 class="text-warning fw-bold mb-2"><?= htmlspecialchars($sections['app_title']) ?></h6>
          <div class="d-flex justify-content-center flex-wrap gap-2">
            <a href="<?= htmlspecialchars($sections['appstore_link']) ?>"><img src="<?= htmlspecialchars($sections['appstore_img']) ?>" style="height:40px;"></a>
            <a href="<?= htmlspecialchars($sections['playstore_link']) ?>"><img src="<?= htmlspecialchars($sections['playstore_img']) ?>" style="height:40px;"></a>
          </div>
        </div>
      </div>
    </div>
    <div class="foot-bottom small text-center pt-4 mt-4">
      <?= htmlspecialchars($sections['footer_quote']) ?>
    </div>
  </div>
 <!-- Thin line separator -->
    <hr class="border-secondary my-2">

<!-- Copyright line with heart outline -->
<div class="small text-center text-white-50 pt-2">
  &copy; 2026 IAOS Regina – Islamic Association of Saskatchewan, Canada. All Rights Reserved &middot; Made with 
  <i class="bi bi-heart" style="color: inherit;"></i> by Horizon Hub Professional Services.
</div>
