<?php
require_once "../db.php"; 
date_default_timezone_set("America/Regina");

$pdoE = get_db();

// ✅ Fetch last 4 events
$stmt = $pdoE->prepare("
    SELECT id, title, subtitle, event_date, image, description, link
    FROM events
    ORDER BY id DESC
");
$stmt->execute();
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ✅ Format each event
foreach ($rows as &$e) {
    if (!empty($e['event_date'])) {

        $ts = strtotime($e['event_date']);

        $e['day_num']   = date("d", $ts);           // 15
        $e['day_txt']   = date("M d, Y", $ts);      // SEP 15, 2025
        $e['month_txt'] = date("F", $ts);           // September
        $e['month_short'] = date("M", $ts);         // SEP
    }
}

header("Content-Type: application/json");
echo json_encode($rows);
