<?php
require_once "admin_pannel/db.php";
$heroSlides = $pdo->query("SELECT * FROM hero_slides ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$posters = $pdo->query("SELECT * FROM posters ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$greeting = $pdo->query("SELECT * FROM greeting_section LIMIT 1")->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Custom CSS -->
  <link rel="stylesheet" href="css/style.css">
  
  <link rel="icon" type="image/png" href="images/fav.png">
  
  <!-- Swiper CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">

	<style>
	.video-overlay {
  position: fixed;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0,0,0,0.85);
  display: none;
  justify-content: center;
  align-items: center;
  z-index: 99999;
}
.video-popup {
  width: 90%;
  max-width: 900px;
  background: #000;
  padding: 10px;
  border-radius: 10px;
  position: relative;
}
.video-popup iframe {
  width: 100%;
  height: 500px;
  border-radius: 10px;
}
.close-video {
  position: absolute;
  top: -10px; right: -10px;
  background: #fff;
  color: #000;
  font-size: 30px;
  width: 40px; height: 40px;
  border-radius: 50%;
  text-align: center;
  line-height: 38px;
  cursor: pointer;
}

/* ✅ FORCE swiper to stay one row (no wrapping) */
.eventSwiperEvents .swiper-wrapper{
  flex-wrap: nowrap !important;
}

/* optional: makes slide height consistent */
.eventSwiperEvents .swiper-slide{
  height: auto;
}

</style>


</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<!-- ================= NAVBAR ================= -->
<?php include 'header.php'; ?>


<!-- ================= HERO ================= -->
<section class="hero position-relative overflow-hidden">
  <div id="heroSlider" class="hero-slider position-absolute inset-0">
  <?php foreach($heroSlides as $i => $h): ?>
  <div class="slide <?= $i==0?'active':'' ?>" style="background-image:url('<?= $h['image'] ?>')">
    <div class="hero-caption">
      <h1><?= htmlspecialchars($h['title']) ?></h1>
      <?php if($h['subtitle']): ?><h2><?= htmlspecialchars($h['subtitle']) ?></h2><?php endif; ?>
      <?php if($h['description']): ?><p><?= $h['description'] ?></p><?php endif; ?>
      <?php if($h['link']): ?><a href="<?= $h['link'] ?>" class="btn btn-learn mt-2">Learn More</a><?php endif; ?>
    </div>
  </div>
  <?php endforeach; ?>
</div>

  <div class="hero-overlay"></div>

  <!-- Prayer Bug -->
<?php
date_default_timezone_set("America/Regina");

/* -----------------------------
   CONNECT TO SALAH TIMES DATABASE
   ----------------------------- */
try {
  // ✅ connect directly to your prayer DB
  $pdoSalah = new PDO("mysql:host=localhost;dbname=iaosr874_new;charset=utf8mb4",
          "iaosr874_newWeb",
          "kkrNvZVT57-ru3~]");
  $pdoSalah->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
  echo "<div style='color:red'>❌ Prayer DB connection failed: " . $e->getMessage() . "</div>";
  return;
}

/* -----------------------------
   FETCH TODAY + TOMORROW ROWS
   ----------------------------- */
$today = date("Y-m-d");
$tomorrow = date("Y-m-d", strtotime("+1 day"));

$stmtToday = $pdoSalah->prepare("SELECT * FROM prayer_times WHERE prayer_date = ?");
$stmtToday->execute([$today]);
$todayRow = $stmtToday->fetch(PDO::FETCH_ASSOC);

$stmtTomorrow = $pdoSalah->prepare("SELECT * FROM prayer_times WHERE prayer_date = ?");
$stmtTomorrow->execute([$tomorrow]);
$tomorrowRow = $stmtTomorrow->fetch(PDO::FETCH_ASSOC);

if (!$todayRow) {
  echo "<div style='color:yellow'>⚠️ No prayer times found for $today in database.</div>";
  return;
}

/* -----------------------------
   HELPER FUNCTIONS
   ----------------------------- */
function ts($date, $time) {
  return $time ? strtotime("$date $time") : null;
}
function fmt12($date, $time) {
  return $time ? date("g:i A", strtotime("$date $time")) : "—";
}

/* -----------------------------
   EXTRACT TODAY’S TIMES
   ----------------------------- */
$fajrB = $todayRow['fajar_begins'] ?? null; $fajrI = $todayRow['fajar'] ?? null;
$sunrise = $todayRow['sunrise'] ?? null;
$zuhrB = $todayRow['zuhar_begins'] ?? null; $zuhrI = $todayRow['zuhar'] ?? null;
$asrB = $todayRow['asar_begins'] ?? null; $asrI = $todayRow['asar'] ?? null;
$magB = $todayRow['magrib_begins'] ?? null;
$ishaB = $todayRow['isha_begins'] ?? null; $ishaI = $todayRow['isha'] ?? null;
$tomFajrB = $tomorrowRow['fajar_begins'] ?? null; $tomFajrI = $tomorrowRow['fajar'] ?? null;
$hijri = $todayRow['hijri'];

$now = time();

/* -----------------------------
   DETERMINE CURRENT SALAH
   ----------------------------- */
$prayerIcon = "namaz-icon.png"; // default
$current = ['name' => '—', 'begin' => null, 'iqama' => null];
if ($fajrB && $sunrise && $now >= ts($today,$fajrB) && $now < ts($today,$sunrise)) {
  $current = ['name'=>'Fajr','begin'=>$fajrB,'iqama'=>$fajrI];
  $prayerIcon = "fajar.png";
} elseif ($zuhrB && $asrB && $now >= ts($today,$zuhrB) && $now < ts($today,$asrB)) {
  $current = ['name'=>'Dhuhr','begin'=>$zuhrB,'iqama'=>$zuhrI];
  $prayerIcon = "zohar.png";
} elseif ($asrB && $magB && $now >= ts($today,$asrB) && $now < ts($today,$magB)) {
  $current = ['name'=>'Asr','begin'=>$asrB,'iqama'=>$asrI];
  $prayerIcon = "asar.png";
} elseif ($magB && $ishaB && $now >= ts($today,$magB) && $now < ts($today,$ishaB)) {
  $current = ['name'=>'Maghrib','begin'=>$magB,'iqama'=>$magB];
  $prayerIcon = "magrib.png";
} elseif ($ishaB && $tomFajrB && $now >= ts($today,$ishaB) && $now < ts($tomorrow,$tomFajrB)) {
  $current = ['name'=>'Isha','begin'=>$ishaB,'iqama'=>$ishaI];
  $prayerIcon = "isha.png";
}

/* -----------------------------
   DETERMINE NEXT SALAH
   ----------------------------- */
$candidates = [
  ['name'=>'Fajr', 'b'=>$fajrB, 'i'=>$fajrI, 'd'=>$today],
  ['name'=>'Dhuhr','b'=>$zuhrB, 'i'=>$zuhrI, 'd'=>$today],
  ['name'=>'Asr',  'b'=>$asrB,  'i'=>$asrI,  'd'=>$today],
  ['name'=>'Maghrib','b'=>$magB,'i'=>$magB,  'd'=>$today],
  ['name'=>'Isha', 'b'=>$ishaB, 'i'=>$ishaI, 'd'=>$today],
  ['name'=>'Fajr (Tomorrow)','b'=>$tomFajrB,'i'=>$tomFajrI,'d'=>$tomorrow]
];
$next = null;
foreach($candidates as $c){
  if(!$c['b']) continue;
  if($now < ts($c['d'],$c['b'])){ $next=$c; break; }
}
if(!$next) $next = end($candidates);

/* -----------------------------
   COUNTDOWN TARGET (NEXT IQAMA)
   ----------------------------- */
$targetTs = ts($next['d'], $next['i'] ?: $next['b']);
?>

<div id="namazBug" class="namaz-bug position-absolute top-0 end-0">
  <div class="d-flex align-items-center namaz-bg shadow-lg border border-success rounded-3 overflow-hidden">
    <div class="p-3 d-flex align-items-center justify-content-center">
      <img src="images/<?= htmlspecialchars($prayerIcon) ?>" alt="Prayer Icon" class="namaz-img">
    </div>
    <div class="p-3 pe-4">
      <div class="next-prayer-label">Current Prayer:</div>
      <div class="next-prayer-name text-danger"><?= htmlspecialchars($current['name']) ?></div>
      <div class="next-prayer-label">IQAMA: <?= fmt12($today,$current['iqama']) ?></div>

      <div class="timer d-flex gap-2 mt-2" id="countdown">
        <div class="time-box"><span>--</span><small>HRS</small></div>
        <div class="time-box"><span>--</span><small>MIN</small></div>
        <div class="time-box"><span>--</span><small>SEC</small></div>
      </div>

      <div class="next-prayer-label mb-1">Next Prayer:</div>
      <div class="next-prayer-name"><?= htmlspecialchars($next['name']) ?></div>
      <div class="next-prayer-label">IQAMA: <?= fmt12($next['d'],$next['i']) ?></div>
      <div class="next-prayer-label"><?= htmlspecialchars($hijri) ?></div>
    </div>
    
  </div>
</div>

  <!-- Golden line divider -->
  <div class="golden-divider"></div>
</section>

	<!-- Blinking Live Text -->
	<?php
	$banner = $pdo->query("SELECT * FROM live_banner WHERE id=1")->fetch();
	?>

	<?php if ($banner['is_active']): ?>
	  <div class="live-blink">
		<span class="live-blink-circle">🔴</span>
		<?php if ($banner['url']): ?>
		  <a href="<?= $banner['url'] ?>" target="_blank"><?= htmlspecialchars($banner['text']) ?></a>
		<?php else: ?>
		  <?= htmlspecialchars($banner['text']) ?>
		<?php endif; ?>
	  </div>
	<?php endif; ?>

	<!-- Scrolling Text Bar -->
	<div class="scrolling-text">
	  <div class="scrolling-content">
		<?php 
		  $scrollNews = $pdo->query("SELECT * FROM scrolling_news ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
		  $texts = [];
		  foreach($scrollNews as $n){ $texts[] = htmlspecialchars($n['message']); }
		  echo implode('  |  ', $texts) . '  |  ' . implode('  |  ', $texts);
		?>
	  </div>
	</div>

<!-- Placeholder for Namaz Bug on mobile -->
<div id="mobileNamazPlaceholder"></div>


<!-- ================= PRAYER / JUMMAH / HALAAQAH / EVENTS ================= -->
<section class="tables-area py-4" style="background-color:#0f5149;">
  <div class="container-xl">
    <div class="row g-3">
      <!-- Column 1 -->
      <div class="col-md-3">
		<div class="info-card">
			<div class="info-head py-2">CONGREGATIONAL<br>PRAYERS</div>

			<table class="table table-borderless table-striped table-sm align-middle mt-2">
				<thead>
				<tr>
					<th class="table-Heading">SALAH</th>
					<th class="text-end table-Heading">START TIME</th>
					<th class="text-end table-Heading">JAMAH TIME</th>
				</tr>
				</thead>
				<tbody>

				<tr>
					<td>FAJR</td>
					<td id="fajr_start" class="text-end">--</td>
					<td id="fajr_jamah" class="text-end">--</td>
				</tr>

				<tr>
					<td>DHUHR</td>
					<td id="dhuhr_start" class="text-end">--</td>
					<td id="dhuhr_jamah" class="text-end">--</td>
				</tr>

				<tr>
					<td>ASR</td>
					<td id="asr_start" class="text-end">--</td>
					<td id="asr_jamah" class="text-end">--</td>
				</tr>

				<tr>
					<td>MAGHRIB</td>
					<td id="maghrib_start" class="text-end">--</td>
					<td id="maghrib_jamah" class="text-end">--</td>
				</tr>

				<tr>
					<td>ISHA</td>
					<td id="isha_start" class="text-end">--</td>
					<td id="isha_jamah" class="text-end">--</td>
				</tr>

				<!-- ✅ Jummah from current week -->
				<tr class="sep">
					<td>JUMMA 1</td>
					<td id="jummah1_time" class="text-end">—</td>
					<td class="text-end">—</td>
				</tr>

				<tr>
					<td>JUMMA 2</td>
					<td id="jummah2_time" class="text-end">—</td>
					<td class="text-end">—</td>
				</tr>

				</tbody>
			</table>

		</div>
	</div>
      <!-- Column 2 -->
		<?php
		$jummah = $pdo->query("SELECT * FROM jummah_mosques ORDER BY id ASC")->fetchAll();
		$total = count($jummah);
		$perPage = 7;
		?>

		<div class="col-md-3">
  <div class="info-card">
    <div class="info-head py-2">JUMMAH PRAYERS<br>TIMES BY MOSQUE</div>

    <table class="table table-borderless table-striped table-sm align-middle mt-2" id="jummahTable">
      <thead>
        <tr><th class="table-Heading">MOSQUE</th><th class="text-end table-Heading">JAMAH TIME</th></tr>
      </thead>
      <tbody id="jummahBody">
      </tbody>
    </table>

    <!-- ✅ SHOW PAGINATION ONLY IF MORE THAN 7 -->
    <?php if($total > $perPage): ?>
      <div class="d-flex justify-content-between mt-2">
        <button class="btn btn-sm btn-primary" id="prevBtn" disabled>Previous</button>
        <button class="btn btn-sm btn-primary" id="nextBtn">Next</button>
      </div>
    <?php endif; ?>

  </div>
</div>
      <!-- Column 3 -->
      <?php
		$halaqah = $pdo->query("SELECT * FROM halaqah_times ORDER BY id ASC")->fetchAll();
		?>

		<div class="col-md-3">
		  <div class="info-card">
			<div class="info-head py-2">HALAAQAH<br>TIMES</div>

			<table class="table table-borderless table-striped table-sm align-middle mt-2">
			  <thead>
				<tr>
				  <th class="table-Heading">SESSION</th>
				  <th class="text-end table-Heading">TIME</th>
				</tr>
			  </thead>
			  <tbody>
				<?php foreach($halaqah as $h): ?>
				  <tr>
					<td><?= htmlspecialchars($h['session_name']) ?></td>
					<td class="text-end"><?= htmlspecialchars($h['time_text']) ?></td>
				  </tr>
				<?php endforeach; ?>
			  </tbody>
			</table>

		  </div>
		</div>
      <!-- Column 4 -->
     <?php
// ✅ safely load JSON from get_events.php in same folder
ob_start();
include __DIR__ . "/get_events.php";
$eventsJson = ob_get_clean();

$events = json_decode($eventsJson, true);

// ✅ ensure array
if (!is_array($events)) {
    $events = [];
}
?>

<div class="col-md-3">
  <div class="info-card">

    <div class="info-head py-2">EVENTS<br>LOCATIONS / TIMES</div>

    <table class="table table-borderless table-striped table-sm align-middle mt-2">
      <thead>
        <tr><th class="table-Heading">DATE / TIME</th></tr>
      </thead>
    </table>

    <?php if (empty($events)): ?>
      <p class="text-muted ms-2 mb-2">No events available.</p>
    <?php endif; ?>

    <!-- ✅ ALL EVENTS ARE HERE (but JS will show only 4 per page) -->
    <div id="eventsContainer">
      <?php foreach($events as $e): ?>

        <!-- ✅ IMPORTANT: wrapper eventRow MUST exist for every event -->
        <div class="eventRow">
          <?php if (!empty($e['link'])): ?>
            <a href="<?= htmlspecialchars($e['link']) ?>" class="text-decoration-none text-dark">
              <div class="event-item d-flex align-items-start mb-2 p-2 rounded" style="cursor:pointer;">
                <div class="date-box"><?= htmlspecialchars($e['day_num']) ?></div>
                <div class="ms-2">
                  <div class="event-title text-white"><?= htmlspecialchars($e['title']) ?></div>
                  <small class="event-title text-white"><?= htmlspecialchars($e['day_txt']) ?></small>
                </div>
              </div>
            </a>
          <?php else: ?>
            <div class="event-item d-flex align-items-start mb-2 p-2 rounded">
              <div class="date-box"><?= htmlspecialchars($e['day_num']) ?></div>
              <div class="ms-2">
                <div class="event-title text-white"><?= htmlspecialchars($e['title']) ?></div>
                <small class="event-title text-white"><?= htmlspecialchars($e['day_txt']) ?></small>
              </div>
            </div>
          <?php endif; ?>
        </div>

      <?php endforeach; ?>
    </div>
    
    <!-- ✅ KEEP YOUR BUTTONS -->
    <div class="d-flex justify-content-between mt-2" id="eventsPager">
      <button class="btn btn-sm btn-primary" id="prevBtnE" disabled>Previous</button>
      <button class="btn btn-sm btn-primary" id="nextBtnE">Next</button>
    </div>

  </div>
</div>
	  
	  
    </div>
  </div>
</section>

<!-- ================= ASSALAMU ALAYKUM ================= -->
<section class="greeting text-center">
  <div class="container-xl">
    <h4 class="greet-title"><?= htmlspecialchars($greeting['title']) ?></h4>
    <p class="greet-sub"><?= htmlspecialchars($greeting['subtitle']) ?></p>
    <p class="greet-desc"><?= $greeting['description'] ?></p>
    <a href="<?= $greeting['button_link'] ?>" class="btn btn-learn"><?= htmlspecialchars($greeting['button_text']) ?></a>
  </div>
</section>

<!-- ================= POSTERS SECTION ================= -->
<section class="posters py-5">
  <div class="container-sm">
    <div class="row g-4">
      <!-- LEFT Poster -->
      <div class="col-md-12">
        <div class="poster-box">
    <?php foreach($posters as $p): ?>
      <a href="<?= $p['link'] ?: '#' ?>" target="_blank">
        <img src="<?= $p['image'] ?>" class="poster-img <?= $p === reset($posters) ? 'active' : '' ?>" alt="Poster">
      </a>
    <?php endforeach; ?>
  </div>

  <!-- Dots -->
  <div class="slider-dots d-flex justify-content-center gap-2 mt-4">
    <?php foreach($posters as $index => $p): ?>
      <span class="dot <?= $index==0?'active':'' ?>" data-slide="<?= $index ?>"></span>
    <?php endforeach; ?>
  </div>
</div>
	  
	  
    </div>
  </div>
</section>

<!-- ================= OUR SERVICES ================= -->
<?php
// ✅ Load services JSON from get_services.php
ob_start();
include "get_services.php";
$servicesJson = ob_get_clean();

$services = json_decode($servicesJson, true);
if (!is_array($services)) $services = [];

// ✅ First 4 items → First row
$firstRow = array_slice($services, 0, 4);

// ✅ Remaining items → Second row
$secondRow = array_slice($services, 4);
?>

<?php
ob_start();
include "get_services_heading.php";
$headingJson = ob_get_clean();
$headingData = json_decode($headingJson, true);
$serviceHeading = $headingData['heading_text'] ?? "OUR SERVICES";
?>

<!-- ================= OUR SERVICES ================= -->
<section class="greeting text-center">
  <div class="container-xl">
    <h4 class="greet-title"><?= htmlspecialchars($serviceHeading) ?></h4>
  </div>
</section>

<!-- ================= SERVICES IMAGE GRID ================= -->
<section class="services-gallery text-center py-5">
  <div class="container-xl">

    <!-- ✅ FIRST ROW (4 ITEMS) -->
    <div class="row g-3">
      <?php foreach ($firstRow as $s): ?>
        <div class="<?= htmlspecialchars($s['layout']) ?>">
          <div class="service-box">
            <img src="<?= htmlspecialchars($s['image']) ?>" 
                 class="service-img rounded-2 shadow-sm" 
                 alt="<?= htmlspecialchars($s['title']) ?>">
            
            <div class="overlay">
              <h4 class="text-white text-center">
                <?= htmlspecialchars($s['title']) ?>
              </h4>
            </div>

            <div class="overlay-content">
              <h4><?= htmlspecialchars($s['title']) ?></h4>
              <p><?= htmlspecialchars($s['description']) ?></p>
              <?php if (!empty($s['link'])): ?>
                <a href="<?= htmlspecialchars($s['link']) ?>" class="btn-learn">Learn More</a>
              <?php endif; ?>
            </div>

          </div>
        </div>
      <?php endforeach; ?>
    </div>

    <!-- ✅ SECOND ROW (1 BIG LEFT + 2 SMALL RIGHT) -->
    <?php if (!empty($secondRow)): ?>
    <div class="row g-3 mt-3">

      <!-- ✅ LEFT BIG BOX (col-md-8) -->
      <div class="col-md-8">
        <?php $big = $secondRow[0]; ?>
        <div class="service-box py-2">
          <img src="<?= htmlspecialchars($big['image']) ?>" 
               class="service-img rounded-2 shadow-sm" 
               alt="<?= htmlspecialchars($big['title']) ?>">

          <div class="overlay">
            <h4 class="text-white text-center"><?= htmlspecialchars($big['title']) ?></h4>
          </div>

          <div class="overlay-content">
            <h4><?= htmlspecialchars($big['title']) ?></h4>
            <p><?= htmlspecialchars($big['description']) ?></p>
            <?php if (!empty($big['link'])): ?>
              <a href="<?= htmlspecialchars($big['link']) ?>" class="btn-learn">Learn More</a>
            <?php endif; ?>
          </div>
        </div>
      </div>

      <!-- ✅ RIGHT SIDE (2 SMALL BOXES STACKED) -->
      <div class="col-md-4">
        <?php foreach (array_slice($secondRow, 1) as $s): ?>
          <div class="service-box py-2 mb-3">
            <img src="<?= htmlspecialchars($s['image']) ?>" 
                 class="service-img rounded-2 shadow-sm" 
                 alt="<?= htmlspecialchars($s['title']) ?>">

            <div class="overlay">
              <h4 class="text-white text-center"><?= htmlspecialchars($s['title']) ?></h4>
            </div>

            <div class="overlay-content">
              <h4><?= htmlspecialchars($s['title']) ?></h4>
              <p><?= htmlspecialchars($s['description']) ?></p>
              <?php if (!empty($s['link'])): ?>
                <a href="<?= htmlspecialchars($s['link']) ?>" class="btn-learn">Learn More</a>
              <?php endif; ?>
            </div>
          </div>
        <?php endforeach; ?>
      </div>

    </div>
    <?php endif; ?>

  </div>
</section>


<!-- ================= UPCOMING EVENTS ================= -->
<section class="greeting text-center">
  <div class="container-xl">
    <h4 class="greet-title" id="eventsHeading">Loading...</h4>
  </div>
</section>

<!-- ================= EVENT GALLERY ================= -->
<?php
ob_start();
include __DIR__ . "/get_events.php";
$eventsJson = ob_get_clean();

$events = json_decode($eventsJson, true);
if(!is_array($events)) $events = [];

$eventsCount = count($events);
?>

<section class="event-gallery text-center py-5">
  <div class="container-xl">

    <div class="swiper eventSwiperEvents">
  <div class="swiper-wrapper">

    <?php foreach($events as $e): ?>
    <div class="swiper-slide">
      <div class="event-box">

        <!-- IMAGE -->
        <img src="../<?= htmlspecialchars($e['image']) ?>" 
             class="event-img rounded-2 shadow-sm" 
             alt="<?= htmlspecialchars($e['title']) ?>">

        <!-- OVERLAY -->
        <div class="overlay">
          <h4 class="text-white text-center">
            <?= htmlspecialchars($e['day_num']) ?>
            <?= htmlspecialchars($e['month_txt']) ?>
            <br>
            <?= htmlspecialchars($e['title']) ?>
          </h4>
        </div>

        <!-- FULL OVERLAY CONTENT -->
        <div class="overlay-content">
          <h3>
            <?= htmlspecialchars($e['day_num']) ?>
            <?= htmlspecialchars($e['month_txt']) ?>
          </h3>

          <h4><?= htmlspecialchars($e['title']) ?></h4>

          <p><?= htmlspecialchars($e['description']) ?></p>

          <?php if(!empty($e['link'])): ?>
            <a href="<?= htmlspecialchars($e['link']) ?>" class="btn-learn" target="_blank">
              Learn More
            </a>
          <?php endif; ?>
        </div>

      </div>
    </div>
    <?php endforeach; ?>

  </div>

  <!-- ✅ Arrows ONLY if more than 4 events -->
  <?php if($eventsCount > 4): ?>
    <div class="swiper-button-prev eventPrev"></div>
    <div class="swiper-button-next eventNext"></div>
  <?php endif; ?>

  <!-- Pagination (only visible on mobile) -->
  <div class="swiper-pagination eventDots"></div>
</div>

  </div>
</section>

<!-- ================= Youtube Videos ================= -->
<section class="greeting text-center">
  <div class="container-xl">
    <h4 class="greet-title">SOCIAL MEDIA</h4>
  </div>
</section>

<?php
$videos = $pdo->query("SELECT * FROM iaos_videos ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<section class="event-gallery text-center py-5">
  <div class="container-xl">

    <div class="swiper eventSwiper">
      <div class="swiper-wrapper">

        <?php foreach($videos as $v): ?>
        <div class="swiper-slide">
          <div class="event-box">

            <!-- ✅ THUMBNAIL -->
            <img src="<?= htmlspecialchars($v['thumbnail']) ?>" 
                 class="event-img rounded-2 shadow-sm" 
                 alt="<?= htmlspecialchars($v['title']) ?>">

            <!-- ✅ TITLE OVERLAY -->
            <div class="overlay">
              <h4 class="text-white text-center">
                <?= htmlspecialchars($v['title']) ?>
              </h4>
            </div>

            <!-- ✅ HOVER CONTENT -->
            <div class="overlay-content">
              <h3><?= htmlspecialchars($v['title']) ?></h3>

              <button class="btn-learn play-video"
                      data-video="<?= htmlspecialchars($v['youtube_url']) ?>">
                Watch Video
              </button>
            </div>

          </div>
        </div>
        <?php endforeach; ?>

      </div>

      <div class="swiper-pagination"></div>
    </div>

  </div>
</section>

<!-- ================= CONTACT FORM SECTION ================= -->

<?php
ob_start();
include "get_contact_heading.php";
$contactJson = ob_get_clean();
$contact = json_decode($contactJson, true);

$headingC = $contact['heading_text'] ?? "Contact Us";
$subC =     $contact['sub_text'] ?? "We’d love to hear from you.";
?>


<section class="contact-section py-5 bg-light">
  <div class="container-xl">
    <div class="text-center mb-5">
      <h2 class="greet-title"><?= htmlspecialchars($headingC) ?></h2>
		<p class="text-muted"><?= htmlspecialchars($subC) ?></p>
    </div>

    <div class="row justify-content-center">
      <div class="col-md-8">
        <form class="contact-form p-4 rounded-3 shadow-sm bg-white" action="contact-submit.php" method="POST">
          <div class="row g-3">
            
            <!-- First Name -->
            <div class="col-md-6">
              <label for="firstName" class="form-label fw-semibold">First Name</label>
              <input type="text" class="form-control" id="firstName" name="firstName" placeholder="Enter your first name" required>
            </div>

            <!-- Last Name -->
            <div class="col-md-6">
              <label for="lastName" class="form-label fw-semibold">Last Name</label>
              <input type="text" class="form-control" id="lastName" name="lastName" placeholder="Enter your last name" required>
            </div>

            <!-- Email -->
            <div class="col-md-6">
              <label for="email" class="form-label fw-semibold">Email</label>
              <input type="email" class="form-control" id="email" name="email" placeholder="Enter your email" required>
            </div>

            <!-- Phone -->
            <div class="col-md-6">
              <label for="phone" class="form-label fw-semibold">Phone Number</label>
              <input type="tel" class="form-control" id="phone" name="phone" placeholder="Enter your phone number">
            </div>

            <!-- Category -->
            <div class="col-md-6">
              <label for="category" class="form-label fw-semibold">Category</label>
              <select id="category" name="category" class="form-select" required>
                <option selected disabled value="">Choose...</option>
                <option>General Inquiry</option>
                <option>Imam Inquiry</option>
                <option>Complaint</option>
                <option>Opinion</option>
                <option>Compliment</option>
              </select>
            </div>

            <!-- Subject -->
            <div class="col-md-6">
              <label for="subject" class="form-label fw-semibold">Subject</label>
              <input type="text" class="form-control" id="subject" name="subject" placeholder="Enter subject" required>
            </div>

            <!-- Message -->
            <div class="col-12">
              <label for="message" class="form-label fw-semibold">Message</label>
              <textarea id="message" name="message" class="form-control" rows="5" placeholder="Write your message here..." required></textarea>
            </div>

            <!-- Submit Button -->
            <div class="col-12 text-center mt-3">
              <button type="submit" class="btn btn-success px-4 py-2 rounded-pill">
                <i class="bi bi-send me-2"></i> Send Message
              </button>
            </div>

          </div>
        </form>
      </div>
    </div>
  </div>
</section>


<!-- ================= FOOTER ================= -->
<?php include 'footer.php'; ?>

<div id="footer">

</div>

<!-- ✅ YOUTUBE POPUP PLAYER -->
<div class="modal fade" id="videoModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content bg-dark">

      <div class="modal-header border-0">
        <h5 class="modal-title text-white">Video Player</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body p-0">
        <iframe id="videoPlayer"
                width="100%" height="420"
                src=""
                frameborder="0"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                allowfullscreen>
        </iframe>
      </div>

    </div>
  </div>
</div>



<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>

      <div class="modal-footer">
        <small class="text-muted">All times are approximate and based on Regina local time.</small>
      </div>
    </div>
  </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="js/main.js"></script>

<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<script>
  const slides = document.querySelectorAll('#heroSlider .slide');
  let current = 0;

  setInterval(() => {
    slides[current].classList.remove('active');
    current = (current + 1) % slides.length;
    slides[current].classList.add('active');
  }, 5000); // change every 5 seconds
</script>



<script>
document.addEventListener("DOMContentLoaded", () => {
  const posterBoxes = document.querySelectorAll(".poster-box");

  posterBoxes.forEach(box => {
    const images = box.querySelectorAll(".poster-img");
    let index = 0;

    setInterval(() => {
      images[index].classList.remove("active");
      index = (index + 1) % images.length;
      images[index].classList.add("active");
    }, 5000); // every 5 seconds
  });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {
  let eventSwiper = null;

  function initEventSwiper() {
    const isMobile = window.innerWidth <= 992;
    const swiperContainer = document.querySelector('.eventSwiper');

    if (isMobile && !eventSwiper) {
      eventSwiper = new Swiper('.eventSwiper', {
        slidesPerView: 1,
        spaceBetween: 20,
        pagination: {
          el: '.swiper-pagination',
          clickable: true,
        },
        autoplay: {
          delay: 4000,
          disableOnInteraction: false,
        },
      });
    } else if (!isMobile && eventSwiper) {
      eventSwiper.destroy(true, true);
      eventSwiper = null;
    }
  }

  initEventSwiper();
  window.addEventListener('resize', initEventSwiper);
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
  let serviceSwiper = null;
  const section = document.querySelector(".services-gallery .container-xl");

  function toggleServiceSlider() {
    const isMobile = window.innerWidth <= 992;

    if (isMobile && !serviceSwiper) {
      // Collect all service boxes
      const serviceBoxes = section.querySelectorAll(".service-box");

      // Create swiper structure
      const swiperContainer = document.createElement("div");
      swiperContainer.classList.add("swiper", "serviceSwiper");

      const swiperWrapper = document.createElement("div");
      swiperWrapper.classList.add("swiper-wrapper");

      serviceBoxes.forEach(box => {
        const slide = document.createElement("div");
        slide.classList.add("swiper-slide");
        slide.appendChild(box);
        swiperWrapper.appendChild(slide);
      });

      swiperContainer.appendChild(swiperWrapper);

      const pagination = document.createElement("div");
      pagination.classList.add("swiper-pagination");
      swiperContainer.appendChild(pagination);

      // Clear section and insert swiper
      section.innerHTML = "";
      section.appendChild(swiperContainer);

      // Initialize Swiper
      serviceSwiper = new Swiper(".serviceSwiper", {
        slidesPerView: 1,
        spaceBetween: 15,
        loop: true,
        autoplay: {
          delay: 4000,
          disableOnInteraction: false,
        },
        pagination: {
          el: ".swiper-pagination",
          clickable: true,
        },
      });
    }

    // Destroy on desktop
    if (!isMobile && serviceSwiper) {
      serviceSwiper.destroy(true, true);
      serviceSwiper = null;
      window.location.reload(); // reload restores your full desktop grid instantly
    }
  }

  toggleServiceSlider();
  window.addEventListener("resize", toggleServiceSlider);
});
</script>


<script>
document.addEventListener("DOMContentLoaded", function() {
  const namazBug = document.getElementById("namazBug");
  const heroSection = document.querySelector(".hero");
  const mobilePlaceholder = document.getElementById("mobileNamazPlaceholder");

  function relocateNamazBug() {
    const isMobile = window.innerWidth <= 992;

    if (isMobile && heroSection.contains(namazBug)) {
      // Move it below the banner
      mobilePlaceholder.appendChild(namazBug);
      namazBug.classList.remove("position-absolute", "top-0", "end-0");
    } 
    else if (!isMobile && mobilePlaceholder.contains(namazBug)) {
      // Move it back into banner
      heroSection.appendChild(namazBug);
      namazBug.classList.add("position-absolute", "top-0", "end-0");
    }
  }

  relocateNamazBug();
  window.addEventListener("resize", relocateNamazBug);
});
</script>


<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');

window.addEventListener('scroll', () => {
  if (window.scrollY > lastScrollY) {
    donateBtn.style.opacity = '0';
  } else {
    donateBtn.style.opacity = '1';
  }
  lastScrollY = window.scrollY;
});
</script>

<script>
document.addEventListener("DOMContentLoaded", () => {
  const posters = document.querySelectorAll(".poster-img");
  const dots = document.querySelectorAll(".dot");
  let current = 0;

  function showPoster(index) {
    posters.forEach(p => p.classList.remove("active"));
    dots.forEach(d => d.classList.remove("active"));
    posters[index].classList.add("active");
    dots[index].classList.add("active");
  }

  dots.forEach(dot => {
    dot.addEventListener("click", () => {
      current = parseInt(dot.getAttribute("data-slide"));
      showPoster(current);
    });
  });

  // Optional auto-slide every 5s
  setInterval(() => {
    current = (current + 1) % posters.length;
    showPoster(current);
  }, 5000);
});
</script>

<script>
const currentIqamaTs = <?= $current['iqama'] ? ts($today,$current['iqama'])*1000 : 'null' ?>;
const nextIqamaTs    = <?= $next['i'] ? ts($next['d'],$next['i'])*1000 : 'null' ?>;
const currentName    = "<?= $current['name'] ?>";
const nextName       = "<?= $next['name'] ?>";

let stage = "current"; // start with current salah
let targetTime = currentIqamaTs || nextIqamaTs;
let countdownEl = document.getElementById("countdown");

const fmt = (n) => String(n).padStart(2, '0');

function updateCountdown() {
  const now = Date.now();

  // 1️⃣ switch to next salah after current iqama passes
  if (stage === "current" && currentIqamaTs && now >= currentIqamaTs && nextIqamaTs) {
    stage = "next";
    targetTime = nextIqamaTs;

    // Move countdown under “Next Prayer”
    const nextSection = document.querySelector(".next-prayer-label.mb-1");
    if (nextSection) nextSection.insertAdjacentElement("afterend", countdownEl);

    // Highlight next salah name
    document.querySelector(".next-prayer-name.text-danger")?.classList.remove("text-danger");
    nextSection?.nextElementSibling?.classList.add("text-danger");
  }

  // 2️⃣ if no valid target time
  if (!targetTime) {
    countdownEl.innerHTML = `<b class="text-muted">No Iqama set</b>`;
    return;
  }

  // 3️⃣ calculate remaining time
  const diff = targetTime - now;
  if (diff <= 0) {
    countdownEl.innerHTML = `<b class="text-danger">It's time!</b>`;
    return;
  }

  const h = Math.floor(diff / (1000 * 60 * 60));
  const m = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
  const s = Math.floor((diff % (1000 * 60)) / 1000);

  const label = stage === "current" ? currentName : nextName;

  countdownEl.innerHTML = `
    
    <div class="time-box"><span>${fmt(h)}</span><small>HRS</small></div>
    <div class="time-box"><span>${fmt(m)}</span><small>MIN</small></div>
    <div class="time-box"><span>${fmt(s)}</span><small>SEC</small></div>
  `;
}

// Run every second
setInterval(updateCountdown, 1000);
updateCountdown();
</script>

<style>
/* Optional blinking when <5 mins */
@keyframes blink {
  0% { opacity: 1 }
  50% { opacity: 0.2 }
  100% { opacity: 1 }
}
#countdown.blink { animation: blink 1s infinite; }
</style>


<script>
// 🌙 Toggle between weekly and monthly view
document.getElementById("btnWeek").addEventListener("click", () => {
  document.getElementById("weeklyView").classList.remove("d-none");
  document.getElementById("monthlyView").classList.add("d-none");
  document.getElementById("btnWeek").classList.add("active");
  document.getElementById("btnMonth").classList.remove("active");
});
document.getElementById("btnMonth").addEventListener("click", () => {
  document.getElementById("weeklyView").classList.add("d-none");
  document.getElementById("monthlyView").classList.remove("d-none");
  document.getElementById("btnMonth").classList.add("active");
  document.getElementById("btnWeek").classList.remove("active");
});


// 🔄 Load initial data when modal opens
const prayerModal = document.getElementById("prayerModal");
prayerModal.addEventListener("show.bs.modal", () => loadPrayerData());

// 🔁 Reload data when month changes
document.getElementById("monthSelect").addEventListener("change", (e) => {
  const selected = e.target.value;
  loadPrayerData(selected);
});
</script>

<style>
.table-warning.fw-bold {
  background-color: #ffeeba !important;
  color: #0f5132 !important;
  font-weight: bold;
}
</style>

<script>
async function loadCongregationalBox() {
    try {
        const res = await fetch("get_today_prayer.php");
        const data = await res.json();

        if (!data.today) return;

        const t = data.today;
        const j = data.jummah || {};

        // Replace UI
        document.getElementById("fajr_start").textContent = t.fajar_begins;
        document.getElementById("fajr_jamah").textContent = t.fajar;

        document.getElementById("dhuhr_start").textContent = t.zuhar_begins;
        document.getElementById("dhuhr_jamah").textContent = t.zuhar;

        document.getElementById("asr_start").textContent = t.asar_begins;
        document.getElementById("asr_jamah").textContent = t.asar;

        document.getElementById("maghrib_start").textContent = t.magrib_begins;
        document.getElementById("maghrib_jamah").textContent = t.magrib_begins;

        document.getElementById("isha_start").textContent = t.isha_begins;
        document.getElementById("isha_jamah").textContent = t.isha;

        // ✅ Jummah only if available this week
        document.getElementById("jummah1_time").textContent = j.jumah1 || "—";
        document.getElementById("jummah2_time").textContent = j.jumah2 || "—";

    } catch (e) {
        console.error(e);
    }
}

loadCongregationalBox();
</script>

<script>
const data = <?= json_encode($jummah) ?>;
const perPage = 7;
let page = 0;

function renderTable(){
    const start = page * perPage;
    const end = start + perPage;
    const rows = data.slice(start, end);

    let html = "";
    rows.forEach(m => {
        html += `
          <tr>
            <td>
              ${m.map_url 
                ? `<a href="${m.map_url}" target="_blank">${m.mosque_name}</a>` 
                : m.mosque_name
              }
            </td>
            <td class="text-end">${m.jummah_time}</td>
          </tr>
        `;
    });

    document.getElementById("jummahBody").innerHTML = html;

    // Enable/disable buttons
    document.getElementById("prevBtn").disabled = (page === 0);
    document.getElementById("nextBtn").disabled = ((page + 1) * perPage >= data.length);
}

// ✅ Buttons
document.getElementById("prevBtn")?.addEventListener("click", () => {
    if(page > 0){ page--; renderTable(); }
});

document.getElementById("nextBtn")?.addEventListener("click", () => {
    if((page + 1) * perPage < data.length){ page++; renderTable(); }
});

// ✅ Initial load
renderTable();
</script>

<script>
fetch("get_events_heading.php")
  .then(res => res.json())
  .then(data => {
      document.getElementById("eventsHeading").innerText = data.heading_text;
  });
</script>


<script>
document.querySelectorAll(".play-video").forEach(btn => {
  btn.addEventListener("click", function () {

    let url = this.dataset.video.trim();

    // ✅ Convert all types of YouTube URLs to EMBED version
    let videoId = "";

    // 1) Standard watch link
    if (url.includes("watch?v=")) {
      videoId = url.split("watch?v=")[1].split("&")[0];
    }

    // 2) Short youtu.be link
    else if (url.includes("youtu.be/")) {
      videoId = url.split("youtu.be/")[1].split("?")[0];
    }

    // 3) Already embed link
    else if (url.includes("embed/")) {
      videoId = url.split("embed/")[1].split("?")[0];
    }

    // ✅ Final embed URL
    let embedUrl = "https://www.youtube.com/embed/" + videoId + "?autoplay=1";

    // ✅ Load into iframe
    document.getElementById("videoPlayer").src = embedUrl;

    // ✅ Show modal
    const modal = new bootstrap.Modal(document.getElementById('videoModal'));
    modal.show();
  });
});

// ✅ Stop video when modal closes
document.getElementById("videoModal").addEventListener("hidden.bs.modal", function () {
  document.getElementById("videoPlayer").src = "";
});
</script>


<script>
document.addEventListener("DOMContentLoaded", function () {
  const perPage = 4;
  let page = 0;

  const rows = Array.from(document.querySelectorAll("#eventsContainer .eventRow"));
  const prevBtn = document.getElementById("prevBtnE");
  const nextBtn = document.getElementById("nextBtnE");
  const pager   = document.getElementById("eventsPager");

  // Safety
  if (!prevBtn || !nextBtn || !pager) return;

  // No events
  if (rows.length === 0) {
    pager.style.display = "none";
    return;
  }

  const totalPages = Math.ceil(rows.length / perPage);

  // If 4 or less, show all, hide buttons
  if (rows.length <= perPage) {
    pager.style.display = "none";
    rows.forEach(r => r.style.display = "");
    return;
  }

  function render() {
    const start = page * perPage;
    const end   = start + perPage;

    rows.forEach((row, i) => {
      row.style.display = (i >= start && i < end) ? "" : "none";
    });

    prevBtn.disabled = (page === 0);
    nextBtn.disabled = (page >= totalPages - 1);
  }

  prevBtn.addEventListener("click", function (e) {
    e.preventDefault();
    if (page > 0) {
      page--;
      render();
    }
  });

  nextBtn.addEventListener("click", function (e) {
    e.preventDefault();
    if (page < totalPages - 1) {
      page++;
      render();
    }
  });

  render(); // first page
});
</script>


<script>
document.addEventListener('DOMContentLoaded', function () {

  const eventsEl = document.querySelector('.eventSwiperEvents');

  if (eventsEl) {
    let eventsSwiper = null;

    function initEventsSwiper() {
      const eventsCount = eventsEl.querySelectorAll('.swiper-slide').length;

      if (eventsSwiper) {
        eventsSwiper.destroy(true, true);
        eventsSwiper = null;
      }

      eventsSwiper = new Swiper(eventsEl, {
        spaceBetween: 20,
        loop: false,
        watchOverflow: true, // ✅ if slides are less, swiper won't "act weird"

        breakpoints: {
          0: {
            slidesPerView: 1,
            slidesPerGroup: 1,
            autoplay: {
              delay: 4000,
              disableOnInteraction: false,
            },
          },
          993: {
            slidesPerView: Math.min(4, eventsCount),   // ✅ if you have 3 events, show 3
            slidesPerGroup: Math.min(4, eventsCount),  // ✅ group matches count
            autoplay: false,
          }
        },

        navigation: {
          nextEl: eventsEl.querySelector('.eventNext'),
          prevEl: eventsEl.querySelector('.eventPrev'),
        },

        pagination: {
          el: eventsEl.querySelector('.eventDots'),
          clickable: true,
        },
      });
    }

    initEventsSwiper();
    window.addEventListener('resize', initEventsSwiper);
  }

  // ✅ your YOUTUBE swiper stays same
  let videoSwiper = null;

  function initVideoSwiper() {
    const isMobile = window.innerWidth <= 992;

    const swipers = document.querySelectorAll('.eventSwiper');
    const videoEl = swipers.length > 1 ? swipers[1] : swipers[0];
    if (!videoEl) return;

    if (isMobile && !videoSwiper) {
      videoSwiper = new Swiper(videoEl, {
        slidesPerView: 1,
        spaceBetween: 20,
        pagination: {
          el: videoEl.querySelector('.swiper-pagination'),
          clickable: true,
        },
        autoplay: {
          delay: 4000,
          disableOnInteraction: false,
        },
      });
    } else if (!isMobile && videoSwiper) {
      videoSwiper.destroy(true, true);
      videoSwiper = null;
    }
  }

  initVideoSwiper();
  window.addEventListener('resize', initVideoSwiper);

});
</script>


<!-- Fixed Donate Button (Mobile Only) -->
<a href="#donate" class="mobile-donate-btn">Donate Now</a>

</body>
</html>
