<?php
ob_start();
session_start();
require_once "admin_pannel/db.php"; // ✅ must provide $pdo
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Membership Benefits | IAOS Regina</title>

  <!-- Bootstrap & Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">

  <style>
    body { font-family: 'Montserrat', sans-serif; }
    .page-header { position: relative; background-size: cover; background-position: center; }
    .page-header .overlay { background: rgba(0, 0, 0, 0.5); }

    /* ✅ Full-width list card (NOT square) */
    .discount-card{
      background:#fff;
      border-radius:12px;
      box-shadow:0 4px 15px rgba(0,0,0,0.1);
      transition:transform .3s ease, box-shadow .3s ease;
      padding:16px;
      width:100%;
      text-align:left;
    }
    .discount-card:hover{
      transform:translateY(-3px);
      box-shadow:0 10px 25px rgba(0,0,0,0.2);
    }
    .discount-card .card-title{
      font-size:1.05rem;
      line-height:1.2rem;
      color:#198754;
      font-weight:800;
      margin-bottom:8px;
    }
    .discount-card .card-text{
      font-size:0.95rem;
      line-height:1.25rem;
      margin-bottom:4px;
      color:#212529;
    }

    .mobile-donate-btn {
      display: none;
      position: fixed;
      bottom: 20px;
      left: 50%;
      transform: translateX(-50%);
      background-color: #198754;
      color: #fff;
      padding: 10px 25px;
      border-radius: 50px;
      font-weight: 600;
      text-decoration: none;
      box-shadow: 0 5px 20px rgba(0,0,0,0.3);
      transition: all 0.3s ease;
      z-index: 1001;
    }
    .mobile-donate-btn:hover { background-color: #157347; }
    @media (max-width: 768px) { .mobile-donate-btn { display: inline-block; } }
  </style>
</head>

<body>

<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<?php
$settings = $pdo->query("SELECT * FROM membership_benefits_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$sections = $pdo->query("SELECT * FROM membership_benefits_sections WHERE is_active=1 ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

$bulletsStmt = $pdo->query("SELECT * FROM membership_benefits_bullets ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$bullets = [];
foreach ($bulletsStmt as $b) {
  $bullets[$b['section_key']][] = $b;
}

$cards = $pdo->query("SELECT * FROM membership_benefit_cards WHERE is_active=1 ORDER BY position ASC, id DESC")->fetchAll(PDO::FETCH_ASSOC);

$bg = $settings['bg_image'] ?? 'images/banner5.jpg';
?>

<section class="page-header text-center text-white py-5" style="background:url('<?= htmlspecialchars($bg) ?>') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2"><?= htmlspecialchars($settings['page_title'] ?? 'Membership Benefits') ?></h1>
    <p class="lead"><?= htmlspecialchars($settings['page_subtitle'] ?? '') ?></p>
  </div>
</section>

<section class="about-section py-5 text-white">
  <div class="container-xl">

    <?php foreach($sections as $s): ?>
      <div class="mb-5">

        <h3 class="greet-title greet-title-in text-white fw-bold mb-3">
          <?= htmlspecialchars($s['title']) ?>
        </h3>

        <?php if(!empty($s['content'])): ?>
          <p><?= nl2br(htmlspecialchars($s['content'])) ?></p>
        <?php endif; ?>

        <?php if(!empty($bullets[$s['section_key']])): ?>
          <ul class="fs-5">
            <?php foreach($bullets[$s['section_key']] as $blt): ?>
              <li><?= htmlspecialchars($blt['bullet_text']) ?></li>
            <?php endforeach; ?>
          </ul>
        <?php endif; ?>

        <?php if($s['section_key'] === 'for_members'): ?>
          <div class="row g-3 mt-4">

            <?php if(empty($cards)): ?>
              <div class="col-12">
                <div class="text-center text-white-50">No discounts added yet.</div>
              </div>
            <?php endif; ?>

            <?php foreach($cards as $c): ?>
              <div class="col-12">
                <div class="card discount-card">
                  <div class="card-body p-0">

                    <h6 class="card-title mb-2"><?= htmlspecialchars($c['business_name']) ?></h6>

                    <div class="row g-2">
                      <?php if(!empty($c['category'])): ?>
                        <div class="col-12 col-md-6">
                          <p class="card-text mb-0"><strong>Category:</strong> <?= htmlspecialchars($c['category']) ?></p>
                        </div>
                      <?php endif; ?>

                      <?php if(!empty($c['discount'])): ?>
                        <div class="col-12 col-md-6">
                          <p class="card-text mb-0"><strong>Discount:</strong> <?= htmlspecialchars($c['discount']) ?></p>
                        </div>
                      <?php endif; ?>

                      <?php if(!empty($c['offer'])): ?>
                        <div class="col-12">
                          <p class="card-text mb-0"><strong>Offer:</strong> <?= htmlspecialchars($c['offer']) ?></p>
                        </div>
                      <?php endif; ?>

                      <?php if(!empty($c['location'])): ?>
                        <div class="col-12 col-md-6">
                          <p class="card-text mb-0"><strong>Location:</strong> <?= htmlspecialchars($c['location']) ?></p>
                        </div>
                      <?php endif; ?>

                      <?php if(!empty($c['contact'])): ?>
                        <div class="col-12 col-md-6">
                          <p class="card-text mb-0"><strong>Contact:</strong> <?= htmlspecialchars($c['contact']) ?></p>
                        </div>
                      <?php endif; ?>
                    </div>

                  </div>
                </div>
              </div>
            <?php endforeach; ?>

          </div>
        <?php endif; ?>

      </div>
    <?php endforeach; ?>

  </div>
</section>

<?php include "prayer_modal.php"; ?>
<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<a href="#donate" class="mobile-donate-btn">Donate Now</a>
<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll', () => {
  donateBtn.style.opacity = window.scrollY > lastScrollY ? '0' : '1';
  lastScrollY = window.scrollY;
});
</script>
</body>
</html>
