<?php
ob_start();
session_start();
require_once "admin_pannel/db.php"; // ✅ provides $pdo

/* =========================================================
   ✅ PAYPAL CONFIG (SUBSCRIPTION)
========================================================= */
$PAYPAL_MODE = "live"; // "sandbox" OR "live"

// ✅ Fallback client id (if DB is empty)
$PAYPAL_CLIENT_ID = "AV_riSlunWTn1mKi6Xen1m2R-EvAxb55Wni-3nNThnyyPMMah9qd5dgEE6CHvalVcrcLxR6w1oa9ReJA";

// ✅ SECRET MUST STAY SERVER-SIDE ONLY (rotate if leaked)
$PAYPAL_SECRET_ID = "EBhrsEZ1dT4YbS5i6xVhVJU8ws5bHqlFCnl0A43AZcsS5ZoAOdYSajLRn5GzVTFQ3_uoFOXt7rhaes8_";


// ✅ PayPal API BASE URL
$baseUrl = ($PAYPAL_MODE === "live")
  ? "https://api-m.paypal.com"
  : "https://api-m.sandbox.paypal.com";

// ✅ PayPal SDK URL base
$sdkBase = ($PAYPAL_MODE === "live")
  ? "https://www.paypal.com/sdk/js"
  : "https://www.sandbox.paypal.com/sdk/js";


/* =========================================================
   ✅ LOAD SETTINGS FROM DB
========================================================= */
$settings = $pdo->query("SELECT * FROM membership_monthly_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if (!$settings) {
  die("Monthly membership settings not found (membership_monthly_settings id=1).");
}

$bullets = $pdo->query("SELECT * FROM membership_monthly_bullets WHERE is_active=1 ORDER BY position ASC, id ASC")
              ->fetchAll(PDO::FETCH_ASSOC);

$bg       = !empty($settings['bg_image']) ? $settings['bg_image'] : 'images/banner4.jpg';
$currency = !empty($settings['currency']) ? strtoupper($settings['currency']) : 'CAD';
$fee      = (float)($settings['fee_amount'] ?? 10.00);

// ✅ sanitize currency to 3 letters
$currency = preg_replace('/[^A-Z]/', '', strtoupper($currency));
if (strlen($currency) !== 3) $currency = "CAD";

// ✅ DB values
$dbClientId = trim($settings['paypal_client_id'] ?? '');
$paypalPlanId = trim($settings['paypal_plan_id'] ?? '');

// ✅ FINAL client id (DB first, fallback to hard-coded)
$paypalClientIdFinal = $dbClientId !== '' ? $dbClientId : $PAYPAL_CLIENT_ID;


/* =========================================================
   ✅ HELPER: PAYPAL ACCESS TOKEN
========================================================= */
function paypal_get_access_token($baseUrl, $clientId, $secretId){
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $baseUrl . "/v1/oauth2/token");
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_USERPWD, $clientId . ":" . $secretId);
  curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
  curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Accept: application/json",
    "Accept-Language: en_US"
  ]);

  $resp = curl_exec($ch);
  $err  = curl_error($ch);
  $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);

  if ($resp === false) return ["ok"=>false, "error"=>$err, "http"=>$http];

  $data = json_decode($resp, true);
  $token = $data["access_token"] ?? "";

  if (!$token) return ["ok"=>false, "error"=>"No access_token", "http"=>$http, "debug"=>$data];

  return ["ok"=>true, "token"=>$token, "http"=>$http];
}


/* =========================================================
   ✅ AJAX: VERIFY SUBSCRIPTION (SERVER SIDE)
   URL: THIS_FILE?action=verify_subscription
========================================================= */
if ($_SERVER["REQUEST_METHOD"] === "POST" && (($_GET["action"] ?? "") === "verify_subscription")) {

  header("Content-Type: application/json");

  $input = json_decode(file_get_contents("php://input"), true);

  $subscriptionID = trim($input["subscriptionID"] ?? "");
  $firstName      = trim($input["first_name"] ?? "");
  $lastName       = trim($input["last_name"] ?? "");
  $email          = trim($input["email"] ?? "");
  $address        = trim($input["address"] ?? "");

  if ($subscriptionID === "" || $firstName === "" || $lastName === "" || $address === "" || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(["status"=>"error","message"=>"Missing/invalid data"]);
    exit;
  }

  if ($paypalClientIdFinal === "" || $paypalPlanId === "" || $PAYPAL_SECRET_ID === "") {
    echo json_encode(["status"=>"error","message"=>"PayPal settings missing (client/plan/secret)"]);
    exit;
  }

  // ✅ 1) Get token
  $tok = paypal_get_access_token($baseUrl, $paypalClientIdFinal, $PAYPAL_SECRET_ID);
  if (!$tok["ok"]) {
    echo json_encode(["status"=>"error","message"=>"Failed to get PayPal access token","debug"=>$tok]);
    exit;
  }
  $accessToken = $tok["token"];

  // ✅ 2) Get subscription details
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $baseUrl . "/v1/billing/subscriptions/" . rawurlencode($subscriptionID));
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Content-Type: application/json",
    "Authorization: Bearer " . $accessToken
  ]);
  $subResp = curl_exec($ch);
  $subErr  = curl_error($ch);
  $subHttp = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);

  if ($subResp === false) {
    echo json_encode(["status"=>"error","message"=>"PayPal request failed","debug"=>$subErr]);
    exit;
  }

  $subData  = json_decode($subResp, true);
  $ppStatus = strtoupper($subData["status"] ?? "");
  $ppPlanId = $subData["plan_id"] ?? "";

  if (!in_array($ppStatus, ["ACTIVE","APPROVED"], true)) {
    echo json_encode([
      "status" => "error",
      "message" => "Subscription not active (status: $ppStatus)",
      "http" => $subHttp,
      "debug" => $subData
    ]);
    exit;
  }

  if ($ppPlanId !== $paypalPlanId) {
    echo json_encode([
      "status" => "error",
      "message" => "Plan mismatch (wrong mode or wrong plan id)",
      "debug" => [
        "paypal_plan" => $ppPlanId,
        "expected_plan" => $paypalPlanId,
        "mode" => $PAYPAL_MODE
      ]
    ]);
    exit;
  }

  // ✅ 3) Save into DB
  $saved = "yes";
  try {
    $pdo->exec("CREATE TABLE IF NOT EXISTS monthly_members (
      id INT AUTO_INCREMENT PRIMARY KEY,
      first_name VARCHAR(100) NOT NULL,
      last_name  VARCHAR(100) NOT NULL,
      email      VARCHAR(180) NOT NULL,
      address    VARCHAR(255) NOT NULL,
      subscription_id VARCHAR(120) NOT NULL,
      paypal_status VARCHAR(30) DEFAULT NULL,
      created_at DATETIME NOT NULL,
      UNIQUE KEY uq_subscription (subscription_id)
    )");

    $check = $pdo->prepare("SELECT id FROM monthly_members WHERE subscription_id=? LIMIT 1");
    $check->execute([$subscriptionID]);
    $exists = $check->fetch(PDO::FETCH_ASSOC);

    if (!$exists) {
      $ins = $pdo->prepare("INSERT INTO monthly_members
        (first_name,last_name,email,address,subscription_id,paypal_status,created_at)
        VALUES (?,?,?,?,?,?,NOW())
      ");
      $ins->execute([$firstName,$lastName,$email,$address,$subscriptionID,$ppStatus]);
    }
  } catch(Exception $e){
    $saved = "no";
  }

  echo json_encode([
    "status"         => "success",
    "message"        => ($settings['success_message'] ?? "✅ Membership activated successfully!"),
    "subscriptionID" => $subscriptionID,
    "paypal_status"  => $ppStatus,
    "saved_db"       => $saved
  ]);
  exit;
}

// ✅ current file for JS fetch
$selfFile = basename(__FILE__);

// ✅ build SDK query safely (prevents 400 because of bad URL)
$sdkQuery = http_build_query([
  "client-id"  => $paypalClientIdFinal,
  "currency"   => $currency,
  "intent"     => "subscription",
  "vault"      => "true",
  "components" => "buttons"
]);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Monthly Membership | IAOS Regina</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="icon" type="image/png" href="images/fav.png">
<link rel="stylesheet" href="css/style.css">

<style>
  body { font-family: 'Montserrat', sans-serif; }
  .page-header{ position:relative; background-size:cover; background-position:center; }
  .page-header .overlay{ position:absolute; inset:0; background:rgba(0,0,0,0.55); z-index:0; }
  .page-header .container{ position:relative; z-index:1; }

  #resultBox{ display:none;margin-top:15px;padding:12px;border-radius:10px;font-size:14px;line-height:1.5; }
  .successBox{ background:#d1f7d6;color:#0f5132; }
  .errorBox{ background:#f8d7da;color:#842029; }
</style>
</head>

<body>

<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<section class="page-header text-center text-white py-5" style="background:url('<?= htmlspecialchars($bg) ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container">
    <h1 class="display-4 fw-bold mb-2"><?= htmlspecialchars($settings['page_title'] ?? 'Monthly Membership') ?></h1>
    <p class="lead"><?= htmlspecialchars($settings['page_subtitle'] ?? '') ?></p>
  </div>
</section>

<section class="py-5 bg-dark text-white">
  <div class="container-xl">
    <h3 class="fw-bold mb-3"><?= htmlspecialchars($settings['intro_title'] ?? 'Monthly Membership Benefits') ?></h3>

    <?php if(!empty($settings['intro_text'])): ?>
      <p><?= nl2br(htmlspecialchars($settings['intro_text'])) ?></p>
    <?php endif; ?>

    <p class="mt-3">
      Become a <strong>monthly member for $<?= number_format($fee,2) ?>/month</strong>.
    </p>

    <?php if(!empty($bullets)): ?>
      <ul>
        <?php foreach($bullets as $b): ?>
          <li><?= htmlspecialchars($b['bullet_text']) ?></li>
        <?php endforeach; ?>
      </ul>
    <?php endif; ?>

    <?php if(!empty($settings['note_text'])): ?>
      <p><strong>Note:</strong> <?= nl2br(htmlspecialchars($settings['note_text'])) ?></p>
    <?php endif; ?>
  </div>
</section>

<section class="py-5 bg-light">
  <div class="container-xl">
    <div class="text-center mb-5">
      <h2 class="greet-title"><?= htmlspecialchars($settings['form_title'] ?? 'Monthly Membership Application Form') ?></h2>
      <p class="text-muted"><?= htmlspecialchars($settings['form_subtitle'] ?? '') ?></p>
      <?php if(!empty($settings['org_block'])): ?>
        <p><strong><?= nl2br(htmlspecialchars($settings['org_block'])) ?></strong></p>
      <?php endif; ?>
    </div>

    <div class="row justify-content-center">
      <div class="col-md-10">

        <form id="membershipForm" class="p-4 rounded-3 shadow-sm bg-white" autocomplete="off">
          <div class="row g-3">

            <div class="col-md-6">
              <label class="form-label fw-semibold">First Name *</label>
              <input type="text" class="form-control" id="firstName" required>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Last Name *</label>
              <input type="text" class="form-control" id="lastName" required>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Address *</label>
              <input type="text" class="form-control" id="address" placeholder="Street, City, Province, Postal Code" required>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Email *</label>
              <input type="email" class="form-control" id="email" required>
            </div>

            <div class="col-12 mt-2">
              <label class="form-label fw-semibold">Monthly Membership Fee (display only)</label>
              <input type="text" class="form-control" value="$<?= number_format($fee,2) ?> <?= htmlspecialchars($currency) ?> / month" readonly>
              <small class="text-muted">PayPal charges based on your PayPal Plan settings.</small>
            </div>

            <div class="col-12 mt-2">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" id="declaration" required>
                <label class="form-check-label">
                  <?= nl2br(htmlspecialchars($settings['declaration_text'] ?? 'I agree to IAOS regulations.')) ?>
                </label>
              </div>
            </div>

            <div class="col-12 mt-4">
              <?php if(empty($paypalClientIdFinal) || empty($paypalPlanId) || empty($PAYPAL_SECRET_ID)): ?>
                <div class="alert alert-danger">
                  ❌ PayPal is not configured. Please set Client ID + Plan ID (Admin) and Secret ID (in this file).
                </div>
              <?php else: ?>
                <button type="button" class="btn btn-success w-100" id="payNowBtn">Pay & Register</button>

                <div id="paypalArea" class="mt-3" style="display:none;">
                  <div id="paypal-button-container"></div>
                  <div id="resultBox"></div>
                </div>
              <?php endif; ?>
            </div>

          </div>
        </form>

      </div>
    </div>
  </div>
</section>

<?php include "prayer_modal.php"; ?>
<?php include "footer.php"; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<?php if(!empty($paypalClientIdFinal) && !empty($paypalPlanId) && !empty($PAYPAL_SECRET_ID)): ?>
<!-- ✅ PayPal SDK (SUBSCRIPTION) -->
<script src="<?= htmlspecialchars($sdkBase) ?>?<?= htmlspecialchars($sdkQuery) ?>"></script>

<script>
const PLAN_ID  = <?= json_encode($paypalPlanId) ?>;
const VERIFY_URL = <?= json_encode($selfFile . "?action=verify_subscription") ?>;
const resultBox = document.getElementById("resultBox");

function showBox(type, msg){
  resultBox.style.display = "block";
  resultBox.className = (type === "success") ? "successBox" : "errorBox";
  resultBox.innerHTML = msg;
}

let paypalRendered = false;

function renderPaypal(){
  // ✅ prevent crash if SDK failed
  if (typeof paypal === "undefined") {
    showBox("error", `
      <b>❌ PayPal SDK failed to load</b><br>
      Your browser shows <b>400</b> for the PayPal script URL, so <b>paypal</b> is undefined.<br><br>
      ✅ Fix: make sure your <b>Client ID</b> and <b>Mode</b> match (live vs sandbox), and Client ID is not empty in DB.
    `);
    return;
  }

  if(paypalRendered) return;
  paypalRendered = true;

  paypal.Buttons({
    style: { layout: 'vertical', color: 'gold', shape: 'pill', label: 'subscribe' },

    createSubscription: function(data, actions){
      return actions.subscription.create({ plan_id: PLAN_ID });
    },

    onApprove: function(data){
      const firstName = (document.getElementById("firstName").value || "").trim();
      const lastName  = (document.getElementById("lastName").value || "").trim();
      const email     = (document.getElementById("email").value || "").trim();
      const address   = (document.getElementById("address").value || "").trim();

      return fetch(VERIFY_URL, {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({
          subscriptionID: data.subscriptionID || "",
          first_name: firstName,
          last_name: lastName,
          email: email,
          address: address
        })
      })
      .then(res => res.json())
      .then(resp => {
        if(resp.status === "success"){
          showBox("success", `
            <b>✅ Payment Successful!</b><br>
            <b>Subscription ID:</b> ${resp.subscriptionID}<br>
            <b>Status:</b> ${resp.paypal_status}<br>
            <b>Saved to DB:</b> ${resp.saved_db}<br><br>
            <b>${resp.message || ""}</b>
          `);
          document.getElementById("membershipForm").reset();
        } else {
          showBox("error", `
            <b>❌ Verification Failed</b><br>
            <b>Message:</b> ${resp.message || "Unknown"}<br>
            <pre style="white-space:pre-wrap;">${JSON.stringify(resp.debug || resp, null, 2)}</pre>
          `);
        }
      })
      .catch(err => {
        console.error(err);
        showBox("error", "❌ Server Error: " + err);
      });
    },

    onCancel: function(){
      showBox("error", "⚠️ Payment cancelled by user.");
    },

    onError: function(err){
      console.error(err);
      showBox("error", "❌ PayPal Error: " + err);
    }

  }).render("#paypal-button-container");
}

document.getElementById("payNowBtn")?.addEventListener("click", () => {
  const firstName = (document.getElementById("firstName").value || "").trim();
  const lastName  = (document.getElementById("lastName").value || "").trim();
  const email     = (document.getElementById("email").value || "").trim();
  const address   = (document.getElementById("address").value || "").trim();
  const declaration = document.getElementById("declaration").checked;

  const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

  if(!firstName || !lastName || !address || !emailRegex.test(email) || !declaration){
    alert("Please fill all required fields correctly.");
    return;
  }

  document.getElementById("paypalArea").style.display = "block";
  document.getElementById("payNowBtn").style.display = "none";

  renderPaypal();
});
</script>
<?php endif; ?>

</body>
</html>
