<?php
require_once "admin_pannel/db.php";
session_start();

header("Content-Type: application/json");

$action = $_POST['action'] ?? '';

if ($action !== 'save_member_after_payment') {
  echo json_encode(["status"=>"error","message"=>"Invalid action"]);
  exit;
}

$firstName = trim($_POST["first_name"] ?? "");
$lastName  = trim($_POST["last_name"] ?? "");
$email     = trim($_POST["email"] ?? "");
$address   = trim($_POST["address"] ?? "");
$subscriptionID = trim($_POST["subscriptionID"] ?? "");

if (!$firstName || !$lastName || !$address || !filter_var($email, FILTER_VALIDATE_EMAIL) || !$subscriptionID) {
  echo json_encode(["status"=>"error","message"=>"Incomplete data"]);
  exit;
}

try {
  // prevent duplicates by subscription_id (unique)
  $stmt = $pdo->prepare("SELECT id FROM monthly_members WHERE subscription_id=? LIMIT 1");
  $stmt->execute([$subscriptionID]);
  $exists = $stmt->fetchColumn();

  if ($exists) {
    echo json_encode(["status"=>"success","message"=>"Already saved"]);
    exit;
  }

  $ins = $pdo->prepare("INSERT INTO monthly_members (first_name,last_name,email,address,subscription_id,status,created_at)
                        VALUES (?,?,?,?,?,'active',NOW())");
  $ins->execute([$firstName,$lastName,$email,$address,$subscriptionID]);

  echo json_encode(["status"=>"success"]);
  exit;

} catch(Exception $e) {
  echo json_encode(["status"=>"error","message"=>"DB error"]);
  exit;
}
