<?php
require_once "admin_pannel/db.php"; // ✅ Make sure $pdo exists

// ✅ Header settings
$settings = $pdo->query("SELECT * FROM membership_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// ✅ Purpose section
$purpose = $pdo->query("SELECT * FROM membership_purpose WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$bullets = $pdo->query("SELECT * FROM membership_purpose_bullets WHERE purpose_id=1 ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// ✅ Cards
$cards = $pdo->query("SELECT * FROM membership_cards WHERE is_active=1 ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Membership | IAOS Regina</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <link rel="icon" type="image/png" href="images/fav.png">
  <link rel="stylesheet" href="css/style.css">

  <style>
    /* ================= PAGE HEADER ================= */
    .page-header {
      position: relative;
      background: url('<?= htmlspecialchars($settings['bg_image'] ?? 'images/Member.jpg') ?>') center/cover no-repeat;
      padding: 100px 0;
      text-align: center;
      color: #fff;
    }
    .page-header .overlay {
      position: absolute;
      top:0; left:0; width:100%; height:100%;
      background: rgba(0,0,0,0.5);
      z-index:0;
    }
    .page-header h1, .page-header p { position: relative; z-index:1; }

    /* ================= PURPOSE SECTION ================= */
    .membership-purpose {
      background: #fff;
      color: #0f5132;
      border-radius: 20px;
      padding: 50px 30px;
      margin: 40px 0;
      box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    }
    .membership-purpose h2 {
      font-family: 'Montserrat', sans-serif;
      font-weight: 700;
      font-size: 2rem;
      margin-bottom: 20px;
      position: relative;
    }
    .membership-purpose h2::after {
      content: '';
      display: block;
      width: 60px;
      height: 4px;
      background-color: #0f5132;
      margin-top: 8px;
      border-radius: 2px;
    }
    .membership-purpose ul {
      list-style: none;
      padding-left: 20px;
      margin-bottom: 0;
    }
    .membership-purpose ul li {
      margin-bottom: 12px;
      padding-left: 25px;
      position: relative;
      color: #0f5132;
      font-weight: 500;
    }
    .membership-purpose ul li::before {
      content: '✔';
      color: #0f5132;
      position: absolute;
      left: 0;
    }
    .membership-purpose p, .membership-purpose li {
      font-size: 1rem;
      line-height: 1.7;
    }

    /* ================= MODERN MEMBERSHIP CARDS ================= */
    .membership-cards-container {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
      gap: 30px;
      margin: 50px 0;
    }
    .membership-card {
      background: #0f5132;
      color: #fff;
      border-radius: 20px;
      padding: 30px 20px;
      text-align: center;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
      transition: all 0.3s ease;
      box-shadow: 0 6px 20px rgba(0,0,0,0.15);
      cursor: pointer;
    }
    .membership-card:hover {
      transform: translateY(-8px);
      box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    }
    .membership-card h5 {
      font-weight: 700;
      font-size: 1.2rem;
      margin-bottom: 20px;
    }
    .membership-card button {
      background-color: #fff;
      color: #0f5132;
      border-radius: 50px;
      padding: 10px 25px;
      font-weight: 600;
      border: none;
      transition: 0.3s;
      align-self: center;
    }
    .membership-card button:hover {
      background-color: #198754;
      color: #fff;
    }
  </style>
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<!-- ================= NAVBAR ================= -->
<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2"><?= htmlspecialchars($settings['page_title'] ?? 'Become a Member of IAOS') ?></h1>
    <p class="lead"><?= htmlspecialchars($settings['page_subtitle'] ?? '') ?></p>
  </div>
</section>

<!-- ================= PURPOSE OF MEMBERSHIP ================= -->
<section class="container-xl">
  <div class="membership-purpose">
    <h2><?= htmlspecialchars($purpose['title'] ?? 'Purpose of Membership') ?></h2>

    <?php if (!empty($purpose['intro'])): ?>
      <p><?= nl2br(htmlspecialchars($purpose['intro'])) ?></p>
    <?php endif; ?>

    <ul>
      <?php foreach($bullets as $b): ?>
        <li><?= htmlspecialchars($b['bullet_text']) ?></li>
      <?php endforeach; ?>
    </ul>

    <?php if (!empty($purpose['outro'])): ?>
      <p><?= nl2br(htmlspecialchars($purpose['outro'])) ?></p>
    <?php endif; ?>
  </div>
</section>

<!-- ================= MEMBERSHIP CARDS ================= -->
<section class="container-xl">
  <div class="membership-cards-container">
    <?php foreach($cards as $c): ?>
      <div class="membership-card">
        <h5><?= htmlspecialchars($c['title']) ?></h5>
        <p><?= nl2br(htmlspecialchars($c['description'] ?? '')) ?></p>
        <button onclick="window.location.href='<?= htmlspecialchars($c['button_link']) ?>'">
          <?= htmlspecialchars($c['button_text'] ?? 'Join Now') ?>
        </button>
      </div>
    <?php endforeach; ?>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal -->
<?php include "prayer_modal.php"; ?>

<!-- ================= FOOTER ================= -->
<?php include 'footer.php'; ?>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
