<?php
require_once "admin_pannel/db.php";

// SETTINGS
$set = $pdo->query("SELECT * FROM iaos_mosque_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// HEADINGS
$heads = $pdo->query("SELECT * FROM iaos_mosque_headings ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// PARAGRAPHS GROUPED
$pp = $pdo->query("SELECT * FROM iaos_mosque_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$paras = [];
foreach ($pp as $row) $paras[$row['heading_id']][] = $row;

// GALLERY
$gallery = $pdo->query("SELECT * FROM iaos_mosque_gallery ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($set['page_title']) ?> | IAOS Regina</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/style.css">
<link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>
    
    <!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include "header.php"; ?>

<section class="page-header text-center text-white py-5"
style="background:url('<?= $set['bg_image'] ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4"><?= $set['page_title'] ?></h1>
    <p class="lead"><?= $set['page_subtitle'] ?></p>
  </div>
</section>

<section class="py-5">
<div class="container-xl">

<!-- HEADINGS + PARAGRAPHS -->
<?php foreach($heads as $h): ?>
<div class="mb-5 text-white">
  <h3 class="greet-title fw-bold mb-3 greet-title-in text-white"><?= $h['heading_text'] ?></h3>

  <?php if(!empty($paras[$h['id']])): ?>
    <?php foreach($paras[$h['id']] as $p): ?>
      <p><?= nl2br($p['para_text']) ?></p>
    <?php endforeach; ?>
  <?php endif; ?>
</div>
<?php endforeach; ?>

<!-- PROGRESS SECTION -->
<div class="progress-section">
  <h2 class="progress-heading"><?= $set['progress_heading'] ?></h2>
  <p class="progress-subtext"><?= nl2br($set['progress_subtext']) ?></p>

  <div class="mosque-progress" id="mosqueProgress">
    <div class="mosque-progress-fill" id="progressFill"></div>
  </div>

  <div class="progress-labels mt-4">
    <div>💚 Collected: <strong id="collectedCounter">$0</strong></div>
    <div>❤️ Remaining: <strong id="remainingCounter">$0</strong></div>
    <div>🏗️ Total: <strong id="totalCounter">$0</strong></div>
  </div>
</div>

<!-- GALLERY -->
<div class="gallery-section mt-5">
  <h3 class="greet-title text-white">Construction Gallery</h3>

  <div class="row g-3 d-none d-md-flex">
    <?php foreach($gallery as $g): ?>
    <div class="col-md-4 col-sm-6">
      <a href="<?= $g['image_path'] ?>" target="_blank">
        <img src="<?= $g['image_path'] ?>" class="gallery-img">
      </a>
    </div>
    <?php endforeach; ?>
  </div>

  <!-- Mobile Slider -->
  <div id="galleryCarousel" class="carousel slide d-md-none" data-bs-ride="carousel">
    <div class="carousel-inner">
      <?php $i=0; foreach($gallery as $g): ?>
      <div class="carousel-item <?= $i==0?'active':'' ?>">
        <img src="<?= $g['image_path'] ?>" class="d-block w-100 gallery-img">
      </div>
      <?php $i++; endforeach; ?>
    </div>

    <button class="carousel-control-prev" type="button" data-bs-target="#galleryCarousel" data-bs-slide="prev">
      <span class="carousel-control-prev-icon"></span>
    </button>

    <button class="carousel-control-next" type="button" data-bs-target="#galleryCarousel" data-bs-slide="next">
      <span class="carousel-control-next-icon"></span>
    </button>
  </div>

</div>

</div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include "footer.php"; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener("DOMContentLoaded", function(){
    const collected = <?= $set['collected'] ?>;
    const remaining = <?= $set['remaining'] ?>;
    const total = <?= $set['total'] ?>;

    const percent = (collected / total) * 100;
    document.getElementById("progressFill").style.width = percent + "%";

    function animate(id, target) {
        let val = 0;
        const el = document.getElementById(id);
        const timer = setInterval(() => {
            val += Math.ceil(target/50);
            if(val >= target) { val = target; clearInterval(timer); }
            el.textContent = "$" + val.toLocaleString();
        }, 30);
    }

    animate("collectedCounter", collected);
    animate("remainingCounter", remaining);
    animate("totalCounter", total);
});
</script>

</body>
</html>
