<?php
require_once "admin_pannel/db.php";

/* GLOBAL SETTINGS */
$set = $pdo->query("SELECT * FROM iaos_news_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* POSTS */
$posts = $pdo->query(
  "SELECT * FROM iaos_news_posts ORDER BY publish_date DESC, id DESC"
)->fetchAll(PDO::FETCH_ASSOC);

/* PARAGRAPHS */
$paras = [];
if (!empty($posts)) {
    $ids = array_column($posts,'id');
    $in = implode(",", array_fill(0,count($ids),'?'));

    $stmt = $pdo->prepare("SELECT * FROM iaos_news_paragraphs WHERE post_id IN ($in) ORDER BY position DESC,id DESC");
    $stmt->execute($ids);

    foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $p) {
        $paras[$p['post_id']][] = $p;
    }
}

/* Helper: ensure proper URL for images */
function safe_image($path, $default=null) {
    if (!$path) return $default;
    return htmlspecialchars($path, ENT_QUOTES);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($set['page_title']) ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/style.css">
<link rel="icon" type="image/png" href="images/fav.png">
<style>
.update-box {
    background: rgba(255,255,255,0.95);
    padding: 20px;
    border-radius: 8px;
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
}
.update-text { flex: 1 1 250px; }
.update-image { flex: 0 0 200px; max-width: 100%; }
.update-image img {
    width: 100%;
    height: auto;
    object-fit: cover;
    border-radius: 6px;
    cursor: pointer;
    transition: transform 0.2s;
}
.update-image img:hover { transform: scale(1.05); }
.update-date { font-size:0.9rem; color:#555; margin-bottom:0.5rem; }
.update-title { font-size:1.4rem; font-weight:600; margin-bottom:1rem; }
.update-content p { margin-bottom:1rem; }
.update-button a { text-decoration:none; color:#fff; }

@media (max-width: 767px) {
    .update-box { flex-direction: column; }
    .update-text, .update-image { width: 100%; }
}

/* Lightbox overlay */
#lightbox {
    display: none; /* hidden by default */
    position: fixed;
    z-index: 9999;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: rgba(0,0,0,0.9);
    justify-content: center;
    align-items: center;
    cursor: zoom-out;
}
#lightbox img {
    max-width: 90%;
    max-height: 90%;
    border-radius: 6px;
    box-shadow: 0 0 20px rgba(0,0,0,0.5);
}
</style>
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- Page Header -->
<section class="page-header text-center text-white py-5"
  style="background:url('<?= safe_image($set['bg_image']) ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold"><?= htmlspecialchars($set['page_title']) ?></h1>
    <p class="lead"><?= htmlspecialchars($set['page_subtitle']) ?></p>
  </div>
</section>

<!-- News Section -->
<section class="py-5">
<div class="container-xl">

<?php if (empty($posts)): ?>
  <div class="text-center text-white-50 py-5">
    <h4>No updates right now.</h4>
    <p>Please check again soon, in shaa Allah.</p>
  </div>
<?php endif; ?>

<?php foreach ($posts as $post): ?>
<div class="update-box mb-5">

  <div class="update-text">
    <div class="update-date"><?= htmlspecialchars(date('F j, Y', strtotime($post['publish_date']))) ?></div>
    <div class="update-title"><?= htmlspecialchars($post['intro_heading']) ?></div>
    <div class="update-content"><p><?= nl2br(htmlspecialchars($post['intro_text'])) ?></p></div>

    <?php foreach (($paras[$post['id']] ?? []) as $p): ?>
      <div class="update-content"><p><?= nl2br(htmlspecialchars($p['para_text'])) ?></p></div>
    <?php endforeach; ?>

    <?php if (!empty(trim($post['link'] ?? ''))): ?>
      <div class="update-button mt-3">
        <a href="<?= htmlspecialchars($post['link']) ?>" class="btn btn-primary" target="_blank">
          <?= htmlspecialchars(trim($post['link_text']) ?: 'Read More') ?>
        </a>
      </div>
    <?php endif; ?>
  </div>

  <?php if (!empty($post['image'])): ?>
  <div class="update-image">
    <img src="<?= safe_image($post['image']) ?>" alt="News Image" onclick="openLightbox('<?= safe_image($post['image']) ?>')">
  </div>
  <?php endif; ?>

</div>
<hr class="border-secondary opacity-25 my-5">
<?php endforeach; ?>

</div>
</section>

<!-- Lightbox -->
<div id="lightbox" onclick="closeLightbox()">
  <img id="lightbox-img" src="">
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function openLightbox(src){
    const lb = document.getElementById('lightbox');
    const img = document.getElementById('lightbox-img');
    img.src = src;
    lb.style.display = 'flex'; // show overlay on click
}
function closeLightbox(){
    const lb = document.getElementById('lightbox');
    const img = document.getElementById('lightbox-img');
    lb.style.display = 'none'; // hide overlay
    img.src = '';
}
</script>

<!-- Prayer Modal -->
<?php include "prayer_modal.php"; ?>
<?php include 'footer.php'; ?>

</body>
</html>
