<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Saturday School Program | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Custom CSS -->
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner2.jpg') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Saturday School Program</h1>
    <p class="lead">IAOS Regina Weekend Islamic Education for Children</p>
  </div>
</section>

<!-- ================= MAIN CONTENT ================= -->
<section class="about-section py-5">
  <div class="container-xl">

    <div class="mb-5 text-white">
      <h3 class="greet-title text-white greet-title-in fw-bold mb-3">PROGRAM OVERVIEW</h3>
      <p>The <strong>Saturday School Program</strong> at IAOS Regina is a weekend Islamic learning initiative dedicated to providing children with Quranic education and Islamic knowledge in an engaging environment. It helps students build a strong foundation of Islamic morals, Arabic reading, and daily supplications while maintaining balance with their regular school schedules.</p>

      <h5 class="fw-bold text-success mt-4">Program Objectives:</h5>
      <ul>
        <li>To teach children Quran recitation with proper Tajweed and understanding.</li>
        <li>To strengthen Islamic identity, faith, and good character.</li>
        <li>To instill love for Salah, the Prophet ﷺ, and Islamic values.</li>
        <li>To help students memorize short Surahs and daily Duas.</li>
        <li>To build a fun, respectful, and interactive learning atmosphere.</li>
      </ul>

      <h5 class="fw-bold text-success mt-4">Program Details:</h5>
      <ul>
        <li><strong>Academic Session:</strong> September 2025 – June 2026</li>
        <li><strong>Day:</strong> Every Saturday</li>
        <li><strong>Time:</strong> 10:00 AM – 1:00 PM</li>
        <li><strong>Location:</strong> IAOS Masjid, 3273 Montague Street, Regina, SK</li>
        <li><strong>Age Group:</strong> 5 – 16 years old (Boys & Girls)</li>
        <li><strong>Monthly Fees:</strong> $60 per child | $50 for siblings</li>
        <li><strong>Payment Method:</strong> EFT (Electronic Fund Transfer)</li>
      </ul>
    </div>

    <!-- ================= RULES ACCORDION ================= -->
    <div class="accordion mb-5" id="rulesAccordion">
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button fw-bold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseRules">
            Rules and Regulations
          </button>
        </h2>
        <div id="collapseRules" class="accordion-collapse collapse">
          <div class="accordion-body">
            <p><strong>Attendance:</strong> Students must attend regularly and be on time. Repeated absences may lead to removal from the program.</p>
            <p><strong>Behavior:</strong> Students are expected to maintain Islamic manners, show respect to teachers and classmates, and follow all school rules.</p>
            <p><strong>Dress Code:</strong> Modest Islamic attire is mandatory. Boys should wear a topi/head covering; girls must wear hijab.</p>
            <p><strong>Homework:</strong> Parents should ensure students review lessons and complete weekly assignments at home.</p>
            <p><strong>Safety:</strong> Students must be dropped off and picked up on time. IAOS will not be responsible for students left after class hours.</p>
            <p><strong>Electronic Devices:</strong> Phones, video games, and similar items are not permitted during school hours.</p>
            <p><strong>Discipline:</strong> Any student found misbehaving will be warned; repeated offenses may result in dismissal.</p>
            <p><strong>Financial Assistance:</strong> Limited aid is available upon request for families facing financial hardship.</p>
            <p><strong>Contact:</strong> <a href="mailto:schooladmin@iaosregina.com">schooladmin@iaosregina.com</a></p>
          </div>
        </div>
      </div>
    </div>

    <!-- ================= REGISTRATION FORM ================= -->
    <div class="bg-white p-4 rounded shadow-sm">
      <h4 class="fw-bold text-success mb-4 text-center">Saturday School Registration Form</h4>
      <p class="text-center mb-4">Please fill out the required information. Fields marked with * are mandatory.</p>

      <form>
        <div class="mb-3">
          <label>Email Address *</label>
          <input type="email" class="form-control" placeholder="e.g. tahirhafeez764@gmail.com" required>
        </div>

        <div class="mb-3">
          <label>Student’s Full Name *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Parent/Guardian Full Name *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Date of Birth *</label>
            <input type="date" class="form-control" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Gender *</label>
            <select class="form-select" required>
              <option value="">Select</option>
              <option>Male</option>
              <option>Female</option>
            </select>
          </div>
        </div>

        <div class="mb-3">
          <label>Contact Phone Number (Home + Cell) *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Home Address *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Emergency Contact Person, Relationship & Phone *</label>
          <textarea class="form-control" rows="2" placeholder="e.g. Ahmed Khan, Father, 306-555-7890" required></textarea>
        </div>

        <div class="mb-3">
          <label>Preferred Class Level *</label>
          <select class="form-select" required>
            <option value="">Select Level</option>
            <option>Beginner (Qaida / Basic Arabic)</option>
            <option>Intermediate (Reading with Tajweed)</option>
            <option>Advanced (Quran + Islamic Studies)</option>
          </select>
        </div>

        <div class="mb-3">
          <label>Previous Islamic School / Teacher (if any)</label>
          <input type="text" class="form-control" placeholder="Optional">
        </div>

        <div class="form-check mb-3">
          <input class="form-check-input" type="checkbox" id="agreeRules" required>
          <label class="form-check-label" for="agreeRules">
            I certify that I have read the <a href="#collapseRules" data-bs-toggle="collapse" class="text-success fw-semibold text-decoration-none">rules and regulations</a> and will abide by them.
          </label>
        </div>

        <div class="text-center">
          <button type="submit" class="btn btn-success px-5 py-2">Submit Registration</button>
        </div>
      </form>
    </div>
  </div>
</section>

<!-- ================= MOSQUE LOCATIONS ================= -->
<section class="bg-light py-5">
  <div class="container-xl">
    <h2 class="text-center greet-title fw-bold mb-5">Our Mosque Locations</h2>
    <div class="row g-4">
      <div class="col-md-4">
        <h5 class="text-success">IAOS (Regina) Mosque</h5>
        <p class="text-success">3273 Montague St, Regina, SK S4S 1Z8</p>
        <iframe src="https://www.google.com/maps?q=3273+Montague+St,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">As-Salam Mosque & Community Center</h5>
        <p class="text-success">641 Victoria Ave E, Regina, SK S4N 0P1</p>
        <iframe src="https://www.google.com/maps?q=641+Victoria+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">East Musallah</h5>
        <p class="text-success">2318 Assiniboine Ave E, Regina, SK S4V 2P5</p>
        <iframe src="https://www.google.com/maps?q=2318+Assiniboine+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>



<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<a href="#donate" class="mobile-donate-btn">Donate Now</a>
<script>
let lastScrollY=window.scrollY;
const donateBtn=document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll',()=>{donateBtn.style.opacity=window.scrollY>lastScrollY?'0':'1';lastScrollY=window.scrollY;});
</script>
</body>
</html>
