<?php 
// ================= FORM HANDLER =================
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

  $email         = $_POST['email'] ?? '';
  $student_name  = $_POST['student_name'] ?? '';
  $guardian_name = $_POST['guardian_name'] ?? '';
  $dob           = $_POST['dob'] ?? '';
  $gender        = $_POST['gender'] ?? '';
  $health_card   = $_POST['health_card'] ?? '';
  $phone         = $_POST['phone'] ?? '';
  $address       = $_POST['address'] ?? '';
  $whatsapp      = $_POST['whatsapp'] ?? '';
  $emergency     = $_POST['emergency'] ?? '';
  $medical       = $_POST['medical'] ?? '';

  // TEMP: just mark success (DB / Email comes next)
  $success = true;
}
?>

<div class="bg-white p-4 rounded shadow-sm">

  <?php if ($success): ?>
    <div class="alert alert-success text-center fw-semibold mb-4">
      ✅ Registration submitted successfully. We will contact you by email.
    </div>
  <?php endif; ?>

  <h4 class="fw-bold text-success mb-4 text-center">
    Summer School
  </h4>

  <form method="POST" action="">

    <div class="mb-3">
      <label>Email *</label>
      <input type="email" name="email" class="form-control" required>
    </div>

    <div class="mb-3">
      <label>Student’s Full Name *</label>
      <input type="text" name="student_name" class="form-control" required>
    </div>

    <div class="mb-3">
      <label>Parent / Guardian Name *</label>
      <input type="text" name="guardian_name" class="form-control" required>
    </div>

    <div class="row">
      <div class="col-md-6 mb-3">
        <label>Date of Birth *</label>
        <input type="date" name="dob" class="form-control" required>
      </div>
      <div class="col-md-6 mb-3">
        <label>Gender *</label>
        <select name="gender" class="form-select" required>
          <option value="">Select</option>
          <option>Male</option>
          <option>Female</option>
        </select>
      </div>
    </div>

    <div class="mb-3">
      <label>Health Card Number *</label>
      <input type="text" name="health_card" class="form-control" required>
    </div>

    <div class="mb-3">
      <label>Contact Phone Number *</label>
      <input type="text" name="phone" class="form-control" required>
    </div>

    <div class="mb-3">
      <label>Home Address *</label>
      <input type="text" name="address" class="form-control" required>
    </div>

    <div class="mb-3">
      <label>WhatsApp Number *</label>
      <input type="text" name="whatsapp" class="form-control" required>
    </div>

    <div class="mb-3">
      <label>Emergency Contact Person and Phone Number *</label>
      <input type="text" name="emergency" class="form-control" placeholder="e.g. Ali Khan – Father – 306-123-4567" required>
    </div>

    <div class="mb-3">
      <label>Allergies / Medical Conditions</label>
      <textarea name="medical" class="form-control" rows="3"></textarea>
    </div>
<hr class="my-4">

<h5 class="fw-bold text-success mb-3 text-center">
  Please choose one of the programs for your child
</h5>

<div class="accordion" id="summerProgramAccordion">

  <!-- Program 1 -->
  <div class="accordion-item">
    <h2 class="accordion-header">
      <button class="accordion-button collapsed fw-semibold"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#regularSummerSchool">
        1) Regular Summer School (Boys and Girls)
      </button>
    </h2>

    <div id="regularSummerSchool"
         class="accordion-collapse collapse"
         data-bs-parent="#summerProgramAccordion">
      <div class="accordion-body">
        <p>
          The objective of the school is to not only teach kids Quran and Islamic Studies
          but to involve them in activities such as, but not limited to:
        </p>
        <ul>
          <li>Seerah of Prophet Mohammad (peace be upon him)</li>
          <li>Salah</li>
          <li>Hajj and Eid</li>
          <li>Prophet stories</li>
          <li>Athaan competition</li>
          <li>Nasheed competition</li>
          <li>Speech competition</li>
          <li>Presentations</li>
          <li>Posters and Calligraphy</li>
          <li>Art and Craft Fun Activities</li>
          <li>Explanation / Tafseer of Surahs</li>
          <li>Muslim manners and character building</li>
        </ul>

        <div class="form-check mt-3">
          <input class="form-check-input" type="radio" name="summer_program"
                 value="Regular Summer School" required>
          <label class="form-check-label fw-semibold">
            Select this program
          </label>
        </div>
      </div>
    </div>
  </div>

  <!-- Program 2 -->
  <div class="accordion-item">
    <h2 class="accordion-header">
      <button class="accordion-button collapsed fw-semibold"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#summerHifzProgram">
        2) Summer Quran Hifz Program (Only for Boys)
      </button>
    </h2>

    <div id="summerHifzProgram"
         class="accordion-collapse collapse"
         data-bs-parent="#summerProgramAccordion">
      <div class="accordion-body">
        <ul>
          <li>Memorization of the Quran</li>
          <li>Learn proper Tajweed</li>
          <li>Muslim manners and character building</li>
          <li>Outdoor activities</li>
        </ul>

        <div class="form-check mt-3">
          <input class="form-check-input" type="radio" name="summer_program"
                 value="Summer Quran Hifz Program">
          <label class="form-check-label fw-semibold">
            Select this program
          </label>
        </div>
      </div>
    </div>
  </div>

</div>




    <div class="form-check mb-3">
      <input class="form-check-input" type="checkbox" name="agree_rules" required>
      <label class="form-check-label">
        I agree to the following rules and regulations: <br>
        <strong>Study books:</strong> The Holy Quran and other applicable books. Students should possess their own Holy Quran for study and take it home daily. <br>
        <strong>Group System:</strong> Students progress with their group; missed lessons must be made up independently. <br>
        <strong>Daily Assignment:</strong> Assignments are according to class, not personal preference. <br>
        <strong>Attendance:</strong> At least 75% attendance is mandatory; three unexcused absences may lead to removal. <br>
        <strong>Communication:</strong> Via WhatsApp group for teachers and school management. <br>
        <strong>Late Pickup & Safety:</strong> Students must be picked up on time; association not responsible for post-class safety. <br>
        <strong>Restriction in School:</strong> No abusive language, fighting, toys, phones, video games. Misbehavior may lead to expulsion. <br>
        <strong>Financial Assistance:</strong> Available for special cases. <br>
        <strong>Complaints and Suggestions:</strong> Contact <a href="mailto:schooladmin@iaosregina.com">schooladmin@iaosregina.com</a>. <br>
        <strong>Cancellation of Registration:</strong> Notify school admin at least 2 weeks in advance. <br>
        <strong>Holidays:</strong> Schedule provided during academic year.
      </label>
    </div>

    <div class="text-center">
      <button type="submit" class="btn btn-success px-5 py-2">
        Submit Registration
      </button>
    </div>

  </form>
</div>
