<?php
ob_start();
include "layout.php";
require_once "db.php";

if (!in_array($role, ['admin', 'financeController', 'donorController'])) {
    die("Access denied.");
}

$pdo = get_db();
$message = "";

// ---------- ADD NEW CATEGORY ----------
if ($_SERVER["REQUEST_METHOD"] === "POST" && $_POST['action'] === 'add') {
    $name = trim($_POST['category_name']);
    $desc = trim($_POST['description']);
    $amount = (float)$_POST['amount'];
    try {
        $stmt = $pdo->prepare("INSERT INTO donation_categories (category_name, description, amount, status) VALUES (?, ?, ?, 'active')");
        $stmt->execute([$name, $desc, $amount]);
        $message = "✅ Category added successfully!";
    } catch (PDOException $e) {
        $message = "❌ Error: " . $e->getMessage();
    }
}

// ---------- UPDATE CATEGORIES ----------
if ($_SERVER["REQUEST_METHOD"] === "POST" && $_POST['action'] === 'update') {
    for ($i = 0; $i < count($_POST['id']); $i++) {
        $id = $_POST['id'][$i];
        $name = $_POST['category_name'][$i];
        $desc = $_POST['description'][$i];
        $amount = (float)$_POST['amount'][$i];
        $status = $_POST['status'][$i];
        $stmt = $pdo->prepare("UPDATE donation_categories SET category_name=?, description=?, amount=?, status=? WHERE id=?");
        $stmt->execute([$name, $desc, $amount, $status, $id]);
    }
    header("Location: donation_controller.php?status=success");
    exit;
}

// ---------- DELETE CATEGORY ----------
if (isset($_POST['delete_id']) && is_numeric($_POST['delete_id'])) {
    $delID = (int)$_POST['delete_id'];
    $pdo->prepare("DELETE FROM donation_categories WHERE id=?")->execute([$delID]);
    header("Location: donation_controller.php?deleted=1");
    exit;
}

// ---------- FETCH CATEGORIES ----------
$stmt = $pdo->query("SELECT * FROM donation_categories ORDER BY id ASC");
$rows = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Donation Controller</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
body { background:#064635; color:white; padding:20px; font-family:sans-serif; }
.card { background:rgba(255,255,255,0.1); border:none; border-radius:15px; padding:20px; }
.form-control, .form-select { background:rgba(255,255,255,0.9); color:black; border:none; text-align:center; }
.btn-light { color:#064635; font-weight:600; }
.btn-warning { background:#f4c542; border:none; color:#064635; font-weight:600; }
</style>
</head>
<body>

<div class="container-fluid" style="margin-top:50px;">
  <h3 class="mb-4 text-white"><i class="bi bi-cash-coin"></i> Donation Controller</h3>

  <?php if(isset($_GET['status']) && $_GET['status']=='success'): ?>
    <div class="alert alert-success">✅ Categories updated successfully!</div>
  <?php elseif(isset($_GET['deleted'])): ?>
    <div class="alert alert-info">🗑️ Category deleted successfully!</div>
  <?php elseif($message): ?>
    <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
  <?php endif; ?>

  <!-- Add New Category -->
  <div class="card mb-4">
    <h5 class="text-white"><i class="bi bi-plus-circle"></i> Add New Donation Category</h5>
    <form method="POST">
      <input type="hidden" name="action" value="add">
      <div class="row mb-3">
        <div class="col-md-4">
          <label class="text-white">Category Name</label>
          <input type="text" class="form-control" name="category_name" placeholder="Enter category name" required>
        </div>
        <div class="col-md-4">
          <label class="text-white">Description</label>
          <input type="text" class="form-control" name="description" placeholder="Short description">
        </div>
        <div class="col-md-2">
          <label class="text-white">Amount (CAD)</label>
          <input type="number" step="0.01" class="form-control" name="amount" required>
        </div>
        <div class="col-md-2 d-flex align-items-end">
          <button class="btn btn-light w-100"><i class="bi bi-plus-circle"></i> Add</button>
        </div>
      </div>
    </form>
  </div>

  <!-- Manage Categories -->
  <div class="card p-3 shadow">
    <form method="POST" id="updateForm">
      <input type="hidden" name="action" value="update">
      <div class="table-responsive">
        <table class="table table-striped text-center align-middle">
          <thead class="table-dark">
            <tr>
              <th>ID</th>
              <th>Category</th>
              <th>Description</th>
              <th>Amount (CAD)</th>
              <th>Status</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($rows as $r): ?>
              <tr>
                <td><?= htmlspecialchars($r['id']) ?></td>
                <td><input type="text" class="form-control text-dark" name="category_name[]" value="<?= htmlspecialchars($r['category_name']) ?>" style="width:100%"></td>
                <td><input type="text" class="form-control text-dark" name="description[]" value="<?= htmlspecialchars($r['description']) ?>" style="width:100%"></td>
                <td><input type="number" step="0.01" class="form-control text-dark" name="amount[]" value="<?= htmlspecialchars($r['amount']) ?>" style="width:100%"></td>
                <td>
                  <select class="form-select" name="status[]">
                    <option value="active" <?= $r['status']=='active'?'selected':'' ?>>Active</option>
                    <option value="inactive" <?= $r['status']=='inactive'?'selected':'' ?>>Inactive</option>
                  </select>
                </td>
                <td>
                  <button type="button" class="btn btn-danger btn-sm delete-btn" data-id="<?= $r['id'] ?>" data-name="<?= htmlspecialchars($r['category_name']) ?>">
                    <i class="bi bi-trash"></i>
                  </button>
                </td>
                <input type="hidden" name="id[]" value="<?= htmlspecialchars($r['id']) ?>">
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="text-end">
        <button class="btn btn-warning mt-3"><i class="bi bi-save"></i> Save Changes</button>
      </div>
    </form>
  </div>
</div>

<!-- Hidden Delete Form -->
<form method="POST" id="deleteForm" style="display:none;">
  <input type="hidden" name="delete_id" id="delete_id">
</form>

<script>
document.querySelectorAll(".delete-btn").forEach(btn => {
  btn.addEventListener("click", function() {
    const id = this.dataset.id;
    const name = this.dataset.name;
    Swal.fire({
      title: `Delete category "${name}"?`,
      text: "This action cannot be undone!",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#d33",
      cancelButtonColor: "#3085d6",
      confirmButtonText: "Yes, delete it!",
      background: "#fff",
      color: "#064635"
    }).then((result) => {
      if (result.isConfirmed) {
        document.getElementById("delete_id").value = id;
        document.getElementById("deleteForm").submit();
      }
    });
  });
});
</script>

</body>
</html>
