<?php
ob_start();
include "layout.php";
require_once "db.php";

$pdo = get_db();
$pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_general_ci");
$pdo->exec("SET CHARACTER SET utf8mb4");

$month = $_GET['month'] ?? date('Y-m');

/* =========================================================
   DELETE ALL PRAYER TIMES
========================================================= */
if (isset($_POST['delete_all'])) {
    $pdo->exec("DELETE FROM prayer_times");
    echo "<script>alert('✅ All prayer times deleted!');window.location='edit_salah.php';</script>";
    exit;
}

/* =========================================================
   CSV UPLOAD HANDLER (FIXED FOR YOUR EXCEL)
========================================================= */
if (isset($_POST['upload_csv']) && !empty($_FILES['csv_file']['tmp_name'])) {

    try {
        $file = fopen($_FILES['csv_file']['tmp_name'], 'r');
        fgetcsv($file); // skip header row

        $insert = $pdo->prepare("
            INSERT INTO prayer_times (
                prayer_date,
                fajar_begins, fajar,
                sunrise,
                zuhar_begins, zuhar,
                asar_begins, asar,
                sunset,
                magrib_begins,
                isha_begins, isha,
                jumah1, jumah2,
                hijri
            ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
        ");

        $pdo->beginTransaction();

        while (($r = fgetcsv($file)) !== false) {

            if (empty($r[0])) continue;

            // 📅 Excel format: 1/13/2025 (m/d/Y)
            $dateObj = DateTime::createFromFormat('m/d/Y', trim($r[0]));
            if (!$dateObj) continue;

            $insert->execute([
                $dateObj->format('Y-m-d'),

                $r[1]  ?? null, // fajar_begins
                $r[2]  ?? null, // fajar
                $r[3]  ?? null, // sunrise

                $r[4]  ?? null, // zuhar_begins
                $r[5]  ?? null, // zuhar

                $r[6]  ?? null, // asar_begins
                $r[7]  ?? null, // asar

                $r[8]  ?? null, // sunset
                $r[9]  ?? null, // magrib_begins

                $r[10] ?? null, // isha_begins
                $r[11] ?? null, // isha

                $r[12] ?? null, // jumah1
                $r[13] ?? null, // jumah2

                $r[14] ?? null  // hijri
            ]);
        }

        $pdo->commit();
        fclose($file);

        echo "<script>alert('✅ CSV imported successfully!');window.location='edit_salah.php';</script>";
        exit;

    } catch (Exception $e) {
        $pdo->rollBack();
        echo "<div class='alert alert-danger'>❌ CSV Import Error: " . htmlspecialchars($e->getMessage()) . "</div>";
    }
}

/* =========================================================
   LOAD DATA FOR SELECTED MONTH
========================================================= */
$sql = "
    SELECT prayer_date, hijri,
           fajar_begins, fajar,
           zuhar_begins, zuhar,
           asar_begins, asar,
           sunset,
           magrib_begins,
           isha_begins, isha,
           jumah1, jumah2
    FROM prayer_times
    WHERE DATE_FORMAT(prayer_date, '%Y-%m') = :month
    ORDER BY prayer_date ASC
";
$stmt = $pdo->prepare($sql);
$stmt->execute([':month' => $month]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container-fluid" style="margin-top:50px;">

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3><i class="bi bi-gear-fill"></i> Edit Salah Timings – <?= htmlspecialchars($month) ?></h3>

    <form method="get" class="d-flex">
      <input type="month" name="month" class="form-control me-2" value="<?= htmlspecialchars($month) ?>">
      <button class="btn btn-success"><i class="bi bi-search"></i> Load</button>
    </form>
  </div>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <form method="post" onsubmit="return confirm('⚠️ Delete ALL prayer times?');">
      <button name="delete_all" class="btn btn-danger">
        <i class="bi bi-trash"></i> Delete All
      </button>
    </form>

    <form method="post" enctype="multipart/form-data" class="d-flex gap-2">
      <input type="file" name="csv_file" accept=".csv" class="form-control" required>
      <button class="btn btn-primary" name="upload_csv">
        <i class="bi bi-upload"></i> Upload CSV
      </button>
    </form>
  </div>

  <div class="card p-3 shadow">
    <?php if ($rows): ?>
    <form method="post" action="update_salah.php">
      <div class="table-responsive">
        <table class="table table-striped align-middle text-center">
          <thead class="table-dark">
            <tr>
              <th>Date</th>
              <th>Hijri</th>
              <th>Fajr Begin</th><th>Fajr Iqama</th>
              <th>Dhuhr Begin</th><th>Dhuhr Iqama</th>
              <th>Asr Begin</th><th>Asr Iqama</th>
              <th>Maghrib Begin</th><th>Maghrib Iqama</th>
              <th>Isha Begin</th><th>Isha Iqama</th>
              <th>Jumah 1</th><th>Jumah 2</th>
             
            </tr>
          </thead>
          <tbody>
          <?php foreach ($rows as $r): ?>
            <tr>
              <td>
                <b><?= htmlspecialchars($r['prayer_date']) ?></b>
                <input type="hidden" name="prayer_date[]" value="<?= htmlspecialchars($r['prayer_date']) ?>">
              </td>

              <td><input class="form-control text-center text-black" name="hijri[]" value="<?= htmlspecialchars($r['hijri']) ?>"></td>

              <td><input type="time" class="form-control text-black" name="fajar_begins[]" value="<?= $r['fajar_begins'] ?>"></td>
              
              <td><input type="time" class="form-contro text-black" name="fajar[]" value="<?= $r['fajar'] ?>"></td>

              <td><input type="time" class="form-control text-black" name="zuhar_begins[]" value="<?= $r['zuhar_begins'] ?>"></td>
              <td><input type="time" class="form-control text-black" name="zuhar[]" value="<?= $r['zuhar'] ?>"></td>

              <td><input type="time" class="form-control text-black" name="asar_begins[]" value="<?= $r['asar_begins'] ?>"></td>
              <td><input type="time" class="form-control text-black" name="asar[]" value="<?= $r['asar'] ?>"></td>

              <td><input type="time" class="form-control text-black" name="sunset[]" value="<?= $r['sunset'] ?>"></td>
              
              <td><input type="time" class="form-control text-black" name="magrib_begins[]" value="<?= $r['magrib_begins'] ?>"></td>

              <td><input type="time" class="form-control text-black" name="isha_begins[]" value="<?= $r['isha_begins'] ?>"></td>
              <td><input type="time" class="form-control text-black" name="isha[]" value="<?= $r['isha'] ?>"></td>

              <td><input type="time" class="form-control text-black" name="jumah1[]" value="<?= $r['jumah1'] ?>"></td>
              <td><input type="time" class="form-control text-black" name="jumah2[]" value="<?= $r['jumah2'] ?>"></td>
        
              
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <div class="text-end">
        <button class="btn btn-warning mt-3">
          <i class="bi bi-save"></i> Save Changes
        </button>
      </div>
    </form>
    <?php else: ?>
      <div class="alert alert-danger">No data found for <?= htmlspecialchars($month) ?>.</div>
    <?php endif; ?>
  </div>
</div>
