<?php
session_start();
header_remove("X-Powered-By");

// ==============================
// DB CONNECTION
// ==============================
$con = mysqli_connect("localhost","iaosr874_newWeb","kkrNvZVT57-ru3~]","iaosr874_qrCode");
if (!$con) {
    die("DB Connection Failed!");
}

// ==============================
// CHECK LOGIN
// ==============================
if (!isset($_SESSION['userEmail']) || $_SESSION['userEmail'] == '') {
    header("Location:index.php");
    exit;
}

// ==============================
// CHECK ROLE
// ==============================
$userEmail = $_SESSION['userEmail'];

$stmt = $con->prepare("SELECT userType FROM users WHERE userEmail=? LIMIT 1");
$stmt->bind_param("s", $userEmail);
$stmt->execute();
$stmt->bind_result($currentUser);
$stmt->fetch();
$stmt->close();

if (!($currentUser == "Admin" || $currentUser == "editor")) {
    header("Location:index.php");
    exit;
}

// ==============================
// COUNT TOTAL QR CODES
// ==============================
$totalEmployee = 0;
$resTotal = $con->query("SELECT COUNT(*) as total FROM qrcode");
if ($resTotal) {
    $rowTotal = $resTotal->fetch_assoc();
    $totalEmployee = (int)$rowTotal['total'];
}

// ==============================
// FETCH QR CODES FOR DROPDOWN
// ==============================
$qrcodes = [];
$resQR = $con->query("SELECT id, qrname FROM qrcode ORDER BY qrname ASC");
if ($resQR && $resQR->num_rows > 0) {
    while ($r = $resQR->fetch_assoc()) {
        $qrcodes[] = $r;
    }
}

// ==============================
// FILTERS
// ==============================
$filterQrId = isset($_GET['qr_id']) ? (int)$_GET['qr_id'] : 0;
$dateFrom   = isset($_GET['from']) ? trim($_GET['from']) : '';
$dateTo     = isset($_GET['to']) ? trim($_GET['to']) : '';

// validate date format YYYY-MM-DD
function isValidDate($date) {
    return preg_match("/^\d{4}-\d{2}-\d{2}$/", $date);
}

if ($dateFrom && !isValidDate($dateFrom)) $dateFrom = '';
if ($dateTo && !isValidDate($dateTo)) $dateTo = '';

// ==============================
// BUILD HITS QUERY
// ==============================
$where  = " WHERE 1 ";
$params = [];
$types  = "";

if ($filterQrId > 0) {
    $where .= " AND qr_id = ? ";
    $params[] = $filterQrId;
    $types .= "i";
}

if ($dateFrom != '') {
    $where .= " AND datestimes >= ? ";
    $params[] = $dateFrom . " 00:00:00";
    $types .= "s";
}

if ($dateTo != '') {
    $where .= " AND datestimes <= ? ";
    $params[] = $dateTo . " 23:59:59";
    $types .= "s";
}

$sqlHits = "
    SELECT 
        qr_id,
        name,
        datestimes,
        ip_address,
        country_code,
        device_type,
        os_name,
        browser_name,
        user_agent
    FROM hits
    $where
    ORDER BY datestimes DESC
";

// ==============================
// FETCH HITS
// ==============================
$hitsData = [];

$stmt = $con->prepare($sqlHits);

if ($types !== "") {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $hitsData[] = $row;
    }
}

$stmt->close();

// ==============================
// COUNT TOTAL SCANS FOR CURRENT FILTER
// ==============================
$totalScans = count($hitsData);

// close connection later after html
?>
<!DOCTYPE html>
<html lang="en">
<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title>ALARABY TV QR CODE GENERATOR</title>

    <!-- Custom fonts for this template -->
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">

    <!-- Custom styles for this template -->
    <link href="css/sb-admin-2.min.css" rel="stylesheet">

    <!-- Custom styles for this page -->
    <link href="vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">

    <link rel="icon" type="image/png" href="images/icons/favicon.png"/>

</head>

<body id="page-top">

<div id="wrapper">

    <!-- Sidebar -->
    <ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

        <hr class="sidebar-divider my-0">

        <hr class="sidebar-divider">

        <div class="sidebar-heading">
            QR Code
        </div>

        <li class="nav-item active">
            <a class="nav-link" href="#" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="true"
               aria-controls="collapseTwo">
                <i class="fas fa-fw fa-info"></i>
                <span>Info Editor</span>
            </a>
            <div id="collapseTwo" class="collapse show" aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <h6 class="collapse-header">Edit</h6>
                    <a class="collapse-item" href="home.php">Home</a>
                    <a class="collapse-item" href="generate_qrcode.php">Generate QR-Code</a>
                    <a class="collapse-item active" href="hits.php">Hits</a>
                </div>
            </div>
        </li>

        <hr class="sidebar-divider">

    </ul>
    <!-- End of Sidebar -->

    <div id="content-wrapper" class="d-flex flex-column">

        <div id="content">

            <!-- Topbar -->
            <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                <form class="form-inline">
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>
                </form>

                <ul class="navbar-nav ml-auto">
                    <div class="topbar-divider d-none d-sm-block"></div>

                    <li class="nav-item dropdown no-arrow">
                        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
                           data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <span class="mr-2 d-none d-lg-inline text-gray-600 small"><?php echo htmlspecialchars($_SESSION['userEmail']); ?></span>
                            <img class="img-profile rounded-circle" src="img/undraw_profile.svg">
                        </a>
                        <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
                             aria-labelledby="userDropdown">
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#logoutModal">
                                <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                                Logout
                            </a>
                        </div>
                    </li>
                </ul>

            </nav>
            <!-- End of Topbar -->

            <div class="container-fluid">

                <h1 class="h3 mb-2 text-gray-800">QR Hits Analytics</h1>
                <p class="mb-4">Search scans by QR Code + Date Range and export reports.</p>

                <div class="row">

                    <!-- Total QR Codes -->
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-primary shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            Total QR Codes
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $totalEmployee; ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-qrcode fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Total Scans -->
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-success shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            Total Scans (Filtered)
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $totalScans; ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <!-- FILTER FORM -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Search / Filter</h6>
                    </div>
                    <div class="card-body">
                        <form method="GET" action="hits.php" class="row">

                            <div class="col-md-4 mb-2">
                                <label><b>Select QR Code</b></label>
                                <select name="qr_id" class="form-control">
                                    <option value="0">All QR Codes</option>
                                    <?php foreach ($qrcodes as $qr): ?>
                                        <option value="<?php echo (int)$qr['id']; ?>"
                                            <?php echo ($filterQrId == (int)$qr['id']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($qr['qrname']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <div class="col-md-3 mb-2">
                                <label><b>Date From</b></label>
                                <input type="date" name="from" value="<?php echo htmlspecialchars($dateFrom); ?>" class="form-control">
                            </div>

                            <div class="col-md-3 mb-2">
                                <label><b>Date To</b></label>
                                <input type="date" name="to" value="<?php echo htmlspecialchars($dateTo); ?>" class="form-control">
                            </div>

                            <div class="col-md-2 mb-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary btn-block">
                                    <i class="fas fa-search"></i> Search
                                </button>
                            </div>

                            <div class="col-md-12 mt-3">
                                <?php
                                // Build export query string
                                $qs = "qr_id=" . urlencode($filterQrId) . "&from=" . urlencode($dateFrom) . "&to=" . urlencode($dateTo);
                                ?>
                                <a href="hits_export_excel.php?<?php echo $qs; ?>" class="btn btn-success">
                                    <i class="fas fa-file-excel"></i> Export Excel
                                </a>

                                <a href="hits_export_pdf.php?<?php echo $qs; ?>" class="btn btn-danger">
                                    <i class="fas fa-file-pdf"></i> Export PDF
                                </a>

                                <a href="hits.php" class="btn btn-secondary">
                                    <i class="fas fa-sync"></i> Reset
                                </a>
                            </div>

                        </form>
                    </div>
                </div>

                <!-- DATA TABLE -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">QR Scan Logs</h6>
                    </div>
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                <thead>
                                <tr>
                                    <th>QR Name</th>
                                    <th>DateTime</th>
                                    <th>Country</th>
                                    <th>Device</th>
                                    <th>OS</th>
                                    <th>Browser</th>
                                    <th>IP</th>
                                </tr>
                                </thead>

                                <tfoot>
                                <tr>
                                    <th>QR Name</th>
                                    <th>DateTime</th>
                                    <th>Country</th>
                                    <th>Device</th>
                                    <th>OS</th>
                                    <th>Browser</th>
                                    <th>IP</th>
                                </tr>
                                </tfoot>

                                <tbody>
                                <?php foreach ($hitsData as $row): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($row['name']); ?></td>
                                        <td><?php echo htmlspecialchars($row['datestimes']); ?></td>
                                        <td><?php echo htmlspecialchars($row['country_code']); ?></td>
                                        <td><?php echo htmlspecialchars($row['device_type']); ?></td>
                                        <td><?php echo htmlspecialchars($row['os_name']); ?></td>
                                        <td><?php echo htmlspecialchars($row['browser_name']); ?></td>
                                        <td><?php echo htmlspecialchars($row['ip_address']); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>

                            </table>
                        </div>

                    </div>
                </div>

            </div>
            <!-- /.container-fluid -->

        </div>
        <!-- End of Main Content -->

        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Concept & Develop By Tahir Hafeez</span>
                </div>
            </div>
        </footer>

    </div>
</div>

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>

<!-- Logout Modal-->
<div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
            <div class="modal-footer">
                <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                <a class="btn btn-primary" href="logout.php">Logout</a>
            </div>
        </div>
    </div>
</div>

<!-- JS -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="vendor/jquery-easing/jquery.easing.min.js"></script>
<script src="js/sb-admin-2.min.js"></script>

<!-- DataTables -->
<script src="vendor/datatables/jquery.dataTables.min.js"></script>
<script src="vendor/datatables/dataTables.bootstrap4.min.js"></script>
<script src="js/demo/datatables-demo.js"></script>

</body>
</html>

<?php
mysqli_close($con);
?>
