<?php
session_start();
header_remove("X-Powered-By");

$con = mysqli_connect("localhost","iaosr874_newWeb","kkrNvZVT57-ru3~]","iaosr874_qrCode");
if (!$con) {
    die("DB Connection Failed!");
}

if (!isset($_SESSION['userEmail']) || $_SESSION['userEmail'] == '') {
    header("Location:index.php");
    exit;
}

$userEmail = $_SESSION['userEmail'];
$stmt = $con->prepare("SELECT userType FROM users WHERE userEmail=? LIMIT 1");
$stmt->bind_param("s", $userEmail);
$stmt->execute();
$stmt->bind_result($currentUser);
$stmt->fetch();
$stmt->close();

if (!($currentUser == "Admin" || $currentUser == "editor")) {
    header("Location:index.php");
    exit;
}

// Filters
$filterQrId = isset($_GET['qr_id']) ? (int)$_GET['qr_id'] : 0;
$dateFrom   = isset($_GET['from']) ? trim($_GET['from']) : '';
$dateTo     = isset($_GET['to']) ? trim($_GET['to']) : '';

function isValidDate($date) {
    return preg_match("/^\d{4}-\d{2}-\d{2}$/", $date);
}
if ($dateFrom && !isValidDate($dateFrom)) $dateFrom = '';
if ($dateTo && !isValidDate($dateTo)) $dateTo = '';

// Build query
$where  = " WHERE 1 ";
$params = [];
$types  = "";

if ($filterQrId > 0) {
    $where .= " AND qr_id = ? ";
    $params[] = $filterQrId;
    $types .= "i";
}

if ($dateFrom != '') {
    $where .= " AND datestimes >= ? ";
    $params[] = $dateFrom . " 00:00:00";
    $types .= "s";
}

if ($dateTo != '') {
    $where .= " AND datestimes <= ? ";
    $params[] = $dateTo . " 23:59:59";
    $types .= "s";
}

$sql = "
    SELECT 
        name,
        datestimes,
        country_code,
        device_type,
        os_name,
        browser_name,
        ip_address
    FROM hits
    $where
    ORDER BY datestimes DESC
";

$stmt = $con->prepare($sql);
if ($types !== "") {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

// CSV headers download
$filename = "QR_Hits_" . date("Y-m-d_His") . ".csv";
header("Content-Type: text/csv; charset=utf-8");
header("Content-Disposition: attachment; filename=$filename");

$output = fopen("php://output", "w");

// Column titles
fputcsv($output, ["QR Name", "DateTime", "Country", "Device", "OS", "Browser", "IP"]);

while ($row = $result->fetch_assoc()) {
    fputcsv($output, [
        $row['name'],
        $row['datestimes'],
        $row['country_code'],
        $row['device_type'],
        $row['os_name'],
        $row['browser_name'],
        $row['ip_address']
    ]);
}

fclose($output);
$stmt->close();
mysqli_close($con);
exit;
