<?php

header_remove("X-Powered-By");

require_once 'phpqrcode/qrlib.php';
require_once("class.cryptor.php");

// ==============================
// DB CONNECTION
// ==============================
$con = mysqli_connect("localhost","iaosr874_newWeb","kkrNvZVT57-ru3~]","iaosr874_qrCode");

if (!$con) {
    die("DB Connection Failed!");
}

// ==============================
// SAFE GET
// ==============================
$qrcode = isset($_GET['qrID']) ? $_GET['qrID'] : '';
$qrcode = htmlentities($qrcode);
$qrcode = mysqli_real_escape_string($con, $qrcode);

// ==============================
// DECRYPT QR ID
// ==============================
$crypt = new Cryptor();
$decryptedid = $crypt->decryptId($qrcode);

$decryptedid = (int)$decryptedid;
if ($decryptedid <= 0) {
    header("Location: not_found.php");
    exit;
}

// ==============================
// DEVICE + OS + BROWSER DETECT
// ==============================
function getDeviceType($ua) {
    $ua = strtolower($ua);
    if (preg_match('/tablet|ipad|playbook|silk/i', $ua)) return "Tablet";
    if (preg_match('/mobi|android|iphone|ipod/i', $ua)) return "Mobile";
    return "Desktop";
}

function getOS($ua) {
    $ua = strtolower($ua);

    if (strpos($ua, 'windows nt 10') !== false) return "Windows 10";
    if (strpos($ua, 'windows nt 11') !== false) return "Windows 11";
    if (strpos($ua, 'windows') !== false) return "Windows";
    if (strpos($ua, 'mac os x') !== false) return "IOS";
    if (strpos($ua, 'android') !== false) return "Android";
    if (strpos($ua, 'iphone') !== false || strpos($ua, 'ipad') !== false) return "iOS";
    if (strpos($ua, 'linux') !== false) return "Linux";

    return "Unknown";
}

function getBrowser($ua) {
    $ua = strtolower($ua);

    if (strpos($ua, 'edg') !== false) return "Edge";
    if (strpos($ua, 'chrome') !== false) return "Chrome";
    if (strpos($ua, 'safari') !== false && strpos($ua, 'chrome') === false) return "Safari";
    if (strpos($ua, 'firefox') !== false) return "Firefox";
    if (strpos($ua, 'opera') !== false || strpos($ua, 'opr') !== false) return "Opera";

    return "Unknown";
}

// ==============================
// GET REAL USER IP ADDRESS ✅
// ==============================
function getUserIP() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) return $_SERVER['HTTP_CF_CONNECTING_IP']; // Cloudflare
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return trim(explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0]);
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
    return $_SERVER['REMOTE_ADDR'] ?? "Unknown";
}

// ==============================
// GET COUNTRY CODE ✅ (Cloudflare + API Fallback)
// ==============================
function getCountryCodeByIP($ip) {

    // ✅ 1) If Cloudflare is active, take perfect country code directly
    if (!empty($_SERVER['HTTP_CF_IPCOUNTRY'])) {
        return $_SERVER['HTTP_CF_IPCOUNTRY']; // QA, PK, TR...
    }

    // ✅ 2) If IP is local/private → no country exists
    if (
        filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) === false
    ) {
        return "Local";
    }

    // ✅ 3) API Lookup (Public IP)
    $url = "http://ip-api.com/json/" . $ip . "?fields=status,countryCode";

    $json = @file_get_contents($url);
    if (!$json) return "Unknown";

    $data = json_decode($json, true);

    if (!isset($data['status']) || $data['status'] !== 'success') {
        return "Unknown";
    }

    return $data['countryCode'] ?? "Unknown";
}

// ==============================
// USER AGENT + ANALYTICS DATA
// ==============================
$userAgent  = $_SERVER['HTTP_USER_AGENT'] ?? '';
$ipAddress  = getUserIP();
$country    = getCountryCodeByIP($ipAddress);
$deviceType = getDeviceType($userAgent);
$osName     = getOS($userAgent);
$browser    = getBrowser($userAgent);

// ==============================
// GET QR DATA
// ==============================
$stmt = $con->prepare("SELECT qrlink, totalhits, qrname FROM qrcode WHERE id=? LIMIT 1");
$stmt->bind_param("i", $decryptedid);
$stmt->execute();
$stmt->bind_result($qrLink, $totalHits, $qrName);
$stmt->fetch();
$stmt->close();

if (empty($qrLink)) {
    header("Location: not_found.php");
    exit;
}

// ==============================
// UPDATE TOTAL HITS
// ==============================
$totalHits = (int)$totalHits + 1;

$stmt = $con->prepare("UPDATE qrcode SET totalhits=? WHERE id=?");
$stmt->bind_param("ii", $totalHits, $decryptedid);
$stmt->execute();
$stmt->close();

// ==============================
// INSERT FULL HIT LOG ✅
// ==============================
$stmt = $con->prepare("
    INSERT INTO hits (qr_id, name, datestimes, total_hits, ip_address, country_code, device_type, os_name, browser_name, user_agent)
    VALUES (?, ?, NOW(), 1, ?, ?, ?, ?, ?, ?)
");

$stmt->bind_param(
    "isssssss",
    $decryptedid,
    $qrName,
    $ipAddress,
    $country,
    $deviceType,
    $osName,
    $browser,
    $userAgent
);

$stmt->execute();
$stmt->close();

// ==============================
// REDIRECT TO QR LINK
// ==============================
header("Location: " . $qrLink);
exit;

?>
