<?php
ob_start();
include "layout.php";
require_once "db.php";

if (!in_array($role, ['admin', 'memberController'])) {
    die("Access denied.");
}

$pdo = get_db();
$message = "";

// --------------- ADD NEW SERVICE ---------------
if ($_SERVER["REQUEST_METHOD"] === "POST" && $_POST['action'] === 'add') {
    $name = trim($_POST['service_name']);
    $desc = trim($_POST['description']);
    $charge = (float)$_POST['service_charge'];

    try {
        $stmt = $pdo->prepare("INSERT INTO services (service_name, description, service_charge, status) VALUES (?, ?, ?, 'active')");
        $stmt->execute([$name, $desc, $charge]);
        $message = "✅ Service added successfully!";
    } catch (PDOException $e) {
        $message = "❌ Error: " . $e->getMessage();
    }
}

// --------------- UPDATE SERVICES ---------------
if ($_SERVER["REQUEST_METHOD"] === "POST" && $_POST['action'] === 'update') {
    for ($i = 0; $i < count($_POST['id']); $i++) {
        $id = $_POST['id'][$i];
        $name = $_POST['service_name'][$i];
        $desc = $_POST['description'][$i];
        $charge = (float)$_POST['service_charge'][$i];
        $status = $_POST['status'][$i];

        $stmt = $pdo->prepare("UPDATE services SET service_name=?, description=?, service_charge=?, status=? WHERE id=?");
        $stmt->execute([$name, $desc, $charge, $status, $id]);
    }
    header("Location: services_controller.php?status=success");
    exit;
}

// --------------- DELETE SERVICE ---------------
if (isset($_POST['delete_id']) && is_numeric($_POST['delete_id'])) {
    $deleteId = (int)$_POST['delete_id'];
    $pdo->prepare("DELETE FROM services WHERE id=?")->execute([$deleteId]);
    header("Location: services_controller.php?deleted=1");
    exit;
}

// --------------- FETCH SERVICES ---------------
$stmt = $pdo->query("SELECT * FROM services ORDER BY id ASC");
$services = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Services Controller</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
body { background:#064635; color:white; padding:20px; font-family:sans-serif; }
.card { background:rgba(255,255,255,0.1); border:none; border-radius:15px; padding:20px; }
.form-control, .form-select { background:rgba(255,255,255,0.9); color:black; border:none; text-align:center; }
.btn-light { color:#064635; font-weight:600; }
.btn-warning { background:#f4c542; border:none; color:#064635; font-weight:600; }
</style>
</head>
<body>

<div class="container-fluid" style="margin-top:50px;">
  <h3 class="mb-4"><i class="bi bi-gear-wide-connected"></i> Services Controller</h3>

  <?php if(isset($_GET['status']) && $_GET['status']=='success'): ?>
    <div class="alert alert-success">✅ Services updated successfully!</div>
  <?php elseif(isset($_GET['deleted'])): ?>
    <div class="alert alert-info">🗑️ Service deleted successfully!</div>
  <?php elseif($message): ?>
    <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
  <?php endif; ?>

  <!-- ADD NEW SERVICE -->
  <div class="card mb-4">
    <h5 class="text-white"><i class="bi bi-plus-circle"></i> Add New Service</h5>
    <form method="POST">
      <input type="hidden" name="action" value="add">
      <div class="row mb-3">
        <div class="col-md-3">
          <label class="text-white">Service Name</label>
          <input type="text" class="form-control" name="service_name" placeholder="e.g., Nikah Service" required>
        </div>
        <div class="col-md-5">
          <label class="text-white">Description</label>
          <input type="text" class="form-control" name="description" placeholder="Short description">
        </div>
        <div class="col-md-2">
          <label class="text-white">Charge (CAD)</label>
          <input type="number" step="0.01" class="form-control" name="service_charge" required>
        </div>
        <div class="col-md-2 d-flex align-items-end">
          <button class="btn btn-light w-100"><i class="bi bi-plus-circle"></i> Add</button>
        </div>
      </div>
    </form>
  </div>

  <!-- EDIT SERVICES -->
  <div class="card p-3 shadow">
    <form method="POST">
      <input type="hidden" name="action" value="update">
      <div class="table-responsive">
        <table class="table table-striped text-center align-middle">
          <thead class="table-dark">
            <tr>
              <th>ID</th>
              <th>Service</th>
              <th>Description</th>
              <th>Charge (CAD)</th>
              <th>Status</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($services as $s): ?>
              <tr>
                <td><?= htmlspecialchars($s['id']) ?></td>
                <td><input class="form-control text-dark" name="service_name[]" value="<?= htmlspecialchars($s['service_name']) ?>" style="width:100%"></td>
                <td><input class="form-control text-dark" name="description[]" value="<?= htmlspecialchars($s['description']) ?>" style="width:100%"></td>
                <td><input type="number" step="0.01" class="form-control text-dark" name="service_charge[]" value="<?= htmlspecialchars($s['service_charge']) ?>" style="width:100%"></td>
                <td>
                  <select class="form-select" name="status[]" style="width:100%">
                    <option value="active" <?= $s['status']=='active'?'selected':'' ?>>Active</option>
                    <option value="inactive" <?= $s['status']=='inactive'?'selected':'' ?>>Inactive</option>
                  </select>
                </td>
                <td>
                  <button type="button" class="btn btn-danger btn-sm delete-btn" data-id="<?= $s['id'] ?>" data-name="<?= htmlspecialchars($s['service_name']) ?>">
                    <i class="bi bi-trash"></i>
                  </button>
                </td>
                <input type="hidden" name="id[]" value="<?= htmlspecialchars($s['id']) ?>">
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="text-end">
        <button class="btn btn-warning mt-3"><i class="bi bi-save"></i> Save Changes</button>
      </div>
    </form>
  </div>
</div>

<!-- Hidden Delete Form -->
<form method="POST" id="deleteForm" style="display:none;">
  <input type="hidden" name="delete_id" id="delete_id">
</form>

<script>
document.querySelectorAll(".delete-btn").forEach(btn => {
  btn.addEventListener("click", function() {
    const id = this.dataset.id;
    const name = this.dataset.name;
    Swal.fire({
      title: `Delete service "${name}"?`,
      text: "This action cannot be undone!",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#d33",
      cancelButtonColor: "#3085d6",
      confirmButtonText: "Yes, delete it!",
      background: "#fff",
      color: "#064635"
    }).then((result) => {
      if (result.isConfirmed) {
        document.getElementById("delete_id").value = id;
        document.getElementById("deleteForm").submit();
      }
    });
  });
});
</script>

</body>
</html>
