<?php
require_once "admin_pannel/db.php"; // ✅ Make sure $pdo exists
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>About Us | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Custom CSS -->
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>

<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<!-- ================= NAVBAR ================= -->
<?php include 'header.php'; ?>


<?php
// ✅ Fetch About Us page header settings
$settings = $pdo->query("SELECT * FROM about_page_settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
?>


<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5"
style="background:url('<?= htmlspecialchars($settings['bg_image'] ?? '') ?>') center/cover no-repeat;">

  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>

  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">
      <?= htmlspecialchars($settings['page_title'] ?? 'About Us') ?>
    </h1>

    <p class="lead">
      <?= htmlspecialchars($settings['page_subtitle'] ?? '') ?>
    </p>
  </div>

</section>


<!-- ================= ABOUT US ================= -->
<?php
// ✅ Fetch all headings
$headings = $pdo->query("SELECT * FROM about_headings ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// ✅ Fetch all paragraphs
$para_stmt = $pdo->query("SELECT * FROM about_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// ✅ Group paragraphs by heading_id
$paras = [];
foreach ($para_stmt as $p) {
    $paras[$p['heading_id']][] = $p;
}
?>

<!-- ================= ABOUT US (DYNAMIC) ================= -->
<section class="about-section py-5">
  <div class="container-xl">

    <?php foreach ($headings as $h): ?>
      <div class="mb-5">

        <!-- ✅ Heading Title -->
        <h3 class="greet-title greet-title-in text-white fw-bold mb-3">
          <?= htmlspecialchars($h["heading_text"]) ?>
        </h3>

        <!-- ✅ Paragraphs Under Heading -->
        <?php if (!empty($paras[$h['id']])): ?>
          <?php foreach ($paras[$h['id']] as $p): ?>
            <p><?= nl2br(htmlspecialchars($p["paragraph_text"])) ?></p>
          <?php endforeach; ?>
        <?php endif; ?>

      </div>
    <?php endforeach; ?>

    <!-- ✅ Static Bylaw Download Button -->
    <br>
    <div class="text-center">
      <a href="doc/IAOS-Constitution-1998.pdf" class="btn-bylaw" download>
        <i class="bi bi-file-earmark-arrow-down me-2"></i> Download Bylaw (PDF)
      </a>
    </div>

  </div>
</section>


<!-- ================= BOARD OF DIRECTORS ================= -->
<?php
$members = $pdo->query("SELECT * FROM about_members ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<section class="board-section py-5">
  <div class="container-xl">

    <h2 class="text-center mb-5 greet-title fw-bold">Board of Directors</h2>

    <div class="row g-4 justify-content-center">

      <?php foreach ($members as $m): ?>
        <div class="col-md-6 col-lg-3">
          <div class="board-member text-center h-100">

            <img src="<?= htmlspecialchars($m['image']) ?>" alt="<?= htmlspecialchars($m['name']) ?>">

            <div class="board-info">
              <h5><?= htmlspecialchars($m['name']) ?></h5>
              <span>(<?= htmlspecialchars($m['role']) ?>)</span>

              <?php if (!empty($m['email'])): ?>
                <p>
                  <a href="mailto:<?= htmlspecialchars($m['email']) ?>">
                    <?= htmlspecialchars($m['email']) ?>
                  </a>
                </p>
              <?php endif; ?>

              <?php if (!empty($m['bio'])): ?>
                <p><?= nl2br(htmlspecialchars($m['bio'])) ?></p>
              <?php endif; ?>

            </div>
          </div>
        </div>
      <?php endforeach; ?>

    </div>

  </div>
</section>


<!-- ================= MOSQUE LOCATIONS ================= -->
<?php
$mosques = $pdo->query("SELECT * FROM mosque_locations ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<section class="mosque-map py-5">
  <div class="container-xl">

    <h2 class="text-center text-white greet-title fw-bold mb-5">Our Mosque Locations</h2>

    <div class="row g-4">

      <?php foreach ($mosques as $m): ?>
        <div class="col-md-4">

          <h5 class="text-warning">
            <?= htmlspecialchars($m["mosque_name"]) ?>
          </h5>

          <p class="text-white">
            <?= htmlspecialchars($m["address"]) ?>
          </p>

          <iframe src="<?= htmlspecialchars($m["map_embed"]) ?>"></iframe>

        </div>
      <?php endforeach; ?>

    </div>

  </div>
</section>


<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<!-- ================= FOOTER ================= -->
<?php include 'footer.php'; ?>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Fixed Donate Button (Mobile Only) -->
<a href="#donate" class="mobile-donate-btn">Donate Now</a>

<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');

window.addEventListener('scroll', () => {
  if (window.scrollY > lastScrollY) {
    donateBtn.style.opacity = '0';
  } else {
    donateBtn.style.opacity = '1';
  }
  lastScrollY = window.scrollY;
});
</script>

</body>
</html>
