<?php
ob_start();
require_once "db.php";

/* -----------------------------------------
   GLOBAL PAGE SETTINGS (header info)
----------------------------------------- */
$set = $pdo->query("SELECT * FROM iaos_careers_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if (!$set) {
  $pdo->exec("
    INSERT INTO iaos_careers_settings (id,page_title,page_subtitle,bg_image)
    VALUES (1,'Career Opportunities',
    'Join our mission to educate and inspire the next generation – In sha Allah.',
    'images/banner3.jpg')
  ");
  $set = $pdo->query("SELECT * FROM iaos_careers_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
}

/* -----------------------------------------
   LOAD JOBS + SELECT CURRENT JOB
----------------------------------------- */
$jobs = $pdo->query("SELECT * FROM iaos_careers_jobs ORDER BY position ASC,id ASC")->fetchAll(PDO::FETCH_ASSOC);

$selectedJobId = isset($_GET['id']) ? (int)$_GET['id'] : (count($jobs) ? (int)$jobs[0]['id'] : 0);

$job = null;
if ($selectedJobId) {
  $stmt = $pdo->prepare("SELECT * FROM iaos_careers_jobs WHERE id=?");
  $stmt->execute([$selectedJobId]);
  $job = $stmt->fetch(PDO::FETCH_ASSOC);
}

/* -----------------------------------------
   LOAD JOB-LEVEL CONTENT
----------------------------------------- */
$reqs = [];
$heads = [];
$paras = [];

if ($job) {

  /* ✅ Requirements per job */
  $stmt = $pdo->prepare("SELECT * FROM iaos_careers_requirements WHERE job_id=? ORDER BY position ASC,id ASC");
  $stmt->execute([$job['id']]);
  $reqs = $stmt->fetchAll(PDO::FETCH_ASSOC);

  /* ✅ Headings per job */
  $stmt = $pdo->prepare("SELECT * FROM iaos_careers_headings WHERE job_id=? ORDER BY position ASC,id ASC");
  $stmt->execute([$job['id']]);
  $heads = $stmt->fetchAll(PDO::FETCH_ASSOC);

  /* ✅ Paragraphs per heading */
  if ($heads) {
    $headIds = array_column($heads, 'id');
    $in = implode(',', array_fill(0, count($headIds), '?'));

    $stmt = $pdo->prepare("
      SELECT * FROM iaos_careers_paragraphs
      WHERE job_id=? AND heading_id IN ($in)
      ORDER BY position ASC,id ASC
    ");

    $stmt->execute(array_merge([$job['id']], $headIds));
    $allParas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($allParas as $row) {
      $paras[$row['heading_id']][] = $row;
    }
  }
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Careers | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;padding:12px 20px;display:block;text-decoration:none;border-bottom:1px solid #2f343a;}
.admin-sidebar a:hover,.admin-sidebar a.active{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
.section-card{border-radius:10px;}
.section-title{font-weight:700;font-size:1.2rem;margin-bottom:15px;}
.small-note{font-size:.875rem;color:#6c757d;}
</style>
</head>

<body>

<div class="admin-wrapper">
<?php include "sidebar.php"; ?>

<div class="admin-content">

<h3 class="mb-4">⚙️ Manage Career Opportunities</h3>

<?php if(isset($_GET['saved'])): ?>
  <div class="alert alert-success">✅ Saved successfully!</div>
<?php endif; ?>

<!-- --------------------------------------------------
     GLOBAL HEADER SETTINGS
--------------------------------------------------- -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">🖼️ Page Header (Global)</div>

  <form action="save_careers.php" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="action" value="save_settings">

    <label class="fw-bold mb-1">Page Title</label>
    <input type="text" name="page_title" class="form-control mb-3"
           value="<?= htmlspecialchars($set['page_title']) ?>" required>

    <label class="fw-bold mb-1">Page Subtitle</label>
    <textarea name="page_subtitle" class="form-control mb-3" required><?= htmlspecialchars($set['page_subtitle']) ?></textarea>

    <label class="fw-bold mb-1">Header Background Image</label>
    <input type="file" name="bg_image" class="form-control mb-2" accept="image/*">

    <?php if(!empty($set['bg_image'])): ?>
      <img src="../<?= htmlspecialchars($set['bg_image']) ?>" style="max-width:240px;border-radius:8px;">
    <?php endif; ?>

    <button class="btn btn-primary mt-3">Save Header</button>
  </form>
</div>

<!-- --------------------------------------------------
     JOB SELECTOR + ADD NEW JOB
--------------------------------------------------- -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">📌 Select / Add Job</div>

  <!-- Select Job -->
  <form method="GET" class="d-flex gap-2 mb-3">
    <select name="id" class="form-select" onchange="this.form.submit()">
      <?php foreach($jobs as $j): ?>
        <option value="<?= $j['id'] ?>" <?= $j['id']==$selectedJobId?'selected':'' ?>>
          <?= htmlspecialchars($j['intro_heading']) ?>
        </option>
      <?php endforeach; ?>
    </select>
    <a href="admin_careers.php" class="btn btn-outline-secondary">Reset</a>
  </form>

  <!-- Add Job -->
  <form action="save_careers.php" method="POST" class="row g-2">
    <input type="hidden" name="action" value="add_job">

    <div class="col-md-6">
      <label class="fw-bold mb-1">Job Title (Intro Heading)</label>
      <input type="text" name="intro_heading" class="form-control" required>
    </div>

    <div class="col-md-6">
      <label class="fw-bold mb-1">Apply Email</label>
      <input type="email" name="apply_email" class="form-control" required>
    </div>

    <div class="col-12">
      <label class="fw-bold mb-1">Intro Text</label>
      <textarea name="intro_text" class="form-control" rows="3" required></textarea>
    </div>

    <div class="col-md-6">
      <label class="fw-bold mb-1">Apply Deadline</label>
      <input type="text" name="apply_deadline" class="form-control" required>
    </div>

    <div class="col-md-6 d-flex align-items-end">
      <button class="btn btn-success">Add Job</button>
    </div>
  </form>
</div>

<?php if ($job): ?>

<!-- --------------------------------------------------
     JOB INTRO EDIT
--------------------------------------------------- -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">📝 Project Overview (Intro)</div>

  <form action="save_careers.php" method="POST">
    <input type="hidden" name="action" value="save_job_intro">
    <input type="hidden" name="job_id" value="<?= $job['id'] ?>">

    <label class="fw-bold mb-1">Intro Heading</label>
    <input type="text" name="intro_heading" class="form-control mb-2"
           value="<?= htmlspecialchars($job['intro_heading']) ?>" required>

    <label class="fw-bold mb-1">Intro Text</label>
    <textarea name="intro_text" class="form-control mb-2" rows="5" required><?= htmlspecialchars($job['intro_text']) ?></textarea>

    <div class="row g-2">
      <div class="col-md-6">
        <label class="fw-bold mb-1">Apply Email</label>
        <input type="email" name="apply_email" class="form-control"
               value="<?= htmlspecialchars($job['apply_email']) ?>" required>
      </div>
      <div class="col-md-6">
        <label class="fw-bold mb-1">Apply Deadline</label>
        <input type="text" name="apply_deadline" class="form-control"
               value="<?= htmlspecialchars($job['apply_deadline']) ?>" required>
      </div>
    </div>

    <button class="btn btn-primary mt-3">Save Intro</button>
  </form>

  <form action="save_careers.php" method="POST" class="mt-2"
        onsubmit="return confirm('Delete this job? All its data will be removed.')">
    <input type="hidden" name="action" value="delete_job">
    <input type="hidden" name="job_id" value="<?= $job['id'] ?>">
    <button class="btn btn-danger">Delete Job</button>
  </form>
</div>

<!-- --------------------------------------------------
     REQUIREMENTS
--------------------------------------------------- -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">✅ Candidate Qualifications</div>

  <!-- Add Requirement -->
  <form action="save_careers.php" method="POST" class="mb-3">
    <input type="hidden" name="action" value="add_requirement">
    <input type="hidden" name="job_id" value="<?= $job['id'] ?>">
    <input type="text" name="item_text" class="form-control mb-2" placeholder="Add requirement..." required>
    <button class="btn btn-secondary btn-sm">Add</button>
  </form>

  <!-- Requirement List -->
  <?php foreach($reqs as $r): ?>
    <div class="bg-white border rounded p-3 mb-2">
      <form action="save_careers.php" method="POST" class="d-flex gap-2">
        <input type="hidden" name="action" value="update_requirement">
        <input type="hidden" name="job_id" value="<?= $job['id'] ?>">
        <input type="hidden" name="req_id" value="<?= $r['id'] ?>">

        <input type="text" name="item_text" class="form-control"
               value="<?= htmlspecialchars($r['item_text']) ?>" required>

        <button class="btn btn-success btn-sm">Update</button>

        <button formaction="save_careers.php"
                name="action" value="delete_requirement"
                onclick="return confirm('Delete this requirement?')"
                class="btn btn-danger btn-sm">Delete</button>
      </form>
    </div>
  <?php endforeach; ?>
</div>

<!-- --------------------------------------------------
     EXTRA HEADINGS + PARAGRAPHS
--------------------------------------------------- -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">➕ Add New Heading</div>

  <form action="save_careers.php" method="POST">
    <input type="hidden" name="action" value="add_heading">
    <input type="hidden" name="job_id" value="<?= $job['id'] ?>">

    <label class="fw-bold mb-1">Heading Text</label>
    <input type="text" name="heading_text" class="form-control mb-2" required>

    <button class="btn btn-success">Add Heading</button>
  </form>
</div>

<!-- List Headings + Paragraphs -->
<?php foreach($heads as $h): ?>
  <div class="card p-4 shadow-sm mb-4 section-card">
    <div class="d-flex justify-content-between mb-3">
      <div class="section-title">📘 <?= htmlspecialchars($h['heading_text']) ?></div>

      <form action="save_careers.php" method="POST"
            onsubmit="return confirm('Delete this heading? All its paragraphs will be removed.')">
        <input type="hidden" name="action" value="delete_heading">
        <input type="hidden" name="job_id" value="<?= $job['id'] ?>">
        <input type="hidden" name="heading_id" value="<?= $h['id'] ?>">
        <button class="btn btn-danger btn-sm">Delete</button>
      </form>
    </div>

    <!-- Add paragraph under heading -->
    <form action="save_careers.php" method="POST" class="mb-3">
      <input type="hidden" name="action" value="add_paragraph">
      <input type="hidden" name="job_id" value="<?= $job['id'] ?>">
      <input type="hidden" name="heading_id" value="<?= $h['id'] ?>">

      <textarea name="para_text" class="form-control mb-2" placeholder="Write paragraph..." required></textarea>
      <button class="btn btn-secondary btn-sm">Add Paragraph</button>
    </form>

    <!-- Existing paragraphs -->
    <?php if (!empty($paras[$h['id']])): ?>
      <?php foreach($paras[$h['id']] as $p): ?>
        <div class="bg-white border rounded p-3 mb-2">
          <form action="save_careers.php" method="POST">
            <input type="hidden" name="action" value="update_paragraph">
            <input type="hidden" name="job_id" value="<?= $job['id'] ?>">
            <input type="hidden" name="para_id" value="<?= $p['id'] ?>">

            <textarea name="para_text" class="form-control mb-2" required><?= htmlspecialchars($p['para_text']) ?></textarea>
            <button class="btn btn-success btn-sm">Update</button>

            <button formaction="save_careers.php" name="action" value="delete_paragraph"
                    onclick="return confirm('Delete this paragraph?')"
                    class="btn btn-danger btn-sm float-end">Delete</button>
          </form>
        </div>
      <?php endforeach; ?>
    <?php endif; ?>
  </div>
<?php endforeach; ?>

<?php endif; ?>

</div></div>
</body>
</html>
