<?php
ob_start();
require_once "db.php";

/* ---------------------------
   LOAD PAGE HEADER SETTINGS
----------------------------*/
$settings = $pdo->query("SELECT * FROM facility_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* ---------------------------
   LOAD SECTIONS + PARAGRAPHS
----------------------------*/
$sections = $pdo->query("SELECT * FROM facility_sections ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Facility Rental Page | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; text-decoration:none; border-bottom:1px solid #2f343a; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.2rem; margin-bottom:12px; }
</style>
</head>

<body>
<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">

<h3 class="mb-4">🏢 Manage Facility Rental Page</h3>

<?php if (isset($_GET['saved'])): ?>
  <div class="alert alert-success">✅ Saved successfully</div>
<?php endif; ?>

<!-- ============================================================
     PAGE HEADER SETTINGS
===============================================================-->
<!-- ✅ PAGE HEADER SETTINGS -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">🖼️ Page Header</div>

  <form action="save_facility.php" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="action" value="save_header">

    <label class="fw-bold mb-1">Page Title</label>
    <input type="text" name="page_title" class="form-control mb-2"
           value="<?= htmlspecialchars($settings['page_title'] ?? '') ?>" required>

    <label class="fw-bold mb-1">Page Subtitle</label>
    <textarea name="page_subtitle" class="form-control mb-2" rows="3" required><?= 
      htmlspecialchars($settings['page_subtitle'] ?? '') 
    ?></textarea>

    <label class="fw-bold mb-1">Header Background Image</label>
    <input type="file" name="bg_image" class="form-control mb-2">

    <?php if (!empty($settings['bg_image'])): ?>
      <img src="../<?= htmlspecialchars($settings['bg_image']) ?>" 
           alt="Header Image" style="max-width:220px" class="rounded mt-2">
    <?php endif; ?>

    <button class="btn btn-primary mt-3">Save Header</button>
  </form>
</div>
<!-- ✅ END PAGE HEADER -->


<!-- ============================================================
     ADD NEW SECTION
===============================================================-->
<div class="card p-4 shadow-sm mb-4">
  <h4 class="section-title">➕ Add Section</h4>

  <form action="save_facility.php" method="POST">
    <input type="hidden" name="action" value="add_section">

    <label class="fw-bold">Section Title</label>
    <input type="text" name="section_title" class="form-control mb-2" required>

    <label class="fw-bold">Position</label>
    <input type="number" name="position" class="form-control mb-2" value="100">

    <button class="btn btn-primary">Add Section</button>
  </form>
</div>



<!-- ============================================================
     EXISTING SECTIONS + PARAGRAPHS
===============================================================-->
<?php foreach ($sections as $s): ?>

  <?php
  $pid = $s['id'];
  $paragraphs = $pdo->prepare("SELECT * FROM facility_paragraphs WHERE section_id=? ORDER BY position ASC");
  $paragraphs->execute([$pid]);
  $paras = $paragraphs->fetchAll(PDO::FETCH_ASSOC);
  ?>

  <div class="card p-4 shadow-sm mb-4">
    <h4 class="section-title">📌 Section: <?= htmlspecialchars($s['section_title']) ?></h4>

    <!-- EDIT SECTION -->
    <form action="save_facility.php" method="POST" class="mb-3">
      <input type="hidden" name="action" value="update_section">
      <input type="hidden" name="id" value="<?= $s['id'] ?>">

      <label class="fw-bold">Title</label>
      <input type="text" name="section_title" class="form-control mb-2"
             value="<?= htmlspecialchars($s['section_title']) ?>">

      <label class="fw-bold">Position</label>
      <input type="number" name="position" class="form-control mb-2"
             value="<?= $s['position'] ?>">

      <button class="btn btn-success btn-sm">Save Changes</button>

      <button formaction="save_facility.php" name="action" value="delete_section"
              class="btn btn-danger btn-sm float-end"
              onclick="return confirm('Delete this entire section?');">
        Delete Section
      </button>
    </form>


    <!-- ADD PARAGRAPH -->
    <div class="border p-3 rounded mb-3">
      <h6>Add Paragraph</h6>

      <form action="save_facility.php" method="POST">
        <input type="hidden" name="action" value="add_paragraph">
        <input type="hidden" name="section_id" value="<?= $s['id'] ?>">

        <label class="fw-bold">Type</label>
        <select name="type" class="form-select mb-2" required>
          <option value="heading">Heading</option>
          <option value="paragraph">Paragraph</option>
          <option value="li">List Item</option>
          <option value="html">HTML</option>
        </select>

        <label class="fw-bold">Content</label>
        <textarea name="para_text" class="form-control mb-2" rows="2" required></textarea>

        <label class="fw-bold">Position</label>
        <input type="number" name="position" class="form-control mb-2" value="100">

        <button class="btn btn-primary btn-sm">Add Paragraph</button>
      </form>
    </div>



    <!-- LIST PARAGRAPHS -->
    <?php foreach ($paras as $p): ?>
      <div class="bg-white border p-3 rounded mb-2">
        <form action="save_facility.php" method="POST">
          <input type="hidden" name="action" value="update_paragraph">
          <input type="hidden" name="id" value="<?= $p['id'] ?>">

          <label class="fw-bold">Type</label>
          <select name="type" class="form-select mb-2">
            <option value="heading"  <?= $p['type']=='heading'?'selected':'' ?>>Heading</option>
            <option value="paragraph"<?= $p['type']=='paragraph'?'selected':'' ?>>Paragraph</option>
            <option value="li"       <?= $p['type']=='li'?'selected':'' ?>>List Item</option>
            <option value="html"     <?= $p['type']=='html'?'selected':'' ?>>HTML</option>
          </select>

          <label class="fw-bold">Content</label>
          <textarea name="para_text" class="form-control mb-2" rows="2"><?= htmlspecialchars($p['para_text']) ?></textarea>

          <label class="fw-bold">Position</label>
          <input type="number" name="position" class="form-control mb-2"
                 value="<?= $p['position'] ?>">

          <button class="btn btn-success btn-sm">Update</button>

          <button formaction="save_facility.php"
                  name="action" value="delete_paragraph"
                  class="btn btn-danger btn-sm float-end"
                  onclick="return confirm('Delete this paragraph?');">
            Delete
          </button>
        </form>
      </div>
    <?php endforeach; ?>

  </div>

<?php endforeach; ?>

</div>
</div>
</body>
</html>
