<?php
ob_start();
require_once "db.php"; // ✅ same DB connection

// Load all videos
$videos = $pdo->query("SELECT * FROM iaos_videos ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Videos | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; border-bottom:1px solid #333; text-decoration:none; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.thumb-img { width:120px; height:70px; object-fit:cover; border-radius:8px; }
</style>
</head>

<body>
<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">

<h3 class="mb-4">🎬 Manage Video Gallery</h3>

<?php if(isset($_GET['added'])): ?>
<div class="alert alert-success">✅ Video added successfully.</div>
<?php endif; ?>
<?php if(isset($_GET['updated'])): ?>
<div class="alert alert-success">✅ Video updated successfully.</div>
<?php endif; ?>
<?php if(isset($_GET['deleted'])): ?>
<div class="alert alert-danger">❌ Video deleted.</div>
<?php endif; ?>

<!-- ✅ ADD NEW VIDEO -->
<div class="card p-4 mb-4 shadow-sm">
  <h5 class="mb-3">➕ Add New Video</h5>

  <form action="save_videos.php" method="POST" enctype="multipart/form-data" class="row g-3">
    <input type="hidden" name="action" value="add">

    <div class="col-md-6">
      <label class="fw-bold">Video Title</label>
      <input type="text" name="title" class="form-control" required>
    </div>

    <div class="col-md-6">
      <label class="fw-bold">YouTube URL</label>
      <input type="text" name="youtube_url" class="form-control" placeholder="https://youtube.com/watch?v=XXXX" required>
    </div>

    <div class="col-md-6">
      <label class="fw-bold">Thumbnail Image</label>
      <input type="file" name="thumbnail" accept="image/*" class="form-control">
      <small class="text-muted">Optional: If not uploaded, YouTube auto-thumbnail will be used.</small>
    </div>

    <div class="col-md-12">
      <button class="btn btn-success">Add Video</button>
    </div>
  </form>
</div>

<!-- ✅ VIDEO LIST -->
<div class="card p-4 shadow-sm">
  <h5 class="mb-3">📺 All Videos</h5>

  <table class="table table-bordered align-middle">
    <thead class="table-light">
      <tr>
        <th>ID</th>
        <th>Thumbnail</th>
        <th>Title</th>
        <th>YouTube Link</th>
        <th style="width:350px;">Actions</th>
      </tr>
    </thead>

    <tbody>
      <?php foreach ($videos as $v): ?>
      <tr>
        <td><?= $v['id'] ?></td>

        <td>
          <?php if($v['thumbnail']): ?>
            <img src="../<?= $v['thumbnail'] ?>" class="thumb-img">
          <?php else: ?>
            <span class="text-muted">No Image</span>
          <?php endif; ?>
        </td>

        <td><?= htmlspecialchars($v['title']) ?></td>

        <td>
          <a href="<?= htmlspecialchars($v['youtube_url']) ?>" target="_blank">
            <?= htmlspecialchars($v['youtube_url']) ?>
          </a>
        </td>

        <td>

          <!-- ✅ UPDATE FORM -->
          <form action="save_videos.php" method="POST" enctype="multipart/form-data" class="row g-2 mb-2">
              <input type="hidden" name="action" value="update">
              <input type="hidden" name="id" value="<?= $v['id'] ?>">

              <div class="col-md-4">
                  <input type="text" name="title" class="form-control"
                         value="<?= htmlspecialchars($v['title']) ?>">
              </div>

              <div class="col-md-4">
                  <input type="text" name="youtube_url" class="form-control"
                         value="<?= htmlspecialchars($v['youtube_url']) ?>">
              </div>

              <div class="col-md-4">
                  <input type="file" name="thumbnail" accept="image/*" class="form-control">
              </div>

              <div class="col-md-12">
                  <button class="btn btn-primary btn-sm w-100">Update</button>
              </div>
          </form>

          <!-- ✅ DELETE FORM (SEPARATE) -->
          <form action="save_videos.php" method="POST" 
                onsubmit="return confirm('Delete this video?');">
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="id" value="<?= $v['id'] ?>">
              <button class="btn btn-danger btn-sm w-100">Delete</button>
          </form>

        </td>
      </tr>

      <?php endforeach; ?>
    </tbody>
  </table>
</div>

</div>
</div>

</body>
</html>
