<?php
ob_start();
require_once "db.php";

$action = $_POST['action'] ?? '';

/* ✅ UPDATE HEADER */
if ($action === "update_header") {

    $title = $_POST['page_title'];
    $subtitle = $_POST['page_subtitle'];

    // Get old image
    $old = $pdo->query("SELECT bg_image FROM community_page_settings WHERE id=1")->fetchColumn();
    $image = $old;

    // ✅ FIXED: Upload into ../images and store "images/"
    if (!empty($_FILES['bg_image']['name'])) {

        $filename = time() . "_" . basename($_FILES['bg_image']['name']);

        // save to folder
        move_uploaded_file($_FILES['bg_image']['tmp_name'], "../images/" . $filename);

        // store relative path in DB
        $image = "images/" . $filename;
    }

    $stm = $pdo->prepare("UPDATE community_page_settings 
                          SET page_title=?, page_subtitle=?, bg_image=? 
                          WHERE id=1");
    $stm->execute([$title, $subtitle, $image]);

    header("Location: admin_community.php?saved=1");
    exit;
}

/* ✅ ADD TOPIC */
if ($action === "add_topic") {
    $stm = $pdo->prepare("INSERT INTO community_topics (topic_title, position) VALUES (?, ?)");
    $stm->execute([$_POST['topic_title'], time()]);
    header("Location: admin_community.php?saved=1");
    exit;
}

/* ✅ DELETE TOPIC */
if ($action === "delete_topic") {
    $pdo->prepare("DELETE FROM community_topics WHERE id=?")->execute([$_POST['id']]);
    header("Location: admin_community.php?saved=1");
    exit;
}

/* ✅ ADD PARAGRAPH */
if ($action === "add_para") {

    $type = $_POST['type'];
    $text = $_POST['para_text'];

    $stm = $pdo->prepare("INSERT INTO community_paragraphs (topic_id, para_text, type, position) 
                          VALUES (?, ?, ?, ?)");
    $stm->execute([$_POST['topic_id'], $text, $type, time()]);

    header("Location: admin_community.php?saved=1");
    exit;
}

/* ✅ UPDATE PARAGRAPH */
if ($action === "update_para") {

    $type = $_POST['type'];
    $text = $_POST['para_text'];

    $stm = $pdo->prepare("UPDATE community_paragraphs 
                          SET para_text=?, type=? 
                          WHERE id=?");
    $stm->execute([$text, $type, $_POST['id']]);

    header("Location: admin_community.php?saved=1");
    exit;
}

/* ✅ DELETE PARAGRAPH */
if ($action === "delete_para") {
    $pdo->prepare("DELETE FROM community_paragraphs WHERE id=?")->execute([$_POST['id']]);
    header("Location: admin_community.php?saved=1");
    exit;
}

/* ✅ UPDATE INTRODUCTION SECTION */
if ($action === "update_intro") {

    // old file
    $oldFile = $pdo->query("SELECT download_file FROM community_intro_settings WHERE id=1")->fetchColumn();
    $file = $oldFile;

    // ✅ keep PDFs in /doc
    if (!empty($_FILES['download_file']['name'])) {

        $filename = time() . "_" . basename($_FILES['download_file']['name']);

        // save inside ../doc folder
        move_uploaded_file($_FILES['download_file']['tmp_name'], "../doc/" . $filename);

        // store relative path
        $file = "doc/" . $filename;
    }

    $stm = $pdo->prepare("UPDATE community_intro_settings 
                          SET download_text=?, download_file=?, intro_paragraph=? 
                          WHERE id=1");
    $stm->execute([
        $_POST['download_text'],
        $file,
        $_POST['intro_paragraph']
    ]);

    header("Location: admin_community.php?saved=1");
    exit;
}

?>
