<?php
ob_start();
require_once "db.php";

$action = $_POST['action'] ?? '';

function upload_image($field, $diskDir="../uploads", $publicPrefix="uploads") {
  if (empty($_FILES[$field]['name'])) return null;
  if (!is_dir($diskDir)) { @mkdir($diskDir, 0775, true); }
  $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));
  if (!in_array($ext, ['jpg','jpeg','png','webp'])) return null;
  $filename = time() . "_" . preg_replace("/[^a-zA-Z0-9_\.-]/", "_", $_FILES[$field]['name']);
  $fullPath = rtrim($diskDir, "/") . "/" . $filename;
  if (!move_uploaded_file($_FILES[$field]['tmp_name'], $fullPath)) return null;
  return rtrim($publicPrefix, "/") . "/" . $filename;
}

/* ---------- SETTINGS ---------- */
if ($action === 'save_settings') {
  $title = $_POST['page_title'] ?? '';
  $subtitle = $_POST['page_subtitle'] ?? '';

  $old_bg = $pdo->query("SELECT bg_image FROM iaos_contact_settings WHERE id=1")->fetchColumn();
  $bg = $old_bg ?: 'images/banner5.jpg';
  $new = upload_image('bg_image', '../uploads', 'uploads');
  if ($new) $bg = $new;

  $pdo->prepare("UPDATE iaos_contact_settings SET page_title=?, page_subtitle=?, bg_image=? WHERE id=1")
      ->execute([$title, $subtitle, $bg]);

  header("Location: admin_contact.php?saved=1"); exit;
}

/* ---------- INTRO ---------- */
if ($action === 'save_intro') {
  $heading = $_POST['intro_heading'] ?? '';
  $text = $_POST['intro_text'] ?? '';
  $pdo->prepare("UPDATE iaos_contact_settings SET intro_heading=?, intro_text=? WHERE id=1")
      ->execute([$heading, $text]);
  header("Location: admin_contact.php?saved=1"); exit;
}

/* ---------- CATEGORIES ---------- */
if ($action === 'add_category') {
  $t = $_POST['title'] ?? '';
  $d = $_POST['description'] ?? '';
  $pos = (int)($_POST['position'] ?? time());
  $pdo->prepare("INSERT INTO iaos_contact_categories (title,description,position) VALUES (?,?,?)")
      ->execute([$t,$d,$pos]);
  header("Location: admin_contact.php?saved=1"); exit;
}

if ($action === 'update_category') {
  $id = (int)($_POST['id'] ?? 0);
  $t  = $_POST['title'] ?? '';
  $d  = $_POST['description'] ?? '';
  $pos = (int)($_POST['position'] ?? 0);
  $act = isset($_POST['is_active']) ? (int)$_POST['is_active'] : 1;

  $pdo->prepare("UPDATE iaos_contact_categories SET title=?, description=?, position=?, is_active=? WHERE id=?")
      ->execute([$t,$d,$pos,$act,$id]);
  header("Location: admin_contact.php?saved=1"); exit;
}

if ($action === 'delete_category') {
  $id = (int)($_POST['id'] ?? 0);
  $pdo->prepare("DELETE FROM iaos_contact_categories WHERE id=?")->execute([$id]);
  header("Location: admin_contact.php?saved=1"); exit;
}

/* ---------- LOCATIONS ---------- */
if ($action === 'add_location') {
  $t = $_POST['title'] ?? '';
  $a = $_POST['address'] ?? '';
  $mq = $_POST['map_query'] ?? '';
  $pos = (int)($_POST['position'] ?? time());
  $pdo->prepare("INSERT INTO iaos_contact_locations (title,address,map_query,position) VALUES (?,?,?,?)")
      ->execute([$t,$a,$mq,$pos]);
  header("Location: admin_contact.php?saved=1"); exit;
}

if ($action === 'update_location') {
  $id = (int)($_POST['id'] ?? 0);
  $t  = $_POST['title'] ?? '';
  $a  = $_POST['address'] ?? '';
  $mq = $_POST['map_query'] ?? '';
  $pos = (int)($_POST['position'] ?? 0);
  $act = isset($_POST['is_active']) ? (int)$_POST['is_active'] : 1;

  $pdo->prepare("UPDATE iaos_contact_locations SET title=?, address=?, map_query=?, position=?, is_active=? WHERE id=?")
      ->execute([$t,$a,$mq,$pos,$act,$id]);
  header("Location: admin_contact.php?saved=1"); exit;
}

if ($action === 'delete_location') {
  $id = (int)($_POST['id'] ?? 0);
  $pdo->prepare("DELETE FROM iaos_contact_locations WHERE id=?")->execute([$id]);
  header("Location: admin_contact.php?saved=1"); exit;
}

/* fallback */
header("Location: admin_contact.php");
