<?php
ob_start();
require_once "db.php"; // admin DB
$uploadDir = "../uploads/events_page/";

// Ensure upload folder exists
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

// ------------------------------------------------------
//  SAVE PAGE HEADER
// ------------------------------------------------------
if ($_POST['action'] === "save_header") {

    $page_title = trim($_POST['page_title']);
    $page_subtitle = trim($_POST['page_subtitle']);

    // Load existing to preserve old image
    $old = $pdo->query("SELECT bg_image FROM events_page_header WHERE id=1")->fetch(PDO::FETCH_ASSOC);
    $bg_image = $old['bg_image'];

    // ✅ Handle file upload
    if (!empty($_FILES['bg_image']['name'])) {
        $ext = pathinfo($_FILES['bg_image']['name'], PATHINFO_EXTENSION);
        $newName = "header_" . time() . "." . $ext;
        $target = $uploadDir . $newName;

        if (move_uploaded_file($_FILES['bg_image']['tmp_name'], $target)) {
            $bg_image = "uploads/events_page/" . $newName;
        }
    }

    // ✅ Update DB
    $stmt = $pdo->prepare("
        UPDATE events_page_header 
        SET page_title = ?, page_subtitle = ?, bg_image = ?
        WHERE id = 1
    ");
    $stmt->execute([$page_title, $page_subtitle, $bg_image]);

    header("Location: admin_events_page.php?saved=1");
    exit;
}


// ------------------------------------------------------
//  SAVE INTRO SECTION
// ------------------------------------------------------
if ($_POST['action'] === "save_intro") {

    $heading = trim($_POST['intro_heading']);
    $paragraph = trim($_POST['intro_paragraph']);

    $stmt = $pdo->prepare("
        UPDATE events_page_intro
        SET heading = ?, paragraph = ?
        WHERE id = 1
    ");
    $stmt->execute([$heading, $paragraph]);

    header("Location: admin_events_page.php?saved=1");
    exit;
}


// ------------------------------------------------------
//  INVALID ACTION
// ------------------------------------------------------
header("Location: admin_events_page.php?error=invalid_action");
exit;

?>
